/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;

public class ConstructorDeclarationPattern
extends ConstructorPattern {
    public int modifiers;
    public char[][] parameterTypes;
    public char[][] parameterNames;

    public ConstructorDeclarationPattern(char[] declaringSimpleName, int matchRule) {
        this(matchRule);
        this.declaringSimpleName = this.isCaseSensitive || this.isCamelCase ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.findDeclarations = true;
        this.findReferences = false;
        this.parameterCount = -1;
    }

    ConstructorDeclarationPattern(int matchRule) {
        super(matchRule);
    }

    public SearchPattern getBlankPattern() {
        return new ConstructorDeclarationPattern(8);
    }

    public char[][] getIndexCategories() {
        return DECL_CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        ConstructorDeclarationPattern pattern = (ConstructorDeclarationPattern)decodedPattern;
        return (this.parameterCount == pattern.parameterCount || this.parameterCount == -1 || this.varargs) && this.matchesName(this.declaringSimpleName, pattern.declaringSimpleName);
    }

    public void decodeIndexKey(char[] key) {
        int last = key.length - 1;
        int slash = CharOperation.indexOf('/', key, 0);
        this.declaringSimpleName = CharOperation.subarray(key, 0, slash);
        int start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        last = slash - 1;
        this.parameterCount = 0;
        int power = 1;
        int i = last;
        while (i >= start) {
            this.parameterCount = i == last ? key[i] - 48 : (this.parameterCount += (power *= 10) * (key[i] - 48));
            --i;
        }
        this.modifiers = 0;
        this.parameterTypes = null;
        this.parameterNames = null;
        start = slash + 1;
        if (this.parameterCount == 0) {
            last = (slash += 3) - 1;
            this.modifiers = key[last - 1] + (key[last] << 16);
        } else if (this.parameterCount > 0) {
            slash = CharOperation.indexOf('/', key, start);
            last = slash - 1;
            this.parameterTypes = CharOperation.splitOn(',', key, start, slash);
            start = slash + 1;
            slash = CharOperation.indexOf('/', key, start);
            last = slash - 1;
            if (slash != start) {
                this.parameterNames = CharOperation.splitOn(',', key, start, slash);
            }
            last = (slash += 3) - 1;
            this.modifiers = key[last - 1] + (key[last] << 16);
        } else {
            this.modifiers = 1;
        }
    }

    public static char[] createDeclarationIndexKey(char[] typeName, int parameterCount, char[][] parameterTypes, char[][] parameterNames, int modifiers) {
        char[] countChars;
        char[] parameterTypesChars = null;
        char[] parameterNamesChars = null;
        char[] cArray = countChars = parameterCount < 10 ? COUNTS[parameterCount] : ("/" + String.valueOf(parameterCount)).toCharArray();
        if (parameterCount > 0) {
            if (parameterTypes != null && parameterTypes.length == parameterCount) {
                char[][] parameterTypeErasures = new char[parameterCount][];
                int i = 0;
                while (i < parameterTypes.length) {
                    parameterTypeErasures[i] = ConstructorDeclarationPattern.getTypeErasure(parameterTypes[i]);
                    ++i;
                }
                parameterTypesChars = CharOperation.concatWith((char[][])parameterTypeErasures, ',', false);
            }
            if (parameterNames != null && parameterNames.length == parameterCount) {
                parameterNamesChars = CharOperation.concatWith(parameterNames, ',');
            }
        }
        int typeNameLength = typeName == null ? 0 : typeName.length;
        int countCharsLength = countChars.length;
        int parameterTypesLength = parameterTypesChars == null ? 0 : parameterTypesChars.length;
        int parameterNamesLength = parameterNamesChars == null ? 0 : parameterNamesChars.length;
        int resultLength = typeNameLength + countCharsLength;
        if (parameterCount > 0) {
            resultLength += parameterTypesLength + parameterNamesLength + 2;
        }
        char[] result = new char[resultLength += 3];
        int pos = 0;
        if (typeNameLength > 0) {
            System.arraycopy(typeName, 0, result, pos, typeNameLength);
            pos += typeNameLength;
        }
        if (countCharsLength > 0) {
            System.arraycopy(countChars, 0, result, pos, countCharsLength);
            pos += countCharsLength;
        }
        if (parameterCount > 0) {
            result[pos++] = 47;
            if (parameterTypesLength > 0) {
                System.arraycopy(parameterTypesChars, 0, result, pos, parameterTypesLength);
                pos += parameterTypesLength;
            }
            result[pos++] = 47;
            if (parameterNamesLength > 0) {
                System.arraycopy(parameterNamesChars, 0, result, pos, parameterNamesLength);
                pos += parameterNamesLength;
            }
        }
        result[pos++] = 47;
        result[pos++] = (char)modifiers;
        result[pos++] = (char)(modifiers >> 16);
        return result;
    }

    private static char[] getTypeErasure(char[] typeName) {
        char[] typeErasurename = new char[]{};
        if (typeName != null) {
            int index = CharOperation.indexOf('<', typeName);
            if (index == -1) {
                return typeName;
            }
            int length = typeName.length;
            typeErasurename = new char[length - 2];
            System.arraycopy(typeName, 0, typeErasurename, 0, index);
            int depth = 1;
            int i = index + 1;
            while (i < length) {
                switch (typeName[i]) {
                    case '<': {
                        ++depth;
                        break;
                    }
                    case '>': {
                        --depth;
                        break;
                    }
                    default: {
                        if (depth != 0) break;
                        typeErasurename[index++] = typeName[i];
                    }
                }
                ++i;
            }
            char[] cArray = typeErasurename;
            typeErasurename = new char[index];
            System.arraycopy(cArray, 0, typeErasurename, 0, index);
        }
        return typeErasurename;
    }
}

