/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui.tabs.output;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xsl.internal.debug.ui.Messages;
import org.eclipse.wst.xsl.internal.debug.ui.ResourceSelectionBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.launching.XSLTRuntime;

public class OutputFileBlock
extends ResourceSelectionBlock {
    private Button openFileCheckButton;
    private Button formatFileCheckButton;
    private String inputFilename;
    private Text fileNameText;
    private String defaultOutputFileName;
    private String outputFileName;

    public OutputFileBlock() {
        super(2, true, true, false);
    }

    protected String getMessage(int type) {
        switch (type) {
            case 1: {
                return Messages.OutputFOFileBlock_DIRECTORY_NOT_SPECIFIED;
            }
            case 2: {
                return Messages.OutputFOFileBlock_DIRECTORY_DOES_NOT_EXIST;
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return Messages.OutputFileBlock_0;
            }
            case 5: {
                return Messages.OutputFOFileBlock_OTHER_RADIO;
            }
            case 6: {
                return Messages.OutputFOFileBlock_DIALOG_MESSAGE;
            }
            case 7: {
                return Messages.OutputFOFileBlock_WORKSPACE_DIALOG_MESSAGE;
            }
            case 8: {
                return Messages.OutputFOFileBlock_VARIABLES_BUTTON;
            }
            case 9: {
                return Messages.OutputFOFileBlock_FILE_SYSTEM_BUTTON;
            }
            case 10: {
                return Messages.OutputFOFileBlock_WORKSPACE_BUTTON;
            }
            case 11: {
                return Messages.OutputFOFileBlock_WORKSPACE_DIALOG_TITLE;
            }
        }
        return "" + type;
    }

    protected void createCheckboxAndText(Composite parent) {
        if (this.showDefault) {
            this.useDefaultCheckButton = this.createCheckButton(parent, this.getMessage(4));
            GridData gd = new GridData(32);
            gd.horizontalSpan = 2;
            this.useDefaultCheckButton.setLayoutData((Object)gd);
            this.useDefaultCheckButton.addSelectionListener((SelectionListener)this.widgetListener);
        }
        Composite specificFileComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginLeft = this.showDefault ? 20 : 0;
        layout.marginHeight = 0;
        specificFileComp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        specificFileComp.setLayoutData((Object)gd);
        Label label = new Label(specificFileComp, 0);
        label.setText(Messages.OutputFileBlock_1);
        this.fileNameText = new Text(specificFileComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = this.showDefault ? 1 : 2;
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.setFont(parent.getFont());
        this.fileNameText.addModifyListener((ModifyListener)this.widgetListener);
        if (this.showDefault) {
            label = new Label(specificFileComp, 0);
            label.setText(Messages.OutputFileBlock_7);
        }
        this.resourceText = new Text(specificFileComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = this.showDefault ? 1 : 2;
        this.resourceText.setLayoutData((Object)gd);
        this.resourceText.setFont(parent.getFont());
        this.resourceText.addModifyListener((ModifyListener)this.widgetListener);
    }

    protected void createButtons(Composite parent) {
        Composite checkComposite = new Composite(parent, 0);
        checkComposite.setLayoutData((Object)new GridData(32));
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        checkComposite.setLayout((Layout)gl);
        this.openFileCheckButton = this.createCheckButton(checkComposite, Messages.OutputFileBlock_8);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 1;
        this.openFileCheckButton.setLayoutData((Object)gd);
        this.openFileCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (OutputFileBlock.this.openFileCheckButton.getSelection()) {
                    OutputFileBlock.this.formatFileCheckButton.setEnabled(true);
                    OutputFileBlock.this.updateLaunchConfigurationDialog();
                } else {
                    OutputFileBlock.this.formatFileCheckButton.setEnabled(false);
                    OutputFileBlock.this.formatFileCheckButton.setSelection(false);
                }
            }
        });
        this.formatFileCheckButton = this.createCheckButton(checkComposite, Messages.OutputFileBlock_2);
        gd = new GridData(32);
        gd.horizontalSpan = 1;
        this.formatFileCheckButton.setLayoutData((Object)gd);
        this.formatFileCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OutputFileBlock.this.updateLaunchConfigurationDialog();
            }
        });
        Composite buttonComp = new Composite(parent, 128);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        gd = new GridData(130);
        gd.horizontalSpan = 1;
        buttonComp.setLayoutData((Object)gd);
        buttonComp.setFont(parent.getFont());
        this.fWorkspaceButton = this.createPushButton(buttonComp, this.getMessage(10), null);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.fFileSystemButton = this.createPushButton(buttonComp, this.getMessage(9), null);
        this.fFileSystemButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.fVariablesButton = this.createPushButton(buttonComp, this.getMessage(8), null);
        this.fVariablesButton.addSelectionListener((SelectionListener)this.widgetListener);
    }

    public String getName() {
        return Messages.OutputFileBlock_9;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.inputFilename = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_INPUT_FILE", "");
            this.updateDefaultOutputFile();
            boolean useDefault = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", true);
            this.useDefaultCheckButton.setSelection(useDefault);
            this.outputFileName = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILENAME", this.defaultOutputFileName);
            this.resource = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FOLDER", this.defaultResource);
            this.updateResourceText(useDefault);
            boolean openFileOnCompletion = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", true);
            this.openFileCheckButton.setSelection(openFileOnCompletion);
            boolean formatFileOnCompletion = configuration.getAttribute("org.eclipse.wst.xsl.launching.ATTR_FORMAT_FILE", false);
            this.formatFileCheckButton.setSelection(formatFileOnCompletion);
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean useDefault = this.useDefaultCheckButton.getSelection();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", useDefault);
        String outputFile = this.resourceText.getText();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FOLDER", outputFile);
        String outputFileName = this.fileNameText.getText();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILENAME", outputFileName);
        boolean openFileOnCompletion = this.openFileCheckButton.getSelection();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", openFileOnCompletion);
        boolean formatFileOnCompletion = this.formatFileCheckButton.getSelection();
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_FORMAT_FILE", formatFileOnCompletion);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_USE_DEFAULT_OUTPUT_FILE", true);
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FOLDER", null);
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OUTPUT_FILENAME", null);
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_OPEN_FILE", true);
        configuration.setAttribute("org.eclipse.wst.xsl.launching.ATTR_FORMAT_FILE", false);
    }

    protected void updateResourceText(boolean useDefault) {
        this.fileNameText.setEnabled(!useDefault);
        if (useDefault) {
            this.fileNameText.setText(this.defaultOutputFileName == null ? "" : this.defaultOutputFileName);
        } else {
            this.fileNameText.setText(this.outputFileName == null ? this.defaultOutputFileName : this.outputFileName);
        }
        super.updateResourceText(useDefault);
    }

    private void updateDefaultOutputFile() {
        try {
            IPath path = XSLTRuntime.defaultOutputFileForInputFile((String)this.inputFilename);
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(path);
            if (files.length > 0) {
                Path p = new Path(files[0].getProject().getName());
                p.append(files[0].getParent().getProjectRelativePath());
                this.defaultResource = "${workspace_loc:/" + p.toString() + "}";
            } else {
                IPath p = path.removeLastSegments(1);
                this.defaultResource = p.toOSString();
            }
            this.defaultOutputFileName = path.lastSegment();
        }
        catch (CoreException coreException) {}
    }
}

