/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.jface.NavigatorContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProviderFactory;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProviderFactory;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.navigator.JaxbNavigatorItemLabelProviderFactory;
import org.eclipse.jpt.jaxb.ui.internal.navigator.JaxbNavigatorTreeItemContentProviderFactory;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;

public class JaxbNavigatorContentProvider
extends NavigatorContentProvider {
    private final CollectionChangeListener jaxbProjectListener = this.buildJaxbProjectListener();
    private StructuredViewer viewer;

    public JaxbNavigatorContentProvider() {
        JptJaxbCorePlugin.getProjectManager().addCollectionChangeListener("jaxbProjects", this.jaxbProjectListener);
    }

    protected CollectionChangeListener buildJaxbProjectListener() {
        return new JaxbProjectListener();
    }

    protected ItemTreeContentProviderFactory buildItemContentProviderFactory() {
        return new JaxbNavigatorTreeItemContentProviderFactory();
    }

    protected ItemExtendedLabelProviderFactory buildItemLabelProviderFactory() {
        return new JaxbNavigatorItemLabelProviderFactory();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = (StructuredViewer)viewer;
    }

    protected boolean hasChildren_(Object element) {
        JaxbProject jaxbProject;
        IProject project;
        if (element instanceof IAdaptable && (project = (IProject)((IAdaptable)element).getAdapter(IProject.class)) != null && (jaxbProject = JptJaxbCorePlugin.getJaxbProject((IProject)project)) != null) {
            JaxbPlatformDescription desc = jaxbProject.getPlatform().getDescription();
            JaxbPlatformUi platformUi = JptJaxbUiPlugin.getJaxbPlatformUiManager().getJaxbPlatformUi(desc);
            return platformUi != null;
        }
        return false;
    }

    protected Object[] getChildren_(Object parentElement) {
        JaxbProject jaxbProject;
        IProject project;
        if (parentElement instanceof IAdaptable && (project = (IProject)((IAdaptable)parentElement).getAdapter(IProject.class)) != null && (jaxbProject = JptJaxbCorePlugin.getJaxbProject((IProject)project)) != null) {
            JaxbPlatformDescription desc = jaxbProject.getPlatform().getDescription();
            JaxbPlatformUi platformUi = JptJaxbUiPlugin.getJaxbPlatformUiManager().getJaxbPlatformUi(desc);
            if (platformUi != null) {
                return new Object[]{jaxbProject.getContextRoot()};
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        JptJaxbCorePlugin.getProjectManager().removeCollectionChangeListener("jaxbProjects", this.jaxbProjectListener);
    }

    class JaxbProjectListener
    implements CollectionChangeListener {
        JaxbProjectListener() {
        }

        public void collectionChanged(CollectionChangeEvent event) {
            this.refreshViewer(null);
        }

        public void collectionCleared(CollectionClearEvent event) {
            this.refreshViewer(null);
        }

        public void itemsAdded(CollectionAddEvent event) {
            for (Object item : event.getItems()) {
                this.refreshViewer(((JaxbProject)item).getProject());
            }
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            for (Object item : event.getItems()) {
                this.refreshViewer(((JaxbProject)item).getProject());
            }
        }

        private void refreshViewer(final IProject project) {
            if (JaxbNavigatorContentProvider.this.viewer != null && JaxbNavigatorContentProvider.this.viewer.getControl() != null && !JaxbNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                Job refreshJob = new Job("Refresh viewer"){

                    protected IStatus run(IProgressMonitor monitor) {
                        JaxbNavigatorContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (project != null) {
                                    JaxbNavigatorContentProvider.this.viewer.refresh((Object)project);
                                } else {
                                    JaxbNavigatorContentProvider.this.viewer.refresh();
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.setRule((ISchedulingRule)project);
                refreshJob.schedule();
            }
        }
    }
}

