/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ProjectAction
implements IObjectActionDelegate {
    private ISelection currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }

    protected IStructuredSelection getCurrentSelection() {
        if (this.currentSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)this.currentSelection;
        }
        return null;
    }

    public void run(IAction action) {
        if (this.currentSelection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)this.currentSelection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object each = objectArray[n2];
                this.execute(each);
                ++n2;
            }
        }
    }

    protected void execute(Object selection) {
        IProject project = this.projectFromSelection(selection);
        if (project != null) {
            this.execute(project);
        }
    }

    protected IProject projectFromSelection(Object selection) {
        if (selection instanceof IProject) {
            return (IProject)selection;
        }
        if (selection instanceof IJavaProject) {
            return ((IJavaProject)selection).getProject();
        }
        return null;
    }

    protected JpaPlatformUi getJpaPlatformUi(JpaProject project) {
        return (JpaPlatformUi)project.getJpaPlatform().getAdapter(JpaPlatformUi.class);
    }

    protected void execute(IProject project) {
        JpaProject jpaProject = this.getJpaProject(project);
        if (jpaProject != null) {
            this.execute(jpaProject);
        }
    }

    protected JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    protected abstract void execute(JpaProject var1);
}

