/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractJavaMetadataConversionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.execute_(event);
        return null;
    }

    protected void execute_(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        JpaProject jpaProject = this.convertSelectionToJpaProject(selection.getFirstElement());
        if (jpaProject != null) {
            this.convertJavaMetadata(jpaProject);
        }
    }

    protected abstract void convertJavaMetadata(JpaProject var1);

    protected JpaProject convertSelectionToJpaProject(Object sel) {
        try {
            return sel == null ? null : this.convertSelectionToJpaProject_(sel);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected JpaProject convertSelectionToJpaProject_(Object sel) throws InterruptedException {
        JpaProject jpaProject = (JpaProject)PlatformTools.getAdapter((Object)sel, JpaProject.class);
        if (jpaProject != null) {
            return jpaProject;
        }
        IProject project = this.convertSelectionToProject(sel);
        if (project == null) {
            return null;
        }
        JpaProject.Reference ref = (JpaProject.Reference)project.getAdapter(JpaProject.Reference.class);
        return ref == null ? null : ref.getValue();
    }

    protected IProject convertSelectionToProject(Object sel) {
        IResource resource = (IResource)PlatformTools.getAdapter((Object)sel, IResource.class);
        if (resource != null) {
            return resource.getProject();
        }
        IJavaProject javaProject = this.convertSelectionToJavaProject(sel);
        return javaProject == null ? null : javaProject.getProject();
    }

    protected IJavaProject convertSelectionToJavaProject(Object sel) {
        IJavaElement javaElement = (IJavaElement)PlatformTools.getAdapter((Object)sel, IJavaElement.class);
        return javaElement == null ? null : javaElement.getJavaProject();
    }

    protected JpaPlatformUi getJpaPlatformUi(JpaProject jpaProject) {
        return (JpaPlatformUi)jpaProject.getJpaPlatform().getAdapter(JpaPlatformUi.class);
    }
}

