/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.editors;

import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.FormWidgetFactory;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.PersistenceXmlResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.details.JpaPageComposite;
import org.eclipse.jpt.jpa.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceEditor
extends FormEditor {
    private StructuredTextEditor editor;
    private ModifiablePropertyValueModel<IFileEditorInput> editorInputHolder;
    private WidgetFactory widgetFactory;
    final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public PersistenceEditor() {
        this.initialize();
    }

    public Object getAdapter(Class adapterClass) {
        Object adapter = super.getAdapter(adapterClass);
        return adapter != null ? adapter : this.editor.getAdapter(adapterClass);
    }

    protected void addPages() {
        this.addPersistenceUnitPages();
        this.addXMLEditorPage();
    }

    private void addPersistenceUnitPages() {
        JpaProject jpaProject = this.getJpaProject();
        if (jpaProject == null) {
            return;
        }
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return;
        }
        JptResourceType resourceType = persistenceXml.getResourceType();
        if (resourceType == null) {
            return;
        }
        JpaPlatformUi jpaPlatformUI = (JpaPlatformUi)jpaProject.getJpaPlatform().getAdapter(JpaPlatformUi.class);
        PersistenceXmlResourceUiDefinition definition = (PersistenceXmlResourceUiDefinition)jpaPlatformUI.getResourceUiDefinition(resourceType);
        ListIterator<JpaPageComposite> puPages = definition.buildPersistenceUnitComposites(this.buildPersistenceUnitHolder(), this.getContainer(), this.widgetFactory);
        while (puPages.hasNext()) {
            JpaPageComposite page = puPages.next();
            try {
                Page formPage = new Page(page);
                this.addPage((IFormPage)formPage);
            }
            catch (PartInitException partInitException) {}
        }
    }

    private void addXMLEditorPage() {
        try {
            this.editor = new StructuredTextEditor();
            this.editor.setEditorPart((IEditorPart)this);
            int index = this.addPage((IEditorPart)this.editor, (IEditorInput)this.getEditorInput());
            this.setPageText(index, JptUiPersistenceMessages.PersistenceEditor_sourceTab);
        }
        catch (PartInitException partInitException) {}
    }

    private ModifiablePropertyValueModel<IFileEditorInput> buildEditorInputHolder() {
        return new SimplePropertyValueModel();
    }

    private PropertyValueModel<JpaProject> buildJpaProjectHolder() {
        return new TransformationPropertyValueModel<IFileEditorInput, JpaProject>(this.editorInputHolder){

            protected JpaProject transform_(IFileEditorInput fileEditorInput) {
                return PersistenceEditor.this.getJpaProject(fileEditorInput.getFile().getProject());
            }
        };
    }

    private PropertyValueModel<Persistence> buildPersistenceHolder() {
        return new PropertyAspectAdapter<PersistenceXml, Persistence>(this.buildPersistenceXmlHolder(), new String[]{"persistence"}){

            protected Persistence buildValue_() {
                return ((PersistenceXml)this.subject).getPersistence();
            }
        };
    }

    private PropertyValueModel<PersistenceUnit> buildPersistenceUnitHolder() {
        return new ListPropertyValueModelAdapter<PersistenceUnit>(this.buildPersistenceUnitListHolder()){

            protected PersistenceUnit buildValue() {
                return this.listModel.size() > 0 ? (PersistenceUnit)this.listModel.get(0) : null;
            }
        };
    }

    private ListValueModel<PersistenceUnit> buildPersistenceUnitListHolder() {
        return new ListAspectAdapter<Persistence, PersistenceUnit>(this.buildPersistenceHolder(), new String[]{"persistenceUnits"}){

            protected ListIterable<PersistenceUnit> getListIterable() {
                return ((Persistence)this.subject).getPersistenceUnits();
            }

            protected int size_() {
                return ((Persistence)this.subject).getPersistenceUnitsSize();
            }
        };
    }

    private PropertyValueModel<PersistenceXml> buildPersistenceXmlHolder() {
        return new PropertyAspectAdapter<JpaRootContextNode, PersistenceXml>(this.buildRootContextNodeHolder(), new String[]{"persistenceXml"}){

            protected PersistenceXml buildValue_() {
                return ((JpaRootContextNode)this.subject).getPersistenceXml();
            }
        };
    }

    private PropertyValueModel<JpaRootContextNode> buildRootContextNodeHolder() {
        return new TransformationPropertyValueModel<JpaProject, JpaRootContextNode>(this.buildJpaProjectHolder()){

            protected JpaRootContextNode transform_(JpaProject jpaProject) {
                return jpaProject.getRootContextNode();
            }
        };
    }

    private WidgetFactory buildWidgetFactory() {
        return new FormWidgetFactory((FormToolkit)new TabbedPropertySheetWidgetFactory());
    }

    public void dispose() {
        this.editorInputHolder.setValue(null);
        this.resourceManager.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(this.getPageCount() - 1).doSave(monitor);
    }

    public void doSaveAs() {
    }

    public IFileEditorInput getEditorInput() {
        return (IFileEditorInput)super.getEditorInput();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        Assert.isLegal((boolean)(editorInput instanceof IFileEditorInput), (String)"Invalid Input: Must be IFileEditorInput");
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
        this.editorInputHolder.setValue((Object)this.getEditorInput());
    }

    private void initialize() {
        this.widgetFactory = this.buildWidgetFactory();
        this.editorInputHolder = this.buildEditorInputHolder();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected JpaProject getJpaProject() {
        return this.getJpaProject(this.getEditorInput().getFile().getProject());
    }

    protected JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    class Page
    extends FormPage {
        private final JpaPageComposite page;
        private ImageDescriptor imageDescriptor;

        Page(JpaPageComposite page) {
            super((FormEditor)PersistenceEditor.this, page.getClass().getName(), page.getPageText());
            this.page = page;
        }

        protected void createFormContent(IManagedForm managedForm) {
            ScrolledForm form = managedForm.getForm();
            managedForm.getToolkit().decorateFormHeading(form.getForm());
            this.updateForm(form);
            this.updateBody(form);
            this.updateHelpButton();
            form.updateToolBar();
        }

        public void dispose() {
            this.page.dispose();
            if (this.imageDescriptor != null) {
                PersistenceEditor.this.resourceManager.destroyImage(this.imageDescriptor);
            }
            super.dispose();
        }

        public void setFocus() {
            this.page.getControl().setFocus();
        }

        private void updateBody(ScrolledForm form) {
            Composite body = form.getBody();
            body.setLayout((Layout)new TableWrapLayout());
            TableWrapData wrapData = new TableWrapData(256, 256);
            this.page.getControl().setLayoutData((Object)wrapData);
            this.page.getControl().setParent(body);
        }

        private void updateForm(ScrolledForm form) {
            form.setText(this.page.getPageText());
            this.imageDescriptor = this.page.getPageImageDescriptor();
            if (this.imageDescriptor != null) {
                form.setImage(PersistenceEditor.this.resourceManager.createImage(this.imageDescriptor));
            }
        }

        private void updateHelpButton() {
            String helpID = this.page.getHelpID();
            if (helpID != null) {
                HelpAction helpAction = new HelpAction(helpID);
                ScrolledForm form = this.getManagedForm().getForm();
                IToolBarManager manager = form.getToolBarManager();
                manager.add((IAction)helpAction);
            }
        }

        private class HelpAction
        extends Action {
            final String helpID;

            HelpAction(String helpID) {
                super(JptUiPersistenceMessages.PersistenceEditor_page_help, JFaceResources.getImageRegistry().getDescriptor("dialog_help_image"));
                this.helpID = helpID;
            }

            public void run() {
                BusyIndicator.showWhile((Display)Page.this.getManagedForm().getForm().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelp(HelpAction.this.helpID);
                    }
                });
            }
        }
    }
}

