/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaWindowManager;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.jpt.jpa.ui.selection.JpaViewManager;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

class JpaWorkbenchManager
implements JpaSelectionManager {
    private final IWorkbench workbench;
    private final Hashtable<IWorkbenchWindow, JpaWindowManager> windowManagers = new Hashtable();
    private static final Hashtable<IWorkbench, JpaWorkbenchManager> WORKBENCH_MANAGERS = new Hashtable();
    private static final boolean DEBUG = false;
    private static final String DATE_FORMAT_PATTERN = "yyyy.MM.dd HH:mm:ss.SSS";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");

    private JpaWorkbenchManager(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public void setSelection(JpaStructureNode selection) {
        this.getWindowManager(this.workbench.getActiveWorkbenchWindow()).setSelection(selection);
    }

    private JpaSelectionManager getWindowManager(IWorkbenchWindow window) {
        return window == null ? JpaSelectionManager.Null.instance() : this.getWindowManager_(window);
    }

    private JpaSelectionManager getWindowManager_(IWorkbenchWindow window) {
        JpaWindowManager manager = this.windowManagers.get(window);
        return manager != null ? manager : JpaSelectionManager.Null.instance();
    }

    private JpaViewManager.PageManager getPageManager_(IViewPart view) {
        return this.getWindowManager(view).getPageManager(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JpaWindowManager getWindowManager(IViewPart view) {
        IWorkbenchWindow window = view.getSite().getWorkbenchWindow();
        Hashtable<IWorkbenchWindow, JpaWindowManager> hashtable = this.windowManagers;
        synchronized (hashtable) {
            JpaWindowManager manager = this.windowManagers.get(window);
            if (manager == null) {
                JpaWorkbenchManager.debug("add window manager:", window);
                manager = new JpaWindowManager(this, window);
                this.windowManagers.put(window, manager);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWindowManager(IWorkbenchWindow window) {
        Hashtable<IWorkbenchWindow, JpaWindowManager> hashtable = this.windowManagers;
        synchronized (hashtable) {
            JpaWorkbenchManager.debug("remove window manager:", window);
            this.windowManagers.remove(window);
            if (this.windowManagers.isEmpty()) {
                this.dispose();
            }
        }
    }

    private void dispose() {
        JpaWorkbenchManager.debug("remove workbench manager:", this.workbench);
        WORKBENCH_MANAGERS.remove(this.workbench);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.workbench);
    }

    static JpaSelectionManager forWorkbench(IWorkbench workbench) {
        return workbench == null ? JpaSelectionManager.Null.instance() : JpaWorkbenchManager.forWorkbench_(workbench);
    }

    private static JpaSelectionManager forWorkbench_(IWorkbench workbench) {
        JpaWorkbenchManager manager = WORKBENCH_MANAGERS.get(workbench);
        return manager != null ? manager : JpaSelectionManager.Null.instance();
    }

    static JpaSelectionManager forWindow(IWorkbenchWindow window) {
        return window == null ? JpaSelectionManager.Null.instance() : JpaWorkbenchManager.forWindow_(window);
    }

    private static JpaSelectionManager forWindow_(IWorkbenchWindow window) {
        JpaWorkbenchManager manager = WORKBENCH_MANAGERS.get(window.getWorkbench());
        return manager == null ? JpaSelectionManager.Null.instance() : manager.getWindowManager_(window);
    }

    static JpaViewManager.PageManager getPageManager(IViewPart view) {
        if (view == null) {
            throw new NullPointerException();
        }
        return JpaWorkbenchManager.getWorkbenchManager(view).getPageManager_(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JpaWorkbenchManager getWorkbenchManager(IViewPart view) {
        IWorkbench workbench = view.getSite().getWorkbenchWindow().getWorkbench();
        Hashtable<IWorkbench, JpaWorkbenchManager> hashtable = WORKBENCH_MANAGERS;
        synchronized (hashtable) {
            JpaWorkbenchManager manager = WORKBENCH_MANAGERS.get(workbench);
            if (manager == null) {
                JpaWorkbenchManager.debug("add workbench manager:", workbench);
                manager = new JpaWorkbenchManager(workbench);
                WORKBENCH_MANAGERS.put(workbench, manager);
            }
            return manager;
        }
    }

    static void debug(String message) {
        JpaWorkbenchManager.debug(message, null);
    }

    static void debug(String message, Object object) {
        JpaWorkbenchManager.debug(message, object, null);
    }

    static void debug(String message, Object object, Object additionalInfo) {
    }

    private static void debug_(String message, Object object, Object additionalInfo) {
        System.out.print(JpaWorkbenchManager.buildTimestamp());
        System.out.print(" ");
        System.out.print(Thread.currentThread().getName());
        System.out.print(": ");
        System.out.print(message);
        if (object != null) {
            System.out.print(" ");
            System.out.print(object);
            if (additionalInfo != null) {
                System.out.print(" (");
                System.out.print(additionalInfo);
                System.out.print(")");
            }
        }
        System.out.println();
    }

    private static synchronized String buildTimestamp() {
        return DATE_FORMAT.format(new Date());
    }
}

