/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromptJPAProjectWizardPage
extends WizardPage {
    protected static String SELECT_PROJECT_PAGE_NAME = "SelectJPAProject";
    protected Table projTable;
    private TableViewer projTableViewer;
    private static int PROJECT_NAME_COLUMN_INDEX = 0;
    private final String helpContextId;

    public PromptJPAProjectWizardPage(String helpContextId) {
        super(SELECT_PROJECT_PAGE_NAME);
        this.setTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_selectJPAProject);
        this.setMessage(JptUiEntityGenMessages.GenerateEntitiesWizard_selectJPAProject_msg);
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_selectJPAProject);
        this.projTableViewer = new TableViewer(composite, 268438020);
        this.projTable = this.projTableViewer.getTable();
        GridData gd = new GridData(4, 4, true, true);
        this.projTable.setLayoutData((Object)gd);
        this.projTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromptJPAProjectWizardPage.this.handleJpaProjectSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.projTableViewer = new TableViewer(this.projTable);
        this.projTableViewer.setLabelProvider((IBaseLabelProvider)new ProjectTableLabelProvider());
        this.projTableViewer.setContentProvider((IContentProvider)new ProjectTableContentProvider());
        this.fillJpaProjectList();
        this.setControl((Control)composite);
        this.validate();
    }

    protected void handleJpaProjectSelection() {
        if (this.projTable.getSelectionIndex() != -1) {
            TableItem item = this.projTable.getItem(this.projTable.getSelectionIndex());
            String projName = item.getText(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            JpaProject jpaProj = this.getJpaProject(project);
            ((GenerateEntitiesFromSchemaWizard)this.getWizard()).setJpaProject(jpaProj);
            this.validate();
        }
    }

    private void fillJpaProjectList() {
        this.projTableViewer.setInput((Object)this.getSortedJpaProjectsNames());
    }

    private String[] getSortedJpaProjectsNames() {
        return (String[])ArrayTools.sort((Object[])this.getJpaProjectsNames());
    }

    private String[] getJpaProjectsNames() {
        return (String[])ArrayTools.array((Iterable)new TransformationIterable<IProject, String>(this.getJpaProjects()){

            protected String transform(IProject project) {
                return project.getName();
            }
        }, (Object[])new String[0]);
    }

    private Iterable<IProject> getJpaProjects() {
        return new FilteringIterable<IProject>((Iterable)CollectionTools.collection(this.getProjects())){

            protected boolean accept(IProject next) {
                return PromptJPAProjectWizardPage.this.projectIsValidSelection(PromptJPAProjectWizardPage.this.getJpaProject(next));
            }
        };
    }

    protected boolean projectIsValidSelection(JpaProject jpaProject) {
        return jpaProject != null;
    }

    private Iterator<IProject> getProjects() {
        return new ArrayIterator((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }

    private JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    protected void validate() {
        if (this.projTable.getSelectionIndex() != -1) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public final void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContextId);
    }

    private final class ProjectTableContentProvider
    implements IStructuredContentProvider {
        private ProjectTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (String[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ProjectTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProjectTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == PROJECT_NAME_COLUMN_INDEX) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            assert (element instanceof String);
            String projectName = (String)element;
            if (columnIndex == PROJECT_NAME_COLUMN_INDEX) {
                return projectName;
            }
            return null;
        }
    }
}

