/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.parts.ConnectionEditPart;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.ui.JPADiagramEditorInput;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorContextMenuProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorDiagramTypeProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.EntitiesCoordinatesXML;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPACheckSum;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.Wrp;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class JPADiagramEditor
extends DiagramEditor {
    public static final String ID = "org.eclipse.jpt.jpadiagrameditor.ui";
    private DefaultEditDomain editDomain;
    private JavaPersistentType inputJptType;
    private ISelectionManagerFactory jpaSelectionManagerFactory;

    public JPADiagramEditor() {
        this(new SelectionManagerFactoryImpl());
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
    }

    public JPADiagramEditor(ISelectionManagerFactory jpaSelectionManagerFactory) {
        this.jpaSelectionManagerFactory = jpaSelectionManagerFactory;
        this.editDomain = new DefaultEditDomain((IEditorPart)this);
    }

    public JPAEditorDiagramTypeProvider getDiagramTypeProvider() {
        return (JPAEditorDiagramTypeProvider)super.getDiagramTypeProvider();
    }

    public IFeatureProvider getFeatureProvider() {
        return this.getDiagramTypeProvider().getFeatureProvider();
    }

    public Object getAdapter(Class type) {
        if (IPropertySheetPage.class.equals((Object)type)) {
            return null;
        }
        return super.getAdapter(type);
    }

    public void saveWithoutEntities(IProgressMonitor monitor) {
        final Diagram d = this.getDiagramTypeProvider().getDiagram();
        final Wrp wrp = new Wrp();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)d);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                JPACheckSum.INSTANCE().assignEntityShapesMD5Strings(d, ModelIntegrationUtil.getProjectByDiagram(d.getName()));
                EList children = d.getChildren();
                Iterator chIt = children.iterator();
                boolean save = true;
                while (chIt.hasNext()) {
                    ContainerShape sh = (ContainerShape)chIt.next();
                    JavaPersistentType jpt = (JavaPersistentType)JPADiagramEditor.this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
                    String entName = JPAEditorUtil.getText(jpt);
                    ICompilationUnit cu = JPAEditorUtil.getCompilationUnit(jpt);
                    try {
                        if (cu.hasUnsavedChanges()) {
                            entName = "* " + entName;
                            save = false;
                        }
                    }
                    catch (JavaModelException e) {
                        JPADiagramEditorPlugin.logError("Problem with compilation unit", e);
                    }
                    GraphicsUpdater.updateHeader(sh, entName);
                }
                wrp.setObj(new Boolean(save));
            }
        });
        if (((Boolean)wrp.getObj()).booleanValue()) {
            super.doSave(monitor);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        final Diagram d = this.getDiagramTypeProvider().getDiagram();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)d);
        if (d == null || ted == null) {
            JPADiagramEditorPlugin.logError(d == null ? "Diagram is null" : "TransactionalEditingDomain is null", new Exception());
            return;
        }
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                JPACheckSum.INSTANCE().assignEntityShapesMD5Strings(d, ModelIntegrationUtil.getProjectByDiagram(d.getName()));
                EList children = d.getChildren();
                for (Shape sh : children) {
                    JavaPersistentType jpt = (JavaPersistentType)JPADiagramEditor.this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)sh);
                    if (jpt == null) continue;
                    JpaArtifactFactory.instance().forceSaveEntityClass(jpt, (IJPAEditorFeatureProvider)JPADiagramEditor.this.getFeatureProvider());
                }
            }
        });
        EntitiesCoordinatesXML xml = new EntitiesCoordinatesXML(d.getName());
        xml.store();
        xml.close();
        super.doSave(monitor);
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new JPAEditorContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry(), (IDiagramTypeProvider)this.getDiagramTypeProvider());
    }

    private void initWithFileEditorInput(IEditorSite site, IFile entityFile) {
        Diagram diagram = null;
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(site.getShell());
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(JPAEditorMessages.JPADiagramEditor_waitingForMoin, -1);
                    monitor.done();
                }
            });
            this.inputJptType = JPAEditorUtil.getJPType(JavaCore.createCompilationUnitFrom((IFile)entityFile));
            this.setPartProperty("JPADiagramEditor_openWholePersistenceUnit", this.inputJptType.getName());
            PersistenceUnit persistenceUnit = this.inputJptType.getPersistenceUnit();
            String diagramURIAsString = ModelIntegrationUtil.createDiagramPath(persistenceUnit).toString();
            URI diagramURI = URI.createFileURI((String)diagramURIAsString);
            diagram = ModelIntegrationUtil.createDiagram(persistenceUnit, 10, true);
            JPADiagramEditorInput diagramInput = new JPADiagramEditorInput(diagram, diagramURI, "org.eclipse.jpt.jpadiagrameditor.ui.provider.JPAEditorDiagramTypeProvider");
            super.init(site, (IEditorInput)diagramInput);
        }
        catch (CoreException e) {
            JPADiagramEditorPlugin.getDefault().getLog().log(e.getStatus());
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, ID, e.getMessage(), (Throwable)e);
            JPADiagramEditorPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (InterruptedException e) {
            Status status = new Status(4, ID, e.getMessage(), (Throwable)e);
            JPADiagramEditorPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IFile entityFile = (IFile)input.getAdapter(IFile.class);
        if (entityFile != null && entityFile.getFileExtension().equals("java")) {
            this.initWithFileEditorInput(site, entityFile);
        } else {
            if (input instanceof IFileEditorInput) {
                throw new PartInitException(NLS.bind((String)JPAEditorMessages.JPADiagramEditor_openDiagramErrorMSG, (Object)entityFile.getName()));
            }
            super.init(site, input);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSel = (IStructuredSelection)selection;
        for (Object object : structSel) {
            EditPart editPart;
            if (!(object instanceof EditPart) || !((editPart = (EditPart)object) instanceof ConnectionEditPart)) continue;
            ConnectionEditPart connectionEditPart = (ConnectionEditPart)editPart;
            connectionEditPart.removeEditPolicy((Object)"Connection Bendpoint Policy");
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        if (o instanceof EditPart) {
            JpaSelectionManager selectionManager = this.getJpaSelectionManager(part);
            Object m = ((EditPart)o).getModel();
            if (m == null) {
                return;
            }
            if (m instanceof PictogramElement) {
                Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)m);
                if (bo == null || !(bo instanceof JpaStructureNode)) {
                    return;
                }
                selectionManager.setSelection((JpaStructureNode)bo);
                return;
            }
        }
    }

    private JpaSelectionManager getJpaSelectionManager(IWorkbenchPart part) {
        return this.jpaSelectionManagerFactory.getSelectionManager(part.getSite().getWorkbenchWindow());
    }

    public DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    public static interface ISelectionManagerFactory {
        public JpaSelectionManager getSelectionManager(IWorkbenchWindow var1);
    }

    private static class SelectionManagerFactoryImpl
    implements ISelectionManagerFactory {
        private SelectionManagerFactoryImpl() {
        }

        @Override
        public JpaSelectionManager getSelectionManager(IWorkbenchWindow window) {
            return (JpaSelectionManager)PlatformTools.getAdapter((Object)window, JpaSelectionManager.class);
        }
    }
}

