/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model.DynamicEntityField;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicEntityTemplateModel {
    protected IDataModel dataModel;
    private static final String DOT = ".";
    private static final String PK_SUFFIX = "PK";
    private static final String DEFAULT_EMBEDDED_ID_NAME = "id";

    public DynamicEntityTemplateModel(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public String getClassName() {
        return this.getProperty("NewJavaClassDataModel.CLASS_NAME").trim();
    }

    public String getJavaPackageName() {
        return this.getProperty("NewJavaClassDataModel.JAVA_PACKAGE").trim();
    }

    public String getQualifiedJavaClassName() {
        if (!this.getJavaPackageName().equals("")) {
            return String.valueOf(this.getJavaPackageName()) + DOT + this.getClassName();
        }
        return this.getClassName();
    }

    protected String getProperty(String propertyName) {
        return this.dataModel.getStringProperty(propertyName);
    }

    public boolean isMappingXMLDefault() {
        if (this.getMappingXMLName().equals("")) {
            return true;
        }
        return this.getMappingXMLName().equals(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
    }

    public String getMappingXMLName() {
        return this.dataModel.getStringProperty("IEntityDataModelProperties.XML_NAME").trim();
    }

    public IFile getMappingXmlFile() {
        IPackageFragmentRoot[] sourceFragments;
        IFile ormFile = null;
        IProject project = this.getProject();
        IPackageFragmentRoot[] iPackageFragmentRootArray = sourceFragments = J2EEProjectUtilities.getSourceContainers((IProject)project);
        int n = sourceFragments.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
            ormFile = project.getFile(String.valueOf(packageFragmentRoot.getResource().getName()) + File.separator + this.getMappingXMLName());
            if (ormFile.exists()) break;
            ++n2;
        }
        return ormFile;
    }

    public String getEntityName() {
        return this.getProperty("IEntityDataModelProperties.ENTITY_NAME").trim();
    }

    public boolean isEntityNameSet() {
        boolean result = false;
        if (!StringTools.stringIsEmpty((String)this.getEntityName()) && !this.getClassName().equals(this.getEntityName())) {
            result = true;
        }
        return result;
    }

    public boolean isTableNameSet() {
        return !this.dataModel.getBooleanProperty("IEntityDataModelProperties.TABLE_NAME_DEFAULT");
    }

    public String getTableName() {
        return this.getProperty("IEntityDataModelProperties.TABLE_NAME").trim();
    }

    public List<DynamicEntityField> getEntityFields() {
        ArrayList fields = (ArrayList)this.dataModel.getProperty("IEntityDataModelProperties.ENTITY_FIELDS");
        if (fields == null) {
            return new ArrayList<DynamicEntityField>();
        }
        return fields;
    }

    public boolean isCompositePK() {
        return this.getPKFields().size() > 1;
    }

    public List<DynamicEntityField> getPKFields() {
        return (ArrayList)this.dataModel.getProperty("IEntityDataModelProperties.PK_FIELDS");
    }

    public String getEmbeddableClassName() {
        return String.valueOf(this.getQualifiedJavaClassName()) + PK_SUFFIX;
    }

    public String getDefaultEmbeddedIdName() {
        return DEFAULT_EMBEDDED_ID_NAME;
    }

    public IProject getProject() {
        String projectName = this.dataModel.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }
}

