/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.gen.internal.Association;
import org.eclipse.jpt.jpa.gen.internal.AssociationRole;
import org.eclipse.jpt.jpa.gen.internal.ORMGenColumn;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.util.DTPUtil;
import org.eclipse.jpt.jpa.gen.internal.util.EntityGenTools;
import org.eclipse.jpt.jpa.gen.internal.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORMGenTable {
    private ORMGenCustomizer mCustomizer;
    private List<ORMGenColumn> mColumns;
    private Table mDbTable;
    private HashMap<String, String> columnTypesMap = null;
    public static final String PUBLIC_SCOPE = "public";
    public static final String PROTECTED_SCOPE = "protected";
    public static final String PRIVATE_SCOPE = "private";
    public static final String PROPERTY_ACCESS = "property";
    public static final String FIELD_ACCESS = "field";
    public static final String DEFAULT_FETCH = "defaultFetch";
    public static final String LAZY_FETCH = "lazy";
    public static final String EAGER_FETCH = "eager";
    public static final String LIST_COLLECTION_TYPE = "java.util.List";
    public static final String SET_COLLECTION_TYPE = "java.util.Set";
    public static final String TABLE_SEQ_PATTERN = "$table";
    public static final String PK_SEQ_PATTERN = "$pk";
    protected static final String PACKAGE = "package";
    private static final String SRC_FOLDER = "srcFolder";
    private static final String CLASS_NAME = "className";
    private static final String CLASS_DESC = "classDesc";
    private static final String CLASS_SCOPE = "classScope";
    private static final String EXTENDS = "extends";
    private static final String IMPLEMENTS = "implements";
    private static final String ID_GENERATOR = "idGenerator";
    private static final String SEQUENCE = "sequence";
    private static final String COMPOSITE_KEY_CLASS_NAME = "compositeKeyClassName";
    private static final String IMPLEMENT_EQUALS = "implementEquals";
    private static final String ACCESS = "access";
    private static final String DEFAULT_COLLECTION_TYPE = "defaultCollectionType";

    public ORMGenTable(Table table, ORMGenCustomizer customizer) {
        this.mDbTable = table;
        this.mCustomizer = customizer;
    }

    public ORMGenCustomizer getCustomizer() {
        return this.mCustomizer;
    }

    public boolean isDefaultsTable() {
        return this.mDbTable == null;
    }

    protected String customized(String propName) {
        return this.getCustomizer().getProperty(propName, this.getTableName(), null);
    }

    protected boolean customizedBoolean(String propName) {
        return this.getCustomizer().getBooleanProperty(propName, this.getTableName(), null);
    }

    protected void setCustomized(String propName, String value) {
        if (value != null && value.length() == 0) {
            value = null;
        }
        this.getCustomizer().setProperty(propName, value, this.getTableName(), null);
    }

    protected void setCustomizedBoolean(String propName, boolean value, boolean defaultValue) {
        if (defaultValue == value) {
            this.setCustomized(propName, null);
        } else {
            this.getCustomizer().setBooleanProperty(propName, value, this.getTableName(), null);
        }
    }

    public Table getDbTable() {
        return this.mDbTable;
    }

    public String getTableName() {
        return this.mDbTable != null ? this.mDbTable.getName() : "__anyTable__";
    }

    public String getName() {
        if (this.mDbTable == null) {
            return "__anyTable__";
        }
        String tableName = this.getTableName();
        String annotationName = this.mCustomizer.getDatabaseAnnotationNameBuilder().buildTableAnnotationName(tableName, this.mDbTable);
        return annotationName != null ? annotationName : tableName;
    }

    public String getJoinTableAnnotationName() {
        if (this.mDbTable == null) {
            return "__anyTable__";
        }
        String annotationName = this.mCustomizer.getDatabaseAnnotationNameBuilder().buildJoinTableAnnotationName(this.mDbTable);
        return annotationName != null ? annotationName : this.mDbTable.getName();
    }

    public String getSchema() {
        if (DTPUtil.isDefaultSchema(this.mDbTable) || this.mDbTable.getSchema() == null) {
            return "";
        }
        String schemaName = this.mDbTable.getSchema().getName();
        return schemaName;
    }

    public void setSourceFolder(String srcFolder) {
        this.setCustomized(SRC_FOLDER, srcFolder);
    }

    public String getSourceFolder() {
        String srcFolder = this.customized(SRC_FOLDER);
        return srcFolder == null ? "" : srcFolder;
    }

    public String getImportStatements() {
        this.buildColumnTypesMap();
        Set<String> packages = this.columnTypesMap.keySet();
        StringBuilder ret = new StringBuilder();
        for (String s : packages) {
            ret.append("import " + s + ";\n");
        }
        List<AssociationRole> associationRoles = this.getAssociationRoles();
        for (AssociationRole role : associationRoles) {
            if (!role.getCardinality().equals("one-to-many") && !role.getCardinality().equals("many-to-many")) continue;
            ret.append("import " + this.getDefaultCollectionType() + ";\n");
            break;
        }
        return ret.toString();
    }

    private String getJavaxPersistenceImportStatements() {
        StringBuilder ret = new StringBuilder();
        ret.append("import javax.persistence.Entity;\n");
        ret.append("import javax.persistence.Column;\n");
        ret.append("import javax.persistence.Id;\n");
        if (!this.isDefaultname()) {
            ret.append("import javax.persistence.Table;\n");
        }
        if (this.isCompositeKey()) {
            ret.append("import javax.persistence.EmbeddedId;\n");
        }
        HashSet<String> jpaImports = new HashSet<String>();
        List<AssociationRole> associationRoles = this.getAssociationRoles();
        for (AssociationRole role : associationRoles) {
            if (role.getCardinality().equals("one-to-one")) {
                jpaImports.add("import javax.persistence.OneToOne;");
                continue;
            }
            if (role.getCardinality().equals("one-to-many")) {
                jpaImports.add("import javax.persistence.OneToMany;\n");
                continue;
            }
            if (role.getCardinality().equals("many-to-one")) {
                jpaImports.add("import javax.persistence.ManyToOne;\n");
                jpaImports.add("import javax.persistence.JoinColumn;\n");
                continue;
            }
            if (!role.getCardinality().equals("many-to-many")) continue;
            jpaImports.add("import javax.persistence.ManyToMany;\n");
            jpaImports.add("import javax.persistence.JoinTable;\n");
            jpaImports.add("import javax.persistence.JoinColumns;\n");
            jpaImports.add("import javax.persistence.JoinColumn;\n");
        }
        for (String s : jpaImports) {
            ret.append(s);
        }
        return ret.toString();
    }

    public HashMap<String, String> buildColumnTypesMap() {
        if (this.columnTypesMap != null) {
            return this.columnTypesMap;
        }
        this.columnTypesMap = new HashMap();
        for (ORMGenColumn col : this.getColumns()) {
            String type = col.getPropertyType();
            if (col.isPartOfCompositePrimaryKey() || col.isForeignKey() || type.startsWith("java.lang") || type.indexOf(46) <= 0) continue;
            String simpleType = type.substring(type.lastIndexOf(46) + 1);
            this.columnTypesMap.put(type, simpleType);
        }
        return this.columnTypesMap;
    }

    public String getSimplifiedColType(String fqtn) {
        HashMap<String, String> map = this.buildColumnTypesMap();
        String typeName = map.get(fqtn);
        if (typeName != null) {
            return typeName;
        }
        return fqtn;
    }

    public void setPackage(String pkg) {
        this.getCustomizer().setProperty(PACKAGE, pkg, this.getName(), null);
    }

    public String getPackage() {
        String packageName = this.customized(PACKAGE);
        return packageName == null ? "" : packageName;
    }

    public String getClassName() {
        String name = this.customized(CLASS_NAME);
        if (name == null) {
            name = EntityGenTools.convertToUniqueJavaStyleClassName(this.getTableName(), new ArrayList<String>());
            name = StringUtil.singularise(name);
        }
        return name;
    }

    public void setClassName(String className) {
        if (!StringUtil.equalObjects(className, this.getClassName())) {
            this.setCustomized(CLASS_NAME, className);
        }
    }

    public String getVarName(boolean singular) {
        String name = StringUtil.tableNameToVarName(this.getTableName());
        name = singular ? StringUtil.singularise(name) : StringUtil.pluralise(name);
        return name;
    }

    public String getQualifiedClassName() {
        return this.qualify(this.getClassName());
    }

    public String getCompositeKeyClassName() {
        String name = this.customized(COMPOSITE_KEY_CLASS_NAME);
        if (name == null) {
            name = String.valueOf(this.getClassName()) + "PK";
        }
        return name;
    }

    public String getQualifiedCompositeKeyClassName() {
        return this.qualify(this.getCompositeKeyClassName());
    }

    public String getCompositeKeyPropertyName() {
        return "id";
    }

    public List<ORMGenColumn> getColumns() {
        if (this.mColumns == null) {
            this.mColumns = new ArrayList<ORMGenColumn>();
            for (Column c : this.mDbTable.getColumns()) {
                ORMGenColumn genColumn = this.getCustomizer().createGenColumn(c);
                genColumn.setGenTable(this);
                this.mColumns.add(genColumn);
            }
        }
        return this.mColumns;
    }

    public List<String> getColumnNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Column c : this.mDbTable.getColumns()) {
            ret.add(c.getName());
        }
        return ret;
    }

    public List<ORMGenColumn> getPrimaryKeyColumns() {
        ArrayList<ORMGenColumn> ret = new ArrayList<ORMGenColumn>();
        for (Column column : this.mDbTable.getPrimaryKeyColumns()) {
            ret.add(new ORMGenColumn(column, this.mCustomizer));
        }
        return ret;
    }

    public ORMGenColumn getPrimaryKeyColumn() {
        ORMGenColumn pkCol = null;
        List<ORMGenColumn> pkColumns = this.getPrimaryKeyColumns();
        if (pkColumns.size() == 1) {
            pkCol = pkColumns.get(0);
        } else {
            List<ORMGenColumn> columns = this.getColumns();
            int i = 0;
            int n = columns.size();
            while (i < n) {
                ORMGenColumn column = columns.get(i);
                if (column.getMappingKind().equals(this.mCustomizer.getIdMappingKind())) {
                    pkCol = column;
                    break;
                }
                ++i;
            }
        }
        return pkCol;
    }

    public boolean isCompositeKey() {
        return this.mDbTable.getPrimaryKeyColumnsSize() > 1;
    }

    public List<ORMGenColumn> getSimpleColumns(boolean genOnly, boolean includePk, boolean includeInherited) {
        ArrayList<ORMGenColumn> result = new ArrayList<ORMGenColumn>();
        List<ORMGenColumn> columns = this.getColumns();
        List<AssociationRole> roles = this.getAssociationRoles();
        int i = 0;
        int n = columns.size();
        while (i < n) {
            ORMGenColumn column = columns.get(i);
            if (!genOnly || column.isGenerated()) {
                if (column.isPrimaryKey()) {
                    if (includePk && !this.isCompositeKey()) {
                        result.add(0, column);
                    }
                } else if (!this.isColumnInAsscociation(column, roles)) {
                    result.add(column);
                }
            }
            ++i;
        }
        return result;
    }

    public List<ORMGenColumn> getSimpleColumns() {
        return this.getSimpleColumns(true, true, true);
    }

    public boolean isColumnUpdateInsert(AssociationRole role, ORMGenColumn column) {
        if (column == null) {
            for (ORMGenColumn c : role.getReferrerColumns()) {
                if (this.isColumnUpdateInsert(role, c)) continue;
                return false;
            }
            return true;
        }
        return !column.isPrimaryKey();
    }

    public List<ORMGenColumn> getColumnsByNames(List<String> names) {
        ArrayList<ORMGenColumn> result = new ArrayList<ORMGenColumn>();
        for (String name : names) {
            ORMGenColumn column = this.getColumnByName(name);
            assert (column != null);
            if (column == null) continue;
            result.add(column);
        }
        return result;
    }

    public ORMGenColumn getColumnByName(String name) {
        List<ORMGenColumn> columns = this.getColumns();
        int i = 0;
        int n = columns.size();
        while (i < n) {
            ORMGenColumn column = columns.get(i);
            if (column.getName().equals(name)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public List<AssociationRole> getAssociationRoles() {
        ArrayList<AssociationRole> associationRoles = new ArrayList<AssociationRole>();
        String name = this.getName();
        List<Association> associations = this.mCustomizer.getAssociations();
        for (Association association : associations) {
            AssociationRole role;
            if (!association.isGenerated()) continue;
            if (association.getReferrerTable().getName().equals(name) && (role = association.getReferrerRole()) != null) {
                associationRoles.add(role);
            }
            if (!association.getReferencedTable().getName().equals(name) || (role = association.getReferencedRole()) == null) continue;
            associationRoles.add(role);
        }
        return associationRoles;
    }

    public String getClassDescription() {
        return this.customized(CLASS_DESC);
    }

    public String getClassScope() {
        String scope = this.customized(CLASS_SCOPE);
        if (scope == null) {
            scope = PUBLIC_SCOPE;
        }
        return scope;
    }

    public String getExtends() {
        return this.customized(EXTENDS);
    }

    public void setExtends(String baseClass) {
        this.setCustomized(EXTENDS, baseClass);
    }

    public List<String> getImplements() {
        String str = this.customized(IMPLEMENTS);
        List<String> result = StringUtil.strToList(str, ',', true);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public void setImplements(List<String> interfaces) {
        this.setCustomized(IMPLEMENTS, StringUtil.listToStr(interfaces, ','));
    }

    public String generateExtendsImplements() {
        StringBuffer buffer = new StringBuffer();
        String extendsClass = this.getExtends();
        if (extendsClass != null && !extendsClass.equals("java.lang.Object") && !extendsClass.equals("Object")) {
            buffer.append("extends " + this.simplifyClassName(extendsClass) + " ");
        }
        buffer.append("implements Serializable");
        Iterator<String> iter = this.getImplements().iterator();
        while (iter.hasNext()) {
            buffer.append(", " + this.simplifyClassName(iter.next()));
        }
        return buffer.toString();
    }

    private String simplifyClassName(String fullClassName) {
        if (fullClassName.startsWith("java.lang.")) {
            return fullClassName.substring("java.lang.".length());
        }
        String pkg = StringUtil.getPackageName(fullClassName);
        if (pkg != null && StringUtil.equalObjects(pkg, this.getPackage())) {
            return StringUtil.getClassName(fullClassName);
        }
        return fullClassName;
    }

    public String getIdGenerator() {
        ORMGenColumn pkColumn;
        String generator = this.customized(ID_GENERATOR);
        String noneGenerator = this.getCustomizer().getNoIdGenerator();
        if (!this.isDefaultsTable() && (generator == null || generator.equals(noneGenerator)) && (pkColumn = this.getPrimaryKeyColumn()) != null && DTPUtil.isAutoIncrement(pkColumn.getDbColumn())) {
            generator = this.getCustomizer().getIdentityIdGenerator();
        }
        if (generator == null) {
            generator = noneGenerator;
        }
        return generator;
    }

    public void setIdGenerator(String scheme) {
        this.setCustomized(ID_GENERATOR, scheme);
    }

    public String getSequence() {
        return this.customized(SEQUENCE);
    }

    public void setSequence(String name) {
        this.setCustomized(SEQUENCE, name);
    }

    public String getFormattedSequence() {
        String sequence = this.getSequence();
        if (sequence != null && (sequence = StringUtil.strReplace(sequence, TABLE_SEQ_PATTERN, this.getName())).indexOf(PK_SEQ_PATTERN) >= 0) {
            Iterator pkCols = this.getDbTable().getPrimaryKeyColumns().iterator();
            String pkName = pkCols.hasNext() ? ((Column)pkCols.next()).getName() : null;
            sequence = StringUtil.strReplace(sequence, PK_SEQ_PATTERN, pkName);
        }
        return sequence != null ? sequence.toUpperCase() : "";
    }

    public boolean isImplementEquals() {
        return !"true".equals(this.customized(IMPLEMENT_EQUALS));
    }

    public void setImplementEquals(boolean value) {
        this.setCustomizedBoolean(IMPLEMENT_EQUALS, value, true);
    }

    public boolean hasColumnsInEquals() {
        List<ORMGenColumn> columns = this.getSimpleColumns();
        int i = 0;
        int n = columns.size();
        while (i < n) {
            ORMGenColumn column = columns.get(i);
            if (column.isUseInEquals()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isGenerateDDLAnnotations() {
        return "true".equals(this.customized("generateDDLAnnotations"));
    }

    public void setGenerateDDLAnnotations(boolean generate) {
        this.setCustomizedBoolean("generateDDLAnnotations", generate, false);
    }

    public String getAccess() {
        String name = this.customized(ACCESS);
        if (name == null) {
            name = FIELD_ACCESS;
        }
        return name;
    }

    public void setAccess(String access) {
        assert (access == null || access.equals(PROPERTY_ACCESS) || access.equals(FIELD_ACCESS));
        if (!StringUtil.equalObjects(access, this.getAccess())) {
            this.setCustomized(ACCESS, access);
        }
    }

    public String getDefaultFetch() {
        return this.customized(DEFAULT_FETCH);
    }

    public void setDefaultFetch(String fetch) {
        assert (fetch == null || fetch.equals(LAZY_FETCH) || fetch.equals(EAGER_FETCH));
        this.setCustomized(DEFAULT_FETCH, fetch);
    }

    public String[] getSupportedCollectionTypes() {
        return new String[]{SET_COLLECTION_TYPE, LIST_COLLECTION_TYPE};
    }

    public String getDefaultCollectionType() {
        String cType = this.customized(DEFAULT_COLLECTION_TYPE);
        if (cType == null) {
            cType = LIST_COLLECTION_TYPE;
        }
        return cType;
    }

    public String getSimpleCollectionType() {
        String type = this.getDefaultCollectionType();
        return type.substring(type.lastIndexOf(46) + 1);
    }

    public void setDefaultCollectionType(String cType) {
        assert (cType.equals(LIST_COLLECTION_TYPE) || cType.equals(SET_COLLECTION_TYPE));
        this.setCustomized(DEFAULT_COLLECTION_TYPE, cType);
    }

    public boolean isCompoundKeyUseInEquals() {
        if (this.isCompositeKey()) {
            for (ORMGenColumn column : this.getPrimaryKeyColumns()) {
                if (!column.isUseInEquals()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRoleUseInEquals(AssociationRole role) {
        for (ORMGenColumn column : role.getReferrerColumns()) {
            if (!column.isUseInEquals()) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultname() {
        String entityName = this.getClassName();
        String annotationName = this.mCustomizer.getDatabaseAnnotationNameBuilder().buildTableAnnotationName(entityName, this.mDbTable);
        return annotationName == null;
    }

    private String qualify(String className) {
        String pkg = this.getPackage();
        if (pkg != null && pkg.length() != 0) {
            className = String.valueOf(pkg) + '.' + className;
        }
        return className;
    }

    private boolean isColumnInAsscociation(ORMGenColumn column, List<AssociationRole> roles) {
        int i = 0;
        int n = roles.size();
        while (i < n) {
            AssociationRole role = roles.get(i);
            List<ORMGenColumn> cols = role.getReferrerColumns();
            for (ORMGenColumn col : cols) {
                if (!col.getName().equals(column.getName())) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getPrimaryKeyEqualsClause() {
        StringBuilder buf = new StringBuilder();
        Iterator<ORMGenColumn> columns = this.getPrimaryKeyColumns().iterator();
        while (columns.hasNext()) {
            this.printPrimaryKeyEqualsClauseOn(columns.next(), buf);
            if (!columns.hasNext()) continue;
            buf.append("\n");
            buf.append("\t\t\t");
            buf.append("&& ");
        }
        buf.append(";");
        return buf.toString();
    }

    private void printPrimaryKeyEqualsClauseOn(ORMGenColumn column, StringBuilder buf) {
        String fieldName = column.getPropertyName();
        JavaType javaType = column.getDbColumn().getPrimaryKeyJavaType();
        if (javaType.isPrimitive()) {
            this.printPrimitiveEqualsClauseOn(fieldName, buf);
        } else {
            this.printReferenceEqualsClauseOn(fieldName, buf);
        }
    }

    private void printPrimitiveEqualsClauseOn(String fieldName, StringBuilder buf) {
        buf.append("(this.");
        buf.append(fieldName);
        buf.append(" == castOther.");
        buf.append(fieldName);
        buf.append(')');
    }

    private void printReferenceEqualsClauseOn(String fieldName, StringBuilder buf) {
        buf.append("this.");
        buf.append(fieldName);
        buf.append(".equals(castOther.");
        buf.append(fieldName);
        buf.append(')');
    }

    public String getPrimaryKeyHashCodeClause() {
        StringBuilder buf = new StringBuilder();
        Iterator<ORMGenColumn> columns = this.getPrimaryKeyColumns().iterator();
        while (columns.hasNext()) {
            buf.append("hash = hash * prime + ");
            this.printPrimaryKeyHashCodeClauseOn(columns.next(), buf);
            buf.append(';');
            buf.append('\n');
            buf.append("\t\t");
        }
        return buf.toString();
    }

    private void printPrimaryKeyHashCodeClauseOn(ORMGenColumn column, StringBuilder buf) {
        String fieldName = column.getPropertyName();
        JavaType javaType = column.getDbColumn().getPrimaryKeyJavaType();
        if (javaType.isPrimitive()) {
            this.printPrimitiveHashCodeClauseOn(javaType.getElementTypeName(), fieldName, buf);
        } else {
            this.printReferenceHashCodeClauseOn(fieldName, buf);
        }
    }

    private void printPrimitiveHashCodeClauseOn(String primitiveName, String fieldName, StringBuilder buf) {
        if (primitiveName.equals("int")) {
            buf.append("this.");
            buf.append(fieldName);
        } else if (primitiveName.equals("short") || primitiveName.equals("byte") || primitiveName.equals("char")) {
            buf.append("((int) this.");
            buf.append(fieldName);
            buf.append(')');
        } else if (primitiveName.equals("long")) {
            buf.append("((int) (this.");
            buf.append(fieldName);
            buf.append(" ^ (this.");
            buf.append(fieldName);
            buf.append(" >>> 32)))");
        } else if (primitiveName.equals("float")) {
            buf.append("java.lang.Float");
            buf.append(".floatToIntBits(this.");
            buf.append(fieldName);
            buf.append(')');
        } else if (primitiveName.equals("double")) {
            buf.append("((int) (");
            buf.append("java.lang.Double");
            buf.append(".doubleToLongBits(this.");
            buf.append(fieldName);
            buf.append(") ^ (");
            buf.append("java.lang.Double");
            buf.append(".doubleToLongBits(this.");
            buf.append(fieldName);
            buf.append(") >>> 32)))");
        } else if (primitiveName.equals("boolean")) {
            buf.append("(this.");
            buf.append(fieldName);
            buf.append(" ? 1 : 0)");
        } else {
            throw new IllegalArgumentException(primitiveName);
        }
    }

    private void printReferenceHashCodeClauseOn(String fieldName, StringBuilder buf) {
        buf.append("this.");
        buf.append(fieldName);
        buf.append(".hashCode()");
    }

    public String toString() {
        return "name=" + this.getName() + "; columns=" + Arrays.toString(this.getColumnNames().toArray());
    }
}

