/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.structure;

import org.eclipse.jpt.common.ui.internal.jface.StaticItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProviderFactory;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.OrmPersistentTypeItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.structure.EntityMappingsItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.structure.JpaFileItemContentProvider;

public class OrmStructureItemContentProviderFactory
implements ItemTreeContentProviderFactory {
    private static final ItemTreeContentProviderFactory INSTANCE = new OrmStructureItemContentProviderFactory();

    public static ItemTreeContentProviderFactory instance() {
        return INSTANCE;
    }

    protected OrmStructureItemContentProviderFactory() {
    }

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        if (item instanceof JpaFile) {
            return this.buildJpaFileProvider((JpaFile)item, manager);
        }
        if (item instanceof EntityMappings) {
            return this.buildEntityMappingsProvider((EntityMappings)item, manager);
        }
        if (item instanceof OrmPersistentType) {
            return this.buildOrmPersistentTypeProvider((OrmPersistentType)item, manager);
        }
        if (item instanceof OrmPersistentAttribute) {
            return this.buildOrmPersistentAttributeProvider((OrmPersistentAttribute)item, manager);
        }
        return null;
    }

    protected ItemTreeContentProvider buildJpaFileProvider(JpaFile item, ItemTreeContentProvider.Manager manager) {
        return new JpaFileItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildEntityMappingsProvider(EntityMappings item, ItemTreeContentProvider.Manager manager) {
        return new EntityMappingsItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildOrmPersistentTypeProvider(OrmPersistentType item, ItemTreeContentProvider.Manager manager) {
        return new OrmPersistentTypeItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildOrmPersistentAttributeProvider(OrmPersistentAttribute item, ItemTreeContentProvider.Manager manager) {
        return new StaticItemTreeContentProvider((Object)item.getParent());
    }
}

