/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.structure;

import org.eclipse.jpt.common.ui.internal.jface.StaticItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProviderFactory;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.internal.structure.JpaFileItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.structure.PersistenceItemContentProvider;
import org.eclipse.jpt.jpa.ui.internal.structure.PersistenceUnitItemContentProvider;

public class PersistenceStructureItemContentProviderFactory
implements ItemTreeContentProviderFactory {
    private static final ItemTreeContentProviderFactory INSTANCE = new PersistenceStructureItemContentProviderFactory();

    public static ItemTreeContentProviderFactory instance() {
        return INSTANCE;
    }

    protected PersistenceStructureItemContentProviderFactory() {
    }

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        if (item instanceof JpaFile) {
            return this.buildJpaFileProvider((JpaFile)item, manager);
        }
        if (item instanceof Persistence) {
            return this.buildPersistenceProvider((Persistence)item, manager);
        }
        if (item instanceof PersistenceUnit) {
            return this.buildPersistenceUnitProvider((PersistenceUnit)item, manager);
        }
        if (item instanceof MappingFileRef) {
            return this.buildMappingFileRefProvider((MappingFileRef)item, manager);
        }
        if (item instanceof ClassRef) {
            return this.buildClassRefProvider((ClassRef)item, manager);
        }
        if (item instanceof JarFileRef) {
            return this.buildJarFileRefProvider((JarFileRef)item, manager);
        }
        return null;
    }

    protected ItemTreeContentProvider buildJpaFileProvider(JpaFile item, ItemTreeContentProvider.Manager manager) {
        return new JpaFileItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildPersistenceProvider(Persistence item, ItemTreeContentProvider.Manager manager) {
        return new PersistenceItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildPersistenceUnitProvider(PersistenceUnit item, ItemTreeContentProvider.Manager manager) {
        return new PersistenceUnitItemContentProvider(item, manager);
    }

    protected ItemTreeContentProvider buildMappingFileRefProvider(MappingFileRef item, ItemTreeContentProvider.Manager manager) {
        return new StaticItemTreeContentProvider((Object)item.getPersistenceUnit());
    }

    protected ItemTreeContentProvider buildClassRefProvider(ClassRef item, ItemTreeContentProvider.Manager manager) {
        return new StaticItemTreeContentProvider((Object)item.getPersistenceUnit());
    }

    protected ItemTreeContentProvider buildJarFileRefProvider(JarFileRef item, ItemTreeContentProvider.Manager manager) {
        return new StaticItemTreeContentProvider((Object)item.getPersistenceUnit());
    }
}

