/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.jpa.core.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.prefs.JpaEntityGenPreferencesManager;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.gen.internal.BaseEntityGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.DatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.ORMGenTable;
import org.eclipse.jpt.jpa.gen.internal.PackageGenerator;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.DefaultTableGenerationWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.PromptJPAProjectWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TableAssociationsWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TablesAndColumnsCustomizationWizardPage;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.TablesSelectorWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class GenerateEntitiesFromSchemaWizard
extends Wizard
implements INewWizard {
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.jpa.ui.GenerateEntitiesFromSchemaWizard";
    protected JpaProject jpaProject;
    protected IStructuredSelection selection;
    private ORMGenCustomizer customizer = null;
    private PromptJPAProjectWizardPage projectPage;
    protected TablesSelectorWizardPage tablesSelectorPage;
    protected TableAssociationsWizardPage tableAssociationsPage;
    protected DefaultTableGenerationWizardPage defaultTableGenerationPage;
    protected TablesAndColumnsCustomizationWizardPage tablesAndColumnsCustomizationPage;
    protected final ResourceManager resourceManager;

    public GenerateEntitiesFromSchemaWizard() {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.setWindowTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_generateEntities);
    }

    public GenerateEntitiesFromSchemaWizard(JpaProject jpaProject, IStructuredSelection selection) {
        this.jpaProject = jpaProject;
        this.selection = selection;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.setWindowTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_generateEntities);
        this.setDefaultPageImageDescriptor(JptJpaUiPlugin.getImageDescriptor("full/wizban/new_entity_wizban"));
    }

    public void addPages() {
        this.setForcePreviousAndNextButtons(true);
        if (this.jpaProject == null && this.selection != null) {
            this.jpaProject = this.getJpaProjectFromSelection(this.selection);
        }
        if (!this.projectIsValidSelection(this.jpaProject)) {
            this.projectPage = this.buildProjectWizardPage();
            this.addPage((IWizardPage)this.projectPage);
            return;
        }
        this.addMainPages();
    }

    protected void addMainPages() {
        this.tablesSelectorPage = new TablesSelectorWizardPage(this.jpaProject, this.resourceManager, false);
        this.addPage((IWizardPage)this.tablesSelectorPage);
        this.tableAssociationsPage = new TableAssociationsWizardPage(this.jpaProject, this.resourceManager);
        this.addPage((IWizardPage)this.tableAssociationsPage);
        this.defaultTableGenerationPage = new DefaultTableGenerationWizardPage(this.jpaProject);
        this.addPage((IWizardPage)this.defaultTableGenerationPage);
        this.defaultTableGenerationPage.init(this.selection);
        this.tablesAndColumnsCustomizationPage = new TablesAndColumnsCustomizationWizardPage(this.jpaProject, this.resourceManager);
        this.addPage((IWizardPage)this.tablesAndColumnsCustomizationPage);
        this.tablesAndColumnsCustomizationPage.init(this.selection);
    }

    public ORMGenCustomizer getORMGenCustomizer() {
        return this.customizer;
    }

    public ORMGenCustomizer createORMGenCustomizer(Schema schema) {
        JpaPlatform jpaPlatform = this.jpaProject.getJpaPlatform();
        ORMGenCustomizer obj = (ORMGenCustomizer)PlatformTools.getAdapter((Object)jpaPlatform, ORMGenCustomizer.class);
        if (obj != null) {
            this.customizer = obj;
            this.customizer.init(this.getCustomizationFile(), schema);
        } else {
            this.customizer = new BaseEntityGenCustomizer();
            this.customizer.init(this.getCustomizationFile(), schema);
        }
        ORMGenTable newDefaultTable = this.getCustomizer().createGenTable(null);
        if (this.selection != null && this.selection.getFirstElement() instanceof IPackageFragment) {
            IPackageFragment packageFrag = (IPackageFragment)this.selection.getFirstElement();
            newDefaultTable.setPackage(packageFrag.getElementName());
            for (IPackageFragmentRoot root : JDTTools.getJavaSourceFolders((IJavaProject)this.jpaProject.getJavaProject())) {
                String srcFolder = root.getPath().toPortableString();
                if (!packageFrag.getPath().toPortableString().startsWith(String.valueOf(srcFolder) + '/')) continue;
                newDefaultTable.setSourceFolder(srcFolder.substring(1));
            }
        } else if (newDefaultTable.getPackage().equals("")) {
            JpaEntityGenPreferencesManager preferencesManager = this.buildEntityGenPreferencesManager();
            newDefaultTable.setPackage(preferencesManager.getDefaultPackagePreference());
        }
        return this.customizer;
    }

    protected String getCustomizationFileName() {
        ConnectionProfile profile = this.getProjectConnectionProfile();
        String connection = profile == null ? "" : profile.getName();
        String name = "org.eclipse.jpt.entitygen." + (connection == null ? "" : connection.replace(' ', '-'));
        Schema schema = this.getDefaultSchema();
        if (schema != null) {
            name = String.valueOf(name) + "." + schema.getName();
        }
        return name.toLowerCase();
    }

    private File getCustomizationFile() {
        String projectPath = this.jpaProject.getProject().getLocation().toPortableString();
        File genDir = new File(String.valueOf(projectPath) + "/.settings");
        genDir.mkdirs();
        return new File(genDir, this.getCustomizationFileName());
    }

    public boolean performFinish() {
        if (this.jpaProject == null) {
            return true;
        }
        if (this.customizer == null) {
            return false;
        }
        try {
            this.customizer.setDatabaseAnnotationNameBuilder(this.buildDatabaseAnnotationNameBuilder());
            this.customizer.save();
        }
        catch (IOException e) {
            JptJpaUiPlugin.log(e);
        }
        OverwriteConfirmer overwriteConfirmer = null;
        if (GenerateEntitiesFromSchemaWizard.showOverwriteWarning()) {
            overwriteConfirmer = new OverwriteConfirmer();
        }
        this.scheduleGenerateEntitiesJob(overwriteConfirmer);
        return true;
    }

    protected void scheduleGenerateEntitiesJob(OverwriteConfirmer overwriteConfirmer) {
        GenerateEntitiesJob genEntitiesJob = new GenerateEntitiesJob(this.jpaProject, this.getCustomizer(), overwriteConfirmer, false);
        genEntitiesJob.schedule();
    }

    private JpaEntityGenPreferencesManager buildEntityGenPreferencesManager() {
        return new JpaEntityGenPreferencesManager(this.jpaProject.getProject());
    }

    public static boolean showOverwriteWarning() {
        return OptionalMessageDialog.isDialogEnabled((String)"dontShowOverwriteEntitesFromSchemas.warning");
    }

    private DatabaseAnnotationNameBuilder buildDatabaseAnnotationNameBuilder() {
        return new LocalDatabaseAnnotationNameBuilder(this.jpaProject.getJpaPlatform().getEntityGeneratorDatabaseAnnotationNameBuilder());
    }

    public IWizardPage getStartingPage() {
        if (this.projectPage != null) {
            if (this.tablesSelectorPage != null) {
                return this.tablesSelectorPage;
            }
            return this.projectPage;
        }
        return super.getStartingPage();
    }

    public ORMGenCustomizer getCustomizer() {
        return this.customizer;
    }

    public ConnectionProfile getProjectConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }

    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    public void setJpaProject(JpaProject jpaProject) {
        if (!this.projectIsValidSelection(this.jpaProject)) {
            this.jpaProject = jpaProject;
            IWizardPage currentPage = this.getContainer().getCurrentPage();
            if (this.projectPage != null && currentPage.equals((Object)this.projectPage)) {
                this.addMainPages();
            }
        }
    }

    public Schema getDefaultSchema() {
        return this.getJpaProject().getDefaultDbSchema();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object sel = selection.getFirstElement();
        if (sel instanceof IResource) {
            JpaProject jpaProj;
            IProject proj = ((IResource)sel).getProject();
            this.jpaProject = jpaProj = this.getJpaProject(proj);
        } else if (sel instanceof IPackageFragmentRoot) {
            JpaProject jpaProj;
            IPackageFragmentRoot root = (IPackageFragmentRoot)sel;
            IProject proj = root.getJavaProject().getProject();
            this.jpaProject = jpaProj = this.getJpaProject(proj);
        } else if (sel instanceof IPackageFragment) {
            JpaProject jpaProj;
            IPackageFragment frag = (IPackageFragment)sel;
            IProject proj = frag.getJavaProject().getProject();
            this.jpaProject = jpaProj = this.getJpaProject(proj);
        }
        this.selection = selection;
        this.setWindowTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_generateEntities);
    }

    protected JpaProject getJpaProjectFromSelection(IStructuredSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IProject) {
            return this.getJpaProject((IProject)firstElement);
        }
        if (firstElement instanceof IJavaElement) {
            IProject project = ((IJavaElement)firstElement).getJavaProject().getProject();
            return this.getJpaProject(project);
        }
        return null;
    }

    protected boolean projectIsValidSelection(JpaProject jpaProject) {
        return jpaProject != null;
    }

    protected PromptJPAProjectWizardPage buildProjectWizardPage() {
        return new PromptJPAProjectWizardPage(HELP_CONTEXT_ID);
    }

    protected JpaProject getJpaProject(IProject project) {
        return (JpaProject)project.getAdapter(JpaProject.class);
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    public static class GenerateEntitiesJob
    extends WorkspaceJob {
        final JpaProject jpaProject;
        final ORMGenCustomizer customizer;
        final OverwriteConfirmer confirmer;
        final boolean generateXml;

        public GenerateEntitiesJob(JpaProject jpaProject, ORMGenCustomizer customizer, OverwriteConfirmer confirmer, boolean generateXml) {
            super(JptUiMessages.EntitiesGenerator_jobName);
            this.customizer = customizer;
            this.jpaProject = jpaProject;
            this.confirmer = confirmer;
            this.generateXml = generateXml;
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            this.setRule(ruleFactory.modifyRule((IResource)jpaProject.getProject()));
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            PackageGenerator.generate((JpaProject)this.jpaProject, (ORMGenCustomizer)this.customizer, (org.eclipse.jpt.jpa.gen.internal.OverwriteConfirmer)this.confirmer, (IProgressMonitor)monitor, (boolean)this.generateXml);
            return Status.OK_STATUS;
        }
    }

    static class LocalDatabaseAnnotationNameBuilder
    implements DatabaseAnnotationNameBuilder {
        private EntityGeneratorDatabaseAnnotationNameBuilder builder;

        LocalDatabaseAnnotationNameBuilder(EntityGeneratorDatabaseAnnotationNameBuilder builder) {
            this.builder = builder;
        }

        public String buildTableAnnotationName(String entityName, Table table) {
            return this.builder.buildTableAnnotationName(entityName, table);
        }

        public String buildColumnAnnotationName(String attributeName, Column column) {
            return this.builder.buildColumnAnnotationName(attributeName, column);
        }

        public String buildJoinColumnAnnotationName(String attributeName, ForeignKey foreignKey) {
            return this.builder.buildJoinColumnAnnotationName(attributeName, foreignKey);
        }

        public String buildJoinColumnAnnotationName(Column column) {
            return this.builder.buildJoinColumnAnnotationName(column);
        }

        public String buildJoinTableAnnotationName(Table table) {
            return this.builder.buildJoinTableAnnotationName(table);
        }
    }

    public static class OverwriteConfirmer
    implements org.eclipse.jpt.jpa.gen.internal.OverwriteConfirmer {
        private boolean overwriteAll = false;
        private boolean skipAll = false;

        OverwriteConfirmer() {
        }

        public boolean overwrite(String className) {
            if (this.overwriteAll) {
                return true;
            }
            if (this.skipAll) {
                return false;
            }
            return this.promptUser(className);
        }

        private boolean promptUser(final String className) {
            final boolean[] ret = new boolean[1];
            SWTUtil.syncExec((Runnable)new Runnable(){

                public void run() {
                    OverwriteConfirmerDialog dialog = new OverwriteConfirmerDialog(Display.getCurrent().getActiveShell(), className);
                    dialog.open();
                    if (dialog.getReturnCode() == 1) {
                        OverwriteConfirmer.this.skipAll = true;
                        ret[0] = false;
                        return;
                    }
                    if (dialog.yes()) {
                        ret[0] = true;
                    }
                    if (dialog.yesToAll()) {
                        OverwriteConfirmer.this.overwriteAll = true;
                        ret[0] = true;
                    }
                    if (dialog.no()) {
                        ret[0] = false;
                    }
                    if (dialog.noToAll()) {
                        OverwriteConfirmer.this.skipAll = true;
                        ret[0] = false;
                    }
                }
            });
            return ret[0];
        }
    }

    static class OverwriteConfirmerDialog
    extends OptionalMessageDialog {
        private boolean yes = false;
        private boolean yesToAll = false;
        private boolean no = false;
        private boolean noToAll = false;
        private static final String ID = "dontShowOverwriteEntitesFromSchemas.warning";

        OverwriteConfirmerDialog(Shell parent, String className) {
            super(ID, parent, JptUiMessages.OverwriteConfirmerDialog_title, NLS.bind((String)JptUiMessages.OverwriteConfirmerDialog_text, (Object)className), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
            this.createButton(parent, 21, IDialogConstants.NO_TO_ALL_LABEL, false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 2: {
                    this.yesPressed();
                    break;
                }
                case 4: {
                    this.yesToAllPressed();
                    break;
                }
                case 3: {
                    this.noPressed();
                    break;
                }
                case 21: {
                    this.noToAllPressed();
                    break;
                }
                case 1: {
                    this.cancelPressed();
                    break;
                }
            }
        }

        private void yesPressed() {
            this.yes = true;
            this.setReturnCode(0);
            this.close();
        }

        private void yesToAllPressed() {
            this.yesToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noPressed() {
            this.no = true;
            this.setReturnCode(0);
            this.close();
        }

        private void noToAllPressed() {
            this.noToAll = true;
            this.setReturnCode(0);
            this.close();
        }

        boolean yes() {
            return this.yes;
        }

        boolean yesToAll() {
            return this.yesToAll;
        }

        boolean no() {
            return this.no;
        }

        boolean noToAll() {
            return this.noToAll;
        }
    }
}

