/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.ui.actions.FormatAllAction;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.facade.EclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IPeServiceUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.PeServiceUtilImpl;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JPAEditorUtil {
    private static IPeServiceUtil peUtil = null;
    private static final String PERSISTENCE_PROVIDER_LIBRARY_STRING = "javax/persistence/";

    public static String capitalizeFirstLetter(String s) {
        if (s.length() == 0) {
            return s;
        }
        String res = String.valueOf(s.substring(0, 1).toUpperCase(Locale.ENGLISH)) + s.substring(1);
        return res;
    }

    public static String decapitalizeFirstLetter(String s) {
        if (s.length() == 0) {
            return s;
        }
        String res = String.valueOf(s.substring(0, 1).toLowerCase(Locale.ENGLISH)) + s.substring(1);
        return res;
    }

    public static String revertFirstLetterCase(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return String.valueOf(Character.isLowerCase(s.charAt(0)) ? s.substring(0, 1).toUpperCase(Locale.ENGLISH) : s.substring(0, 1).toLowerCase(Locale.ENGLISH)) + s.substring(1);
    }

    public static synchronized IPeServiceUtil getPeUtil() {
        if (peUtil == null) {
            peUtil = new PeServiceUtilImpl();
        }
        return peUtil;
    }

    public static boolean equalsIgnoreFirstLetterCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        if (s1.length() == 0) {
            return true;
        }
        return s1.substring(0, 1).equalsIgnoreCase(s2.substring(0, 1)) && s1.substring(1).equals(s2.substring(1));
    }

    public static Anchor getAnchor(ContainerShape cs) {
        EList anchors = cs.getAnchors();
        if (anchors.iterator().hasNext()) {
            return (Anchor)anchors.iterator().next();
        }
        return null;
    }

    public static Anchor getAnchor(JavaPersistentType jpt, IFeatureProvider fp) {
        PictogramElement pe = fp.getPictogramElementForBusinessObject((Object)jpt);
        if (pe == null || !(pe instanceof ContainerShape)) {
            return null;
        }
        return JPAEditorUtil.getAnchor((ContainerShape)pe);
    }

    public static String getText(JavaPersistentAttribute at) {
        return at.getName();
    }

    public static String returnSimpleName(String s) {
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public static String stripQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String getTooltipText(JavaPersistentType jpt, String superPersistentTypeName) {
        String res = jpt.getName();
        if (superPersistentTypeName != null) {
            return MessageFormat.format(JPAEditorMessages.JPAEditorUtil_inheritTypeTooltipText, res, superPersistentTypeName);
        }
        return MessageFormat.format(JPAEditorMessages.JPAEditorUtil_fullnameTooltipText, res);
    }

    public static String getAttributeTypeName(JavaPersistentAttribute at) {
        return JPAEditorUtil.getAttributeTypeName(at.getResourceAttribute());
    }

    public static String getAttributeTypeName(JavaResourceAttribute at) {
        return at.getTypeName();
    }

    public static List<String> getAttributeTypeTypeNames(JavaResourceAttribute at) {
        ListIterator tt = at.getTypeTypeArgumentNames().iterator();
        if (tt == null || !tt.hasNext()) {
            return null;
        }
        LinkedList<String> res = new LinkedList<String>();
        while (tt.hasNext()) {
            res.add((String)tt.next());
        }
        return res;
    }

    public static String getAttributeTypeNameWithGenerics(JavaPersistentAttribute at) {
        return JPAEditorUtil.getAttributeTypeNameWithGenerics(at.getResourceAttribute());
    }

    public static String getAttributeTypeNameWithGenerics(JavaResourceAttribute at) {
        StringBuilder res = new StringBuilder(JPAEditorUtil.getAttributeTypeName(at));
        ListIterator it = at.getTypeTypeArgumentNames().iterator();
        if (it != null && it.hasNext()) {
            res.append('<');
            res.append(JPAEditorUtil.createCommaSeparatedListOfFullTypeNames(it));
            res.append('>');
        }
        return res.toString();
    }

    public static String[] getGenericsElementTypes(String typeName) {
        if (typeName.indexOf("<") == -1) {
            return null;
        }
        String types = typeName.substring(typeName.indexOf("<") + 1, typeName.lastIndexOf(">"));
        String[] typeNames = types.split(",");
        int i = 0;
        while (i < typeNames.length) {
            typeNames[i] = typeNames[i].trim();
            ++i;
        }
        return typeNames;
    }

    public static String createCommaSeparatedListOfSimpleTypeNames(String[] strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        StringBuilder res = new StringBuilder(JPAEditorUtil.returnSimpleName(strings[0]));
        int i = 1;
        while (i < strings.length) {
            res.append(", ");
            res.append(JPAEditorUtil.returnSimpleName(strings[i]));
            ++i;
        }
        return res.toString();
    }

    public static String createCommaSeparatedListOfSimpleTypeNames(ListIterator<String> strIt) {
        if (strIt == null || !strIt.hasNext()) {
            return null;
        }
        StringBuilder res = new StringBuilder(JPAEditorUtil.returnSimpleName(strIt.next()));
        while (strIt.hasNext()) {
            res.append(", ");
            res.append(JPAEditorUtil.returnSimpleName(strIt.next()));
        }
        return res.toString();
    }

    public static String createCommaSeparatedListOfFullTypeNames(ListIterator<String> strIt) {
        if (strIt == null || !strIt.hasNext()) {
            return null;
        }
        StringBuilder res = new StringBuilder(strIt.next());
        while (strIt.hasNext()) {
            res.append(", ");
            res.append(strIt.next());
        }
        return res.toString();
    }

    public static String getText(JavaPersistentType jpt) {
        return JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(jpt));
    }

    public static String getTooltipText(JavaPersistentType jpt) {
        String res = jpt.getName();
        return MessageFormat.format(JPAEditorMessages.JPAEditorUtil_fullnameTooltipText, res);
    }

    public static JavaPersistentType getJPType(ICompilationUnit cu) {
        String name = cu.getElementName();
        if (!name.endsWith(".java")) {
            return null;
        }
        IType tp = cu.findPrimaryType();
        if (tp == null) {
            return null;
        }
        name = tp.getFullyQualifiedName();
        IJavaProject jp = cu.getJavaProject();
        JpaProject proj = null;
        proj = JpaArtifactFactory.instance().getJpaProject(jp.getProject());
        if (proj == null) {
            return null;
        }
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(proj);
        PersistentType pt = pu.getPersistentType(name);
        if (pt == null || !(pt instanceof JavaPersistentType)) {
            return null;
        }
        return (JavaPersistentType)pt;
    }

    public static String getNameFromShape(Shape sh) {
        ContainerShape csh = (ContainerShape)sh;
        EList shapes = csh.getChildren();
        for (Shape shape : shapes) {
            GraphicsAlgorithm gra;
            EList gas;
            Rectangle rect;
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            if (!(ga instanceof Rectangle) || (rect = (Rectangle)ga).getY() != 0 || (gas = rect.getGraphicsAlgorithmChildren()).size() <= 0 || !((gra = (GraphicsAlgorithm)gas.get(0)) instanceof Text)) continue;
            return ((Text)gra).getValue();
        }
        return null;
    }

    public static void setNameOfShape(Shape sh, String name) {
        ContainerShape csh = (ContainerShape)sh;
        EList shapes = csh.getChildren();
        for (Shape shape : shapes) {
            GraphicsAlgorithm gra;
            EList gas;
            Rectangle rect;
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            if (!(ga instanceof Rectangle) || (rect = (Rectangle)ga).getY() != 0 || (gas = rect.getGraphicsAlgorithmChildren()).size() <= 0 || !((gra = (GraphicsAlgorithm)gas.get(0)) instanceof Text)) continue;
            ((Text)gra).setValue(name);
            return;
        }
    }

    public static void setJPTNameInShape(ContainerShape cs, String newName) {
        JPAEditorUtil.setJPTNameInShape(cs, newName, JPAEditorUtil.getPeUtil());
    }

    public static void setJPTNameInShape(ContainerShape cs, String newName, IPeServiceUtil peUtil) {
        EList shapes = cs.getChildren();
        for (Shape sh : shapes) {
            String propShapeType = peUtil.getPropertyValue((PropertyContainer)sh, JPAEditorConstants.PROP_SHAPE_TYPE);
            if (!JPAEditorConstants.ShapeType.HEADER.toString().equals(propShapeType)) continue;
            Text txt = (Text)sh.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            txt.setValue(newName);
            return;
        }
    }

    public static String produceValidAttributeName(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        if (name.length() == 1) {
            return name.toLowerCase(Locale.ENGLISH);
        }
        String secondSymbol = name.substring(1, 2);
        if (secondSymbol.toLowerCase(Locale.ENGLISH).equals(secondSymbol.toUpperCase(Locale.ENGLISH))) {
            return JPAEditorUtil.decapitalizeFirstLetter(name);
        }
        return JPAEditorUtil.isUpperCase(secondSymbol) ? JPAEditorUtil.capitalizeFirstLetter(name) : JPAEditorUtil.decapitalizeFirstLetter(name);
    }

    public static boolean isUpperCase(String s) {
        if (s == null || s.length() == 0 || s.length() > 1) {
            throw new IllegalArgumentException("The given string has to contain one symbol exactly");
        }
        return s.toUpperCase(Locale.ENGLISH).equals(s);
    }

    public static void createRegisterEntityInXMLJob(JpaProject jpaProject, String classFQN) {
        JpaXmlResource resource = jpaProject.getPersistenceXmlResource();
        XmlPersistence xmlPersistence = (XmlPersistence)resource.getRootObject();
        EList persistenceUnits = xmlPersistence.getPersistenceUnits();
        XmlPersistenceUnit persistenceUnit = (XmlPersistenceUnit)persistenceUnits.get(0);
        boolean registered = false;
        for (XmlJavaClassRef ref : persistenceUnit.getClasses()) {
            String className = ref.getJavaClass();
            if (!classFQN.equals(className)) continue;
            registered = true;
            break;
        }
        if (!registered) {
            XmlJavaClassRef classRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
            classRef.setJavaClass(classFQN);
            persistenceUnit.getClasses().add((Object)classRef);
        }
        resource.save();
    }

    public static void createUnregisterEntityFromXMLJob(JpaProject jpaProject, String classFQN) {
        JpaXmlResource resource = jpaProject.getPersistenceXmlResource();
        XmlPersistence xmlPersistence = (XmlPersistence)resource.getRootObject();
        EList persistenceUnits = xmlPersistence.getPersistenceUnits();
        XmlPersistenceUnit persistenceUnit = (XmlPersistenceUnit)persistenceUnits.get(0);
        EList cRefs = persistenceUnit.getClasses();
        for (XmlJavaClassRef ref : cRefs) {
            if (!ref.getJavaClass().equals(classFQN)) continue;
            cRefs.remove((Object)ref);
            break;
        }
        resource.save();
    }

    public static void createImports(ICompilationUnit cu, String typeFQN) {
        if (typeFQN == null) {
            return;
        }
        typeFQN = typeFQN.trim();
        String[] typeFQNs = JPAEditorUtil.getAllTypes(typeFQN);
        JPAEditorUtil.createImports(cu, typeFQNs);
    }

    public static String[] getAllTypes(String typeFQN) {
        typeFQN = typeFQN.replace('[', ',');
        typeFQN = typeFQN.replace(']', ',');
        typeFQN = typeFQN.replace('<', ',');
        typeFQN = typeFQN.replace('>', ',');
        String[] res = typeFQN.trim().split(",");
        int i = 0;
        while (i < res.length) {
            res[i] = res[i].trim();
            ++i;
        }
        return res;
    }

    public static void createImports(ICompilationUnit cu, String[] typeFQNs) {
        NullProgressMonitor npm = new NullProgressMonitor();
        String[] stringArray = typeFQNs;
        int n = typeFQNs.length;
        int n2 = 0;
        while (n2 < n) {
            String typeFQN = stringArray[n2];
            if (!typeFQN.startsWith("java.lang.") && typeFQN.contains(".")) {
                try {
                    cu.createImport(typeFQN, null, (IProgressMonitor)npm);
                }
                catch (JavaModelException javaModelException) {}
            }
            ++n2;
        }
    }

    public static String createImport(ICompilationUnit cu, String typeFQN) {
        if (typeFQN.startsWith("java.lang.") || !typeFQN.contains(".")) {
            return JPAEditorUtil.returnSimpleName(typeFQN);
        }
        NullProgressMonitor npm = new NullProgressMonitor();
        String simpleName = JPAEditorUtil.returnSimpleName(typeFQN);
        IImportDeclaration[] ids = new IImportDeclaration[]{};
        try {
            ids = cu.getImports();
        }
        catch (JavaModelException javaModelException) {}
        IImportDeclaration[] iImportDeclarationArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration id = iImportDeclarationArray[n2];
            String impName = id.getElementName();
            if (!impName.endsWith("*")) {
                if (impName.endsWith("." + simpleName)) {
                    return typeFQN;
                }
                if (JPAEditorConstants.WRAPPER_SIMPLE_NAMES.contains(simpleName)) {
                    return typeFQN;
                }
            }
            ++n2;
        }
        try {
            cu.createImport(typeFQN, null, (IProgressMonitor)npm);
            return JPAEditorUtil.returnSimpleName(typeFQN);
        }
        catch (JavaModelException javaModelException) {
            return typeFQN;
        }
    }

    public static Image createAttributeIcon(Rectangle iconRect, Set<String> annotations) {
        Image icon = null;
        icon = annotations == null || annotations.size() == 0 || annotations.contains("Basic") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.field") : (annotations.contains("Id") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.pk") : (annotations.contains("OneToOne") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.one_to_one_relation") : (annotations.contains("OneToMany") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.one_to_many_relation") : (annotations.contains("ManyToOne") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.many_to_one_relation") : (annotations.contains("ManyToMany") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.many_to_many_relation") : (annotations.contains("EmbeddedId") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.embedded_id") : (annotations.contains("Version") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.version") : (annotations.contains("Transient") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.transient") : (annotations.contains("Embedded") ? Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.embedded") : Graphiti.getGaService().createImage((GraphicsAlgorithmContainer)iconRect, "org.eclipse.jpt.jpadiagrameditor.ui.field"))))))))));
        return icon;
    }

    public static Shape getIconShape(Shape attributeShape) {
        int y = attributeShape.getGraphicsAlgorithm().getY();
        ContainerShape cs = attributeShape.getContainer();
        for (Shape shp : cs.getChildren()) {
            GraphicsAlgorithm ga = shp.getGraphicsAlgorithm();
            if (ga == null || ga.getY() != y || !JPAEditorConstants.ShapeType.ICON.toString().equals(Graphiti.getPeService().getPropertyValue((PropertyContainer)shp, JPAEditorConstants.PROP_SHAPE_TYPE))) continue;
            return shp;
        }
        return null;
    }

    public static Collection<ContainerShape> getRelatedShapes(ContainerShape cs) {
        HashSet<ContainerShape> res = new HashSet<ContainerShape>();
        HashSet cons = new HashSet();
        for (Anchor an : cs.getAnchors()) {
            cons.addAll(an.getIncomingConnections());
            cons.addAll(an.getOutgoingConnections());
        }
        for (Connection con : cons) {
            ContainerShape cs1 = null;
            try {
                cs1 = (ContainerShape)con.getStart().getParent();
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            if (cs1 != cs) {
                res.add(cs1);
            }
            if ((cs1 = (ContainerShape)con.getEnd().getParent()) == cs) continue;
            res.add(cs1);
        }
        return res;
    }

    public static int calcConnectionLength(FreeFormConnection c) {
        EList pts = c.getBendpoints();
        int len = 0;
        int i = 0;
        while (i < pts.size() - 1) {
            len += ((org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(i)).getX() == ((org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(i + 1)).getX() ? Math.abs(((org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(i)).getY() - ((org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(i + 1)).getY()) : Math.abs(((org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(i)).getX() - ((org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(i + 1)).getX());
            ++i;
        }
        return len;
    }

    public static List<Point> createBendPointList(FreeFormConnection c, boolean selfRelation) {
        int cnt = JPAEditorUtil.getNumberOfConnectionsWithSameEndsAs((Connection)c);
        return JPAEditorUtil.createBendPointList(c, cnt - 1, cnt, selfRelation);
    }

    public static List<Point> createBendPointList(FreeFormConnection c, int cnt, int connectionsNum, boolean selfRelation) {
        return selfRelation ? JPAEditorUtil.createBendPointListForSelfRelation(c, cnt, connectionsNum) : JPAEditorUtil.createBendPointListForNonSelfRelation(c, cnt, connectionsNum);
    }

    private static List<Point> createBendPointListForSelfRelation(FreeFormConnection c, int cnt, int connectionsNum) {
        int y;
        int x;
        int endDirection;
        int emptiestQuadrant = JPAEditorUtil.getEmptiestQuadrant(c);
        boolean evenQuadrant = emptiestQuadrant == 2 || emptiestQuadrant == 4;
        RoundedRectangle rect = (RoundedRectangle)c.getStart().getParent().getGraphicsAlgorithm();
        float halfWidth = (float)rect.getWidth() / 2.0f;
        float halfHeight = (float)rect.getHeight() / 2.0f;
        int centerX = Math.round(halfWidth + (float)rect.getX());
        int centerY = Math.round(halfHeight + (float)rect.getY());
        boolean startHorizontal = false;
        boolean endHorizontal = !startHorizontal;
        int startDirection = emptiestQuadrant == 2 || emptiestQuadrant == 3 ? 1 : -1;
        int n = endDirection = emptiestQuadrant == 1 || emptiestQuadrant == 2 ? 1 : -1;
        if (endHorizontal) {
            x = centerX + Math.round(halfWidth * (float)endDirection);
            y = centerY;
        } else {
            x = centerX;
            y = centerY + Math.round(halfHeight * (float)endDirection);
        }
        int SHIFT = evenQuadrant ? -15 * endDirection : 15 * endDirection;
        Point endPoint = new Point(x + (endHorizontal ? 0 : cnt * SHIFT), y + (endHorizontal ? cnt * SHIFT : 0));
        if (startHorizontal) {
            x = centerX + Math.round(halfWidth * (float)startDirection);
            y = centerY;
        } else {
            x = centerX;
            y = centerY + Math.round(halfHeight * (float)startDirection);
        }
        SHIFT = evenQuadrant ? -15 * startDirection : 15 * startDirection;
        Point startPoint = new Point(x + (startHorizontal ? 0 : cnt * SHIFT), y + (startHorizontal ? cnt * SHIFT : 0));
        LinkedList<Point> res = new LinkedList<Point>();
        res.add(startPoint);
        if (startHorizontal) {
            x = startPoint.x + startDirection * 50 + (evenQuadrant ? -cnt : cnt) * SHIFT;
            y = startPoint.y;
        } else {
            x = startPoint.x;
            y = startPoint.y + startDirection * 50 + (evenQuadrant ? -cnt : cnt) * SHIFT;
        }
        res.add(new Point(x, y));
        SHIFT = 15 * endDirection;
        if (startHorizontal) {
            y = y + Math.round(halfHeight + 50.0f) * endDirection + 2 * cnt * SHIFT;
        } else {
            x = x + Math.round(halfWidth + 50.0f) * endDirection + 2 * cnt * SHIFT;
        }
        res.add(new Point(x, y));
        if (startHorizontal) {
            x = endPoint.x;
        } else {
            y = endPoint.y;
        }
        res.add(new Point(x, y));
        res.add(endPoint);
        return res;
    }

    private static int getEmptiestQuadrant(FreeFormConnection selfRel) {
        Anchor anchor = selfRel.getStart();
        RoundedRectangle primRect = (RoundedRectangle)anchor.getParent().getGraphicsAlgorithm();
        HashSet cons = new HashSet();
        cons.addAll(anchor.getIncomingConnections());
        cons.addAll(anchor.getOutgoingConnections());
        Iterator it = cons.iterator();
        HashSet<Anchor> anchors = new HashSet<Anchor>();
        while (it.hasNext()) {
            Connection c = (Connection)it.next();
            Anchor a = c.getStart();
            if (a != anchor) {
                anchors.add(a);
            }
            if ((a = c.getEnd()) == anchor) continue;
            anchors.add(a);
        }
        Iterator itAnchors = anchors.iterator();
        float[] quadrantHabitat = new float[5];
        while (itAnchors.hasNext()) {
            int q;
            Anchor a = (Anchor)itAnchors.next();
            RoundedRectangle rect = (RoundedRectangle)a.getParent().getGraphicsAlgorithm();
            int n = q = JPAEditorUtil.getQuadrant(primRect, rect);
            quadrantHabitat[n] = quadrantHabitat[n] + 1.5f;
            if (q == 1) {
                quadrantHabitat[4] = quadrantHabitat[4] + 0.5f;
            } else if (q == 4) {
                quadrantHabitat[1] = quadrantHabitat[1] + 0.5f;
            }
            if (q < 4) {
                int n2 = q + 1;
                quadrantHabitat[n2] = quadrantHabitat[n2] + 0.5f;
            }
            if (q <= 1) continue;
            int n3 = q - 1;
            quadrantHabitat[n3] = quadrantHabitat[n3] + 0.5f;
        }
        float minHabitat = Float.MAX_VALUE;
        int emptiestQuadrant = 0;
        int i = 1;
        while (i < 5) {
            if (quadrantHabitat[i] < minHabitat) {
                emptiestQuadrant = i;
                minHabitat = quadrantHabitat[i];
            }
            ++i;
        }
        return emptiestQuadrant;
    }

    private static int getQuadrant(RoundedRectangle primRect, RoundedRectangle rect) {
        int primCenterX = primRect.getX() + Math.round((float)primRect.getWidth() / 2.0f);
        int primCenterY = primRect.getY() + Math.round((float)primRect.getHeight() / 2.0f);
        int centerX = rect.getX() + Math.round((float)rect.getWidth() / 2.0f);
        int centerY = rect.getY() + Math.round((float)rect.getHeight() / 2.0f);
        if (primCenterX < centerX) {
            if (primCenterY > centerY) {
                return 1;
            }
            return 2;
        }
        if (primCenterY > centerY) {
            return 4;
        }
        return 3;
    }

    private static List<Point> createBendPointListForNonSelfRelation(FreeFormConnection c, int cnt, int connectionsNum) {
        int y;
        int x;
        RoundedRectangle rectStart = (RoundedRectangle)c.getStart().getParent().getGraphicsAlgorithm();
        RoundedRectangle rectEnd = (RoundedRectangle)c.getEnd().getParent().getGraphicsAlgorithm();
        float startHalfWidth = (float)rectStart.getWidth() / 2.0f;
        float startHalfHeight = (float)rectStart.getHeight() / 2.0f;
        float endHalfWidth = (float)rectEnd.getWidth() / 2.0f;
        float endHalfHeight = (float)rectEnd.getHeight() / 2.0f;
        int startCenterX = Math.round(startHalfWidth + (float)rectStart.getX());
        int startCenterY = Math.round(startHalfHeight + (float)rectStart.getY());
        int endCenterX = Math.round(endHalfWidth + (float)rectEnd.getX());
        int endCenterY = Math.round(endHalfHeight + (float)rectEnd.getY());
        int xDelta = endCenterX - startCenterX;
        int yDelta = endCenterY - startCenterY;
        boolean startHorizontal = true;
        if (xDelta != 0) {
            x = startCenterX + Math.round(startHalfWidth * Math.signum(xDelta));
            y = startCenterY + Math.round(Math.abs(startHalfWidth / (float)xDelta) * (float)yDelta);
        } else {
            x = startCenterX + Math.round(Math.abs(startHalfHeight / (float)yDelta) * (float)xDelta);
            y = startCenterY + Math.round(startHalfHeight * Math.signum(yDelta));
        }
        if ((double)Math.abs(y - startCenterY) + 0.1 > (double)startHalfHeight) {
            startHorizontal = false;
            x = startCenterX + Math.round(Math.abs(startHalfHeight / (float)yDelta) * (float)xDelta);
            y = startCenterY + Math.round(startHalfHeight * Math.signum(yDelta));
        }
        int SHIFT = startHorizontal ? (y < startCenterY ? 15 : -15) : (x < startCenterX ? 15 : -15);
        Point startPoint = new Point(x + (startHorizontal ? 0 : cnt * SHIFT), y + (startHorizontal ? cnt * SHIFT : 0));
        LinkedList<Point> res = new LinkedList<Point>();
        xDelta = startCenterX - endCenterX;
        yDelta = startCenterY - endCenterY;
        boolean straight = xDelta == 0 || yDelta == 0;
        res.add(startPoint);
        boolean endHorizontal = true;
        if (xDelta != 0) {
            x = endCenterX + Math.round(endHalfWidth * Math.signum(xDelta));
            y = endCenterY + Math.round(Math.abs(endHalfWidth / (float)xDelta) * (float)yDelta);
        } else {
            x = endCenterX + Math.round(Math.abs(endHalfHeight / (float)yDelta) * (float)xDelta);
            y = endCenterY + Math.round(endHalfHeight * Math.signum(yDelta));
        }
        if ((double)Math.abs(y - endCenterY) + 0.1 > (double)endHalfHeight) {
            endHorizontal = false;
            x = endCenterX + Math.round(Math.abs(endHalfHeight / (float)yDelta) * (float)xDelta);
            y = endCenterY + Math.round(endHalfHeight * Math.signum(yDelta));
        }
        SHIFT = endHorizontal ? (y < endCenterY ? 15 : -15) : (x < endCenterX ? 15 : -15);
        Point endPoint = new Point(x + (endHorizontal ? 0 : cnt * SHIFT), y + (endHorizontal ? cnt * SHIFT : 0));
        if (!straight) {
            if (startHorizontal && endHorizontal) {
                if (startPoint.y != endPoint.y) {
                    x = startPoint.x + Math.round((float)(endPoint.x - startPoint.x) / 2.0f) + cnt * 15;
                    Point p = new Point(x, startPoint.y);
                    res.add(p);
                    p = new Point(x, endPoint.y);
                    res.add(p);
                }
            } else if (!startHorizontal && !endHorizontal) {
                if (startPoint.x != endPoint.x) {
                    y = startPoint.y + Math.round((float)(endPoint.y - startPoint.y) / 2.0f) + cnt * 15;
                    Point p = new Point(startPoint.x, y);
                    res.add(p);
                    p = new Point(endPoint.x, y);
                    res.add(p);
                }
            } else if (startHorizontal) {
                Point p = new Point(endPoint.x, startPoint.y);
                res.add(p);
            } else if (endHorizontal) {
                Point p = new Point(startPoint.x, endPoint.y);
                res.add(p);
            }
        }
        res.add(endPoint);
        return res;
    }

    public static void rearrangeAllConnections(final ContainerShape cs, final IJPAEditorFeatureProvider fp, final boolean selfOnly) {
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)cs);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                List anchorsFrom = JPAEditorUtil.getAnchors(cs);
                for (Anchor anchorFrom : anchorsFrom) {
                    EList outgoingConnections = anchorFrom.getOutgoingConnections();
                    EList incomingConnections = anchorFrom.getIncomingConnections();
                    HashSet<Set<Connection>> sets = new HashSet<Set<Connection>>();
                    Iterator it = outgoingConnections.iterator();
                    while (it.hasNext()) {
                        JPAEditorUtil.addConnection(sets, (Connection)it.next(), selfOnly);
                    }
                    it = incomingConnections.iterator();
                    while (it.hasNext()) {
                        JPAEditorUtil.addConnection(sets, (Connection)it.next(), selfOnly);
                    }
                    for (Set set : sets) {
                        int cnt = 0;
                        int setSize = set.size();
                        for (Connection c : set) {
                            Object o = fp.getBusinessObjectForPictogramElement((PictogramElement)c);
                            if (!(o instanceof IRelation)) continue;
                            IRelation rel = (IRelation)o;
                            JPAEditorUtil.rearrangeConnection(c, cnt, setSize, rel.getOwner() == rel.getInverse());
                            ++cnt;
                        }
                    }
                }
            }
        });
    }

    public static boolean areConnectionsWithIdenticalEnds(Connection c1, Connection c2) {
        return c1.getStart() == c2.getStart() && c1.getEnd() == c2.getEnd() || c1.getStart() == c2.getEnd() && c1.getEnd() == c2.getStart();
    }

    public static boolean connectionBelongsToSet(Connection c, Set<Connection> s) {
        if (s.isEmpty()) {
            return false;
        }
        Connection example = s.iterator().next();
        return JPAEditorUtil.areConnectionsWithIdenticalEnds(c, example);
    }

    public static int getNumberOfConnectionsWithSameEndsAs(Connection c) {
        Anchor from = c.getStart();
        Anchor to = c.getEnd();
        EList cs1 = from.getOutgoingConnections();
        EList cs2 = to.getOutgoingConnections();
        int cnt = 0;
        for (Connection con : cs1) {
            if (con.getEnd() != to) continue;
            ++cnt;
        }
        if (from == to) {
            return cnt;
        }
        for (Connection con : cs2) {
            if (con.getEnd() != from) continue;
            ++cnt;
        }
        return cnt;
    }

    static void addConnection(Set<Set<Connection>> sets, Connection c, boolean selfOnly) {
        if (sets == null) {
            throw new NullPointerException("'sets' parameter should not be null");
        }
        if (selfOnly && c.getStart() != c.getEnd()) {
            return;
        }
        for (Set<Connection> set : sets) {
            if (!JPAEditorUtil.connectionBelongsToSet(c, set)) continue;
            sets.remove(set);
            set.add(c);
            sets.add(set);
            return;
        }
        HashSet<Connection> newSet = new HashSet<Connection>();
        newSet.add(c);
        sets.add(newSet);
    }

    public static void rearrangeConnection(Connection connection, int cnt, int connectionsNum, boolean selfRelation) {
        FreeFormConnection c = (FreeFormConnection)connection;
        JPAEditorUtil.rearrangeConnectionBendPoints(c, cnt, connectionsNum, selfRelation);
        JPAEditorUtil.rearrangeConnectionDecoratorsLocation(c, cnt, connectionsNum);
    }

    public static void rearrangeConnectionBendPoints(FreeFormConnection c, int cnt, int connectionsNum, boolean selfRelation) {
        block5: {
            int diff;
            List<Point> newPts;
            EList oldPts;
            block4: {
                oldPts = c.getBendpoints();
                newPts = JPAEditorUtil.createBendPointList(c, cnt, connectionsNum, selfRelation);
                if (newPts == null) {
                    return;
                }
                int i = 0;
                while (i < Math.min(oldPts.size(), newPts.size())) {
                    oldPts.set(i, Graphiti.getGaService().createPoint(newPts.get((int)i).x, newPts.get((int)i).y));
                    ++i;
                }
                diff = oldPts.size() - newPts.size();
                if (diff <= 0) break block4;
                int i2 = oldPts.size() - 1;
                while (i2 >= newPts.size()) {
                    oldPts.remove(i2);
                    --i2;
                }
                break block5;
            }
            if (diff >= 0) break block5;
            int i = oldPts.size();
            while (i < newPts.size()) {
                oldPts.add(Graphiti.getGaService().createPoint(newPts.get((int)i).x, newPts.get((int)i).y));
                ++i;
            }
        }
    }

    public static void rearrangeConnectionDecoratorsLocation(FreeFormConnection c, int cnt, int connectionsNum) {
        EList dcrs = c.getConnectionDecorators();
        int len = JPAEditorUtil.calcConnectionLength(c);
        for (ConnectionDecorator dcr : dcrs) {
            GraphicsAlgorithm ga = dcr.getGraphicsAlgorithm();
            if (ga instanceof Text) {
                if (Math.abs(dcr.getLocation() - 0.5) < 1.0E-4) continue;
                Point pt = JPAEditorUtil.recalcTextDecoratorPosition(c, dcr);
                Graphiti.getGaService().setLocation(ga, pt.x, pt.y, false);
                continue;
            }
            if (dcr.getLocation() < 0.5) {
                Graphiti.getGaService().setLocation(dcr.getGraphicsAlgorithm(), Math.round(len / 10), 0);
                continue;
            }
            Graphiti.getGaService().setLocation(dcr.getGraphicsAlgorithm(), Math.round(-len / 10), 0);
        }
    }

    public static Point recalcTextDecoratorPosition(FreeFormConnection c, ConnectionDecorator dcr) {
        int CORR = 5;
        int TXT_HEIGHT = 8;
        double location = dcr.getLocation();
        IJPAEditorImageCreator.RelEndDir relEndDir = location < 0.5 ? JPAEditorUtil.getConnectionStartDir(c) : JPAEditorUtil.getConnectionEndDir(c);
        Text txt = (Text)dcr.getGraphicsAlgorithm();
        int TXT_WIDTH = txt.getValue().length() * 6;
        boolean isCardinality = JPAEditorConstants.CARDINALITY_LABELS.contains(txt.getValue());
        int x = 0;
        int y = 0;
        if (relEndDir.equals((Object)IJPAEditorImageCreator.RelEndDir.LEFT)) {
            x = CORR + (isCardinality ? 2 : 12);
            y = isCardinality ? -CORR - 3 - TXT_HEIGHT : CORR - 3;
        } else if (relEndDir.equals((Object)IJPAEditorImageCreator.RelEndDir.RIGHT)) {
            x = -TXT_WIDTH;
            y = isCardinality ? -CORR - 3 - TXT_HEIGHT : CORR - 3;
        } else if (relEndDir.equals((Object)IJPAEditorImageCreator.RelEndDir.UP)) {
            x = isCardinality ? -CORR - TXT_WIDTH : CORR;
            y = isCardinality ? CORR : CORR + TXT_HEIGHT + 2;
        } else if (relEndDir.equals((Object)IJPAEditorImageCreator.RelEndDir.DOWN)) {
            x = isCardinality ? -CORR - TXT_WIDTH : CORR;
            y = -CORR - (isCardinality ? TXT_HEIGHT : (TXT_HEIGHT + 2) * 2);
        }
        return new Point(x, y);
    }

    public static String formTableName(JavaPersistentType jpt) {
        IProject project = jpt.getJpaProject().getProject();
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        String tableNamePrefix = JPADiagramPropertyPage.getDefaultTablePrefixName(project, props);
        String shortEntityName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(jpt));
        if (tableNamePrefix.length() == 0) {
            return shortEntityName;
        }
        return String.valueOf(tableNamePrefix) + shortEntityName.toUpperCase(Locale.ENGLISH);
    }

    private static List<Anchor> getAnchors(ContainerShape containerShape) {
        ArrayList<Anchor> ret = new ArrayList<Anchor>();
        ret.addAll((Collection<Anchor>)containerShape.getAnchors());
        EList children = containerShape.getChildren();
        for (Shape shape : children) {
            if (shape instanceof ContainerShape) {
                ret.addAll(JPAEditorUtil.getAnchors((ContainerShape)shape));
                continue;
            }
            ret.addAll((Collection<Anchor>)shape.getAnchors());
        }
        return ret;
    }

    public static IJPAEditorImageCreator.RelEndDir getConnectionStartDir(FreeFormConnection c) {
        EList pts = c.getBendpoints();
        return JPAEditorUtil.getConnectionEndDir((org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(0), (org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(1));
    }

    public static IJPAEditorImageCreator.RelEndDir getConnectionEndDir(FreeFormConnection c) {
        EList pts = c.getBendpoints();
        return JPAEditorUtil.getConnectionEndDir((org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(pts.size() - 1), (org.eclipse.graphiti.mm.algorithms.styles.Point)pts.get(pts.size() - 2));
    }

    private static IJPAEditorImageCreator.RelEndDir getConnectionEndDir(org.eclipse.graphiti.mm.algorithms.styles.Point ptEnd, org.eclipse.graphiti.mm.algorithms.styles.Point ptNextToEnd) {
        if (ptEnd.getX() == ptNextToEnd.getX()) {
            return ptNextToEnd.getY() > ptEnd.getY() ? IJPAEditorImageCreator.RelEndDir.UP : IJPAEditorImageCreator.RelEndDir.DOWN;
        }
        return ptNextToEnd.getX() > ptEnd.getX() ? IJPAEditorImageCreator.RelEndDir.LEFT : IJPAEditorImageCreator.RelEndDir.RIGHT;
    }

    public static void organizeImports(ICompilationUnit cu, IWorkbenchSite ws) {
        OrganizeImportsAction action = new OrganizeImportsAction(ws);
        action.run(cu);
    }

    public static void formatCode(ICompilationUnit cu, IWorkbenchSite ws) {
        FormatAllAction action = new FormatAllAction(ws);
        action.run((IStructuredSelection)new StructuredSelection((Object)cu));
    }

    public static String generateUniqueEntityName(JpaProject jpaProject, String pack, IJPAEditorFeatureProvider fp) {
        String NAME = String.valueOf(pack) + ".Entity";
        String name = null;
        HashSet<String> JPAProjectEntityNames = JPAEditorUtil.getEntityNames(jpaProject);
        HashSet<String> JPAProjectEntitySimpleNames = JPAEditorUtil.getEntitySimpleNames(jpaProject);
        int i = 1;
        while (i < 100000000) {
            name = String.valueOf(NAME) + i;
            if (!fp.hasObjectWithName(name) && !JPAProjectEntityNames.contains(name.toLowerCase(Locale.ENGLISH)) && !JPAProjectEntitySimpleNames.contains(JPAEditorUtil.returnSimpleName(name).toLowerCase(Locale.ENGLISH)) && !JPAEditorUtil.isJavaFileInProject(jpaProject.getProject(), name, pack)) break;
            ++i;
        }
        return name;
    }

    public static String generateUniqueMappedSuperclassName(JpaProject jpaProject, String pack, IJPAEditorFeatureProvider fp) {
        String NAME = String.valueOf(pack) + ".MpdSuprcls";
        String name = null;
        HashSet<String> JPAProjectEntityNames = JPAEditorUtil.getEntityNames(jpaProject);
        HashSet<String> JPAProjectEntitySimpleNames = JPAEditorUtil.getEntitySimpleNames(jpaProject);
        int i = 1;
        while (i < 100000000) {
            name = String.valueOf(NAME) + i;
            if (!fp.hasObjectWithName(name) && !JPAProjectEntityNames.contains(name.toLowerCase(Locale.ENGLISH)) && !JPAProjectEntitySimpleNames.contains(JPAEditorUtil.returnSimpleName(name).toLowerCase(Locale.ENGLISH)) && !JPAEditorUtil.isJavaFileInProject(jpaProject.getProject(), name, pack)) break;
            ++i;
        }
        return name;
    }

    public static IFile createEntityInProject(IProject project, String entityName, JavaPersistentType mappedSuperclass) throws Exception {
        IFolder folder = JPAEditorUtil.getPackageFolder(project);
        return JPAEditorUtil.createEntity(project, folder, entityName, true, mappedSuperclass.getName(), JpaArtifactFactory.instance().getMappedSuperclassPackageDeclaration(mappedSuperclass), JpaArtifactFactory.instance().generateIdName(mappedSuperclass), JpaArtifactFactory.instance().hasOrInheritsPrimaryKey(mappedSuperclass));
    }

    public static IFile createEntityInProject(IProject project, String entityName, IPreferenceStore jpaPreferenceStore, boolean isMappedSuperclassChild, String mappedSuperclassName, String mappedSuperclassPackage, String idName, boolean hasPrimaryKey) throws Exception {
        IFolder folder = JPAEditorUtil.getPackageFolder(project);
        return JPAEditorUtil.createEntity(project, folder, entityName, isMappedSuperclassChild, mappedSuperclassName, mappedSuperclassPackage, idName, hasPrimaryKey);
    }

    public static IFile createEntityFromMappedSuperclassInProject(IProject project, String mappedSuperclassName, IPreferenceStore jpaPreferenceStore) throws Exception {
        IFolder folder = JPAEditorUtil.getPackageFolder(project);
        return JPAEditorUtil.createMappedSuperclassInProject(project, folder, mappedSuperclassName);
    }

    private static IFolder getPackageFolder(IProject project) throws JavaModelException {
        IClasspathEntry[] classpathEntries;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] packageFragmentRoots = new IPackageFragmentRoot[]{};
        IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getRawClasspath();
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 3) {
                packageFragmentRoots = javaProject.getPackageFragmentRoots(classpathEntry);
                break;
            }
            ++n2;
        }
        IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[0];
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(JPADiagramPropertyPage.getDefaultPackage(project, props));
        if (!packageFragment.exists()) {
            packageFragment = packageFragmentRoot.createPackageFragment(JPADiagramPropertyPage.getDefaultPackage(project, props), true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFolder folder = (IFolder)packageFragment.getCorrespondingResource();
        return folder;
    }

    public static IFile createMappedSuperclassInProject(IProject project, String mappedSuperclassName) throws Exception {
        IFolder folder = JPAEditorUtil.getPackageFolder(project);
        return JPAEditorUtil.createMappedSuperclassInProject(project, folder, mappedSuperclassName);
    }

    public static IFile createMappedSuperclassInProject(IProject project, IFolder folder, String mappedSuperclassName) throws Exception {
        IFile file;
        String mappedSuperclassShortName = mappedSuperclassName.substring(mappedSuperclassName.lastIndexOf(46) + 1);
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(file = folder.getFile(String.valueOf(mappedSuperclassShortName) + ".java")).exists()) {
            String content = "package " + JPADiagramPropertyPage.getDefaultPackage(project) + ";\n\n" + "import javax.persistence.*;\n\n" + "@MappedSuperclass \n" + "public class " + mappedSuperclassShortName + " {\n\n" + "}";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                stream.write(content.getBytes());
                stream.flush();
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    public static boolean isJavaFileInProject(IProject project, String entityName, String defaultEntityPacakage) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] packageFragmentRoots = new IPackageFragmentRoot[]{};
        IClasspathEntry[] classpathEntries = null;
        try {
            classpathEntries = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot obtain the classpath", e);
            return false;
        }
        IClasspathEntry[] iClasspathEntryArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 3) {
                packageFragmentRoots = javaProject.getPackageFragmentRoots(classpathEntry);
                break;
            }
            ++n2;
        }
        IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[0];
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(JPADiagramPropertyPage.getDefaultPackage(project));
        if (!packageFragment.exists()) {
            return false;
        }
        IFolder folder = null;
        try {
            folder = (IFolder)packageFragment.getCorrespondingResource();
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Cannot obtain the folder", e);
            return false;
        }
        if (!folder.exists()) {
            return false;
        }
        String entityShortName = entityName.substring(entityName.lastIndexOf(46) + 1);
        IFile file = folder.getFile(String.valueOf(entityShortName) + ".java");
        return file.exists();
    }

    public static String produceUniqueAttributeName(JavaPersistentType jpt, String attributeNameCandidate) {
        String name = attributeNameCandidate;
        int i = 1;
        while (i < 100000000) {
            if (jpt.getAttributeNamed(name) == null) {
                return name;
            }
            name = String.valueOf(attributeNameCandidate) + "_" + i;
            ++i;
        }
        return name;
    }

    public static String produceUniqueAttributeName(JavaPersistentType jpt, String forbiddenName, String attributeNameCandidate) {
        String name = attributeNameCandidate;
        int i = 1;
        while (i < 100000000) {
            if (jpt.getAttributeNamed(name) == null && !name.equals(forbiddenName)) {
                return name;
            }
            name = String.valueOf(attributeNameCandidate) + "_" + i;
            ++i;
        }
        return name;
    }

    public static boolean isEntityOpenElsewhere(JavaPersistentType jpt, boolean checkDirty) {
        IEditorReference[] edRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int i = 0;
        while (i < edRefs.length) {
            FileEditorInput fedInput;
            IEditorInput edInp;
            IEditorPart ed = edRefs[i].getEditor(false);
            if (ed != null && (!checkDirty || ed.isDirty()) && FileEditorInput.class.isInstance(edInp = ed.getEditorInput()) && (fedInput = (FileEditorInput)edInp).getFile().equals((Object)jpt.getResource())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ICompilationUnit getCompilationUnit(JavaPersistentType jpt) {
        return JPAEditorUtil.getCompilationUnit((IFile)jpt.getResource());
    }

    public static ICompilationUnit getCompilationUnit(IFile file) {
        return EclipseFacade.INSTANCE.getJavaCore().createCompilationUnitFrom(file);
    }

    public static void becomeWorkingCopy(ICompilationUnit cu) {
        try {
            cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            JPADiagramEditorPlugin.logError("Can't discard the working copy", e);
        }
    }

    public static void discardWorkingCopy(ICompilationUnit cu) {
        while (cu.isWorkingCopy()) {
            try {
                cu.discardWorkingCopy();
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError("Can't discard the working copy", e);
            }
        }
    }

    public static void discardWorkingCopyOnce(ICompilationUnit cu) {
        if (cu.isWorkingCopy()) {
            try {
                cu.discardWorkingCopy();
            }
            catch (JavaModelException e) {
                JPADiagramEditorPlugin.logError("Can't discard the working copy", e);
            }
        }
    }

    private static IFile createEntity(IProject project, IFolder folder, String entityName, boolean isMappedSuperclassChild, String mappedSuperclassName, String mappedSuperclassPackage, String idName, boolean hasPrimaryKey) throws Exception {
        String entityShortName = entityName.substring(entityName.lastIndexOf(46) + 1);
        if (!folder.exists()) {
            folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFile file = folder.getFile(String.valueOf(entityShortName) + ".java");
        Properties props = JPADiagramPropertyPage.loadProperties(project);
        String tableNamePrefix = JPADiagramPropertyPage.getDefaultTablePrefixName(project, props);
        String tableName = tableNamePrefix.length() > 0 ? String.valueOf(tableNamePrefix) + entityShortName.toUpperCase(Locale.ENGLISH) : "";
        boolean fieldBasedAccess = JPADiagramPropertyPage.isAccessFieldBased(project, props);
        String classDeclarationStringContent = null;
        if (isMappedSuperclassChild) {
            String mappedSuperclassShortName = mappedSuperclassName.substring(mappedSuperclassName.lastIndexOf(46) + 1);
            classDeclarationStringContent = "public class " + entityShortName + " extends " + mappedSuperclassShortName + " {\n\n";
        } else {
            classDeclarationStringContent = "public class " + entityShortName + " {\n\n";
        }
        String packageImport = "";
        if (mappedSuperclassPackage != null && !mappedSuperclassPackage.equals("") && !JPADiagramPropertyPage.getDefaultPackage(project, props).equals(mappedSuperclassPackage)) {
            packageImport = "import " + mappedSuperclassPackage + ".*;";
        }
        String primaryKeyDeclaration = "";
        if (!hasPrimaryKey) {
            primaryKeyDeclaration = JPAEditorUtil.generatePrimaryKeyDeclaration(fieldBasedAccess, idName);
        }
        if (!file.exists()) {
            String content = "package " + JPADiagramPropertyPage.getDefaultPackage(project, props) + ";\n\n" + "import javax.persistence.*;\n" + packageImport + "\n\n" + "@Entity \n" + (tableName.length() > 0 ? "@Table(name=\"" + tableName + "\")\n" : "") + classDeclarationStringContent + primaryKeyDeclaration + "}";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                stream.write(content.getBytes());
                stream.flush();
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    private static String generatePrimaryKeyDeclaration(boolean fieldBasedAccess, String primaryKeyName) {
        String primaryKeyDeclaration = String.valueOf(fieldBasedAccess ? "  @Id \n" : "") + "  private long " + primaryKeyName + ";\n\n" + (fieldBasedAccess ? "" : "  @Id \n") + "  public long get" + JPAEditorUtil.capitalizeFirstLetter(primaryKeyName) + "() {\n" + "    return " + primaryKeyName + ";\n" + "  }\n\n" + "  public void set" + JPAEditorUtil.capitalizeFirstLetter(primaryKeyName) + "(long " + primaryKeyName + ") {\n" + "    this." + primaryKeyName + " = " + primaryKeyName + ";\n" + "  }\n\n";
        return primaryKeyDeclaration;
    }

    private static HashSet<String> getEntityNames(JpaProject jpaProject) {
        HashSet<String> names = new HashSet<String>();
        ListIterator lit = jpaProject.getRootContextNode().getPersistenceXml().getPersistence().getPersistenceUnits().iterator();
        PersistenceUnit pu = (PersistenceUnit)lit.next();
        for (ClassRef cf : pu.getClassRefs()) {
            names.add(cf.getClassName());
        }
        return names;
    }

    private static HashSet<String> getEntitySimpleNames(JpaProject jpaProject) {
        HashSet<String> names = new HashSet<String>();
        ListIterator lit = jpaProject.getRootContextNode().getPersistenceXml().getPersistence().getPersistenceUnits().iterator();
        PersistenceUnit pu = (PersistenceUnit)lit.next();
        for (ClassRef cf : pu.getClassRefs()) {
            names.add(JPAEditorUtil.returnSimpleName(cf.getClassName()).toLowerCase(Locale.ENGLISH));
        }
        return names;
    }

    public static boolean isCardinalityDecorator(ConnectionDecorator cd) {
        GraphicsAlgorithm ga = cd.getGraphicsAlgorithm();
        if (!Text.class.isInstance(ga)) {
            return false;
        }
        Text txt = (Text)ga;
        return JPAEditorConstants.CARDINALITY_LABELS.contains(txt.getValue());
    }

    public static String getTooltipText(JavaPersistentAttribute at) {
        String res = JPAEditorUtil.getAttributeTypeName(at);
        return MessageFormat.format(JPAEditorMessages.JPAEditorUtil_typeTooltipText, res);
    }

    public static boolean checkJPAFacetVersion(JpaProject jpaProject, String version) {
        return JPAEditorUtil.checkJPAFacetVersion(jpaProject.getProject(), version);
    }

    public static boolean checkJPAFacetVersion(IProject project, String version) {
        IFacetedProject fproj = null;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            JPADiagramEditorPlugin.logError("Could not create faceted project from " + project.getName(), e);
        }
        Set projFacets = fproj.getProjectFacets();
        for (IProjectFacetVersion fv : projFacets) {
            if (!fv.getProjectFacet().getId().equals("jpt.jpa")) continue;
            return fv.getVersionString().equals(version);
        }
        return false;
    }

    public static String getPrimitiveWrapper(String primitive) {
        return JPAEditorConstants.PRIMITIVE_TO_WRAPPER.get(primitive);
    }

    private static File getFile(IPath classPathEntry) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile f = root.getFile(classPathEntry);
        if (f != null && f.exists()) {
            URI uri = f.getLocationURI();
            if (uri == null) {
                return new File(classPathEntry.toOSString());
            }
            File file = new File(uri);
            return file;
        }
        return new File(classPathEntry.toOSString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPersistenceProviderLibraryInClasspath(IPath classPathEntry) {
        try {
            JarEntry entry;
            File f = JPAEditorUtil.getFile(classPathEntry);
            if (f == null) return false;
            if (!f.exists()) {
                return false;
            }
            JarFile jar = new JarFile(f);
            Enumeration<JarEntry> entries = jar.entries();
            do {
                if (entries.hasMoreElements()) continue;
                return false;
            } while (!(entry = entries.nextElement()).getName().equals(PERSISTENCE_PROVIDER_LIBRARY_STRING));
            return true;
        }
        catch (IOException e) {
            JPADiagramEditorPlugin.logError(e);
        }
        return false;
    }

    public static boolean checkIsSetPersistenceProviderLibrary(JpaProject jpaProject) {
        IJavaProject javaProject = JavaCore.create((IProject)jpaProject.getProject());
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        JavaSearchScope scope = (JavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        boolean isAdded = false;
        IPath[] paths = scope.enclosingProjectsAndJars();
        int i = 1;
        while (i < paths.length) {
            IPath path = paths[i];
            if (JPAEditorUtil.isPersistenceProviderLibraryInClasspath(path)) {
                isAdded = true;
                break;
            }
            ++i;
        }
        return isAdded;
    }

    public static String cutOffStringPrefix(String s, String prefix) {
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    public static String cutOffHeaderDirtyPrefix(String header) {
        return JPAEditorUtil.cutOffStringPrefix(header, "* ");
    }

    public static boolean areHeadersEqual(String h1, String h2) {
        h1 = JPAEditorUtil.cutOffHeaderDirtyPrefix(h1);
        h2 = JPAEditorUtil.cutOffHeaderDirtyPrefix(h2);
        return h1.equals(h2);
    }

    public static JavaPersistentAttribute addAnnotatedAttribute(IJPAEditorFeatureProvider fp, JavaPersistentType referencingJPT, JavaPersistentType referencedJPT, ICompilationUnit referencingCU, ICompilationUnit referencedCU, boolean isCollection, String mapKeyType) {
        String name = JPAEditorUtil.returnSimpleName(referencedJPT.getName());
        String actName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(referencedJPT));
        String nameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(name);
        String actNameWithNonCapitalLetter = JPAEditorUtil.decapitalizeFirstLetter(actName);
        if (JpaArtifactFactory.instance().isMethodAnnotated(referencingJPT)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(name);
            actNameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(actName);
        }
        nameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(referencingJPT, nameWithNonCapitalLetter);
        actNameWithNonCapitalLetter = JPAEditorUtil.produceUniqueAttributeName(referencingJPT, actNameWithNonCapitalLetter);
        if (mapKeyType == null) {
            return JpaArtifactFactory.instance().addAttribute(fp, referencingJPT, referencedJPT, nameWithNonCapitalLetter, actNameWithNonCapitalLetter, isCollection, referencingCU, referencedCU);
        }
        return JpaArtifactFactory.instance().addAttribute(fp, referencingJPT, referencedJPT, mapKeyType, nameWithNonCapitalLetter, actNameWithNonCapitalLetter, isCollection, referencingCU, referencedCU);
    }
}

