/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.command;

import org.eclipse.jpt.common.utility.ExceptionHandler;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.RepeatingCommand;
import org.eclipse.jpt.common.utility.internal.CollectingExceptionHandler;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.ConsumerThreadCoordinator;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.command.AsynchronousRepeatingCommandWrapper;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class AsynchronousRepeatingCommandWrapperTests
extends MultiThreadedTestCase {
    PrimaryModel1 primaryModel1;
    SecondaryModel1 secondaryModel1;
    Command command1;
    RepeatingCommand repeatingCommand1;
    PrimaryModel2 primaryModel2;
    SecondaryModel2 secondaryModel2;
    Command command2;
    RepeatingCommand repeatingCommand2;

    public AsynchronousRepeatingCommandWrapperTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.primaryModel1 = new PrimaryModel1();
        this.secondaryModel1 = new SecondaryModel1(this.primaryModel1);
        this.command1 = new SynchronizeSecondaryModelCommand1(this.secondaryModel1);
        this.repeatingCommand1 = new AsynchronousRepeatingCommandWrapper(this.command1, this.buildThreadFactory(), null, ExceptionHandler.Runtime.instance());
        this.primaryModel1.setSynchronizer(this.repeatingCommand1);
        this.primaryModel2 = new PrimaryModel2();
        this.secondaryModel2 = new SecondaryModel2(this.primaryModel2);
        this.command2 = new SynchronizeSecondaryModelCommand2(this.primaryModel2, this.secondaryModel2);
        this.repeatingCommand2 = new AsynchronousRepeatingCommandWrapper(this.command2, this.buildThreadFactory(), null, ExceptionHandler.Runtime.instance());
        this.primaryModel2.setSynchronizer(this.repeatingCommand2);
    }

    protected void tearDown() throws Exception {
        this.repeatingCommand1.stop();
        this.repeatingCommand2.stop();
        super.tearDown();
    }

    public void testInitialization() {
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
    }

    public void testToString() {
        AsynchronousRepeatingCommandWrapperTests.assertNotNull((Object)this.repeatingCommand1.toString());
    }

    public void testChange() throws Exception {
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setCount(7);
        this.sleep(TICK);
        this.repeatingCommand1.stop();
        this.sleep(TICK);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)14, (int)this.secondaryModel1.getDoubleCount());
        this.repeatingCommand1.start();
    }

    public void testStart() throws Exception {
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setSynchronizer(RepeatingCommand.Null.instance());
        this.primaryModel1.setCount(7);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setSynchronizer(this.repeatingCommand1);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setCount(8);
        this.sleep(TICK);
        this.repeatingCommand1.stop();
        this.sleep(TICK);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)16, (int)this.secondaryModel1.getDoubleCount());
        this.repeatingCommand1.start();
    }

    public void testStop() throws Exception {
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.dispose();
        this.primaryModel1.setCount(7);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.repeatingCommand1.start();
    }

    public void testDoubleStart() throws Exception {
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        boolean exCaught = false;
        try {
            this.primaryModel1.startSynchronizer();
            AsynchronousRepeatingCommandWrapperTests.fail();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        AsynchronousRepeatingCommandWrapperTests.assertTrue((boolean)exCaught);
        this.primaryModel1.setCount(7);
        this.sleep(TICK);
        this.repeatingCommand1.stop();
        this.sleep(TICK);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)14, (int)this.secondaryModel1.getDoubleCount());
        this.repeatingCommand1.start();
    }

    public void testDoubleStop() throws Exception {
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.dispose();
        boolean exCaught = false;
        try {
            this.primaryModel1.dispose();
            AsynchronousRepeatingCommandWrapperTests.fail();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        AsynchronousRepeatingCommandWrapperTests.assertTrue((boolean)exCaught);
        this.primaryModel1.setCount(7);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.repeatingCommand1.start();
    }

    public void testRecursiveChange() throws Exception {
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)4, (int)this.secondaryModel2.getDoubleCount());
        this.primaryModel2.setCount(7);
        this.sleep(TICK);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)10, (int)this.primaryModel2.getCountPlus3());
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)14, (int)this.secondaryModel2.getDoubleCount());
        this.sleep(TICK);
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)20, (int)this.secondaryModel2.getDoubleCountPlus3());
    }

    public void testNullCommand() {
        boolean exCaught = false;
        try {
            AsynchronousRepeatingCommandWrapper s = new AsynchronousRepeatingCommandWrapper(null, this.buildThreadFactory(), null, ExceptionHandler.Runtime.instance());
            AsynchronousRepeatingCommandWrapperTests.fail((String)("bogus: " + s));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        AsynchronousRepeatingCommandWrapperTests.assertTrue((boolean)exCaught);
    }

    public void testThreadName() throws Exception {
        AsynchronousRepeatingCommandWrapper s = new AsynchronousRepeatingCommandWrapper(this.command1, this.buildThreadFactory(), "sync", ExceptionHandler.Runtime.instance());
        s.start();
        ConsumerThreadCoordinator ctc = (ConsumerThreadCoordinator)ReflectionTools.getFieldValue((Object)s, (String)"consumerThreadCoordinator");
        Thread t = (Thread)ReflectionTools.getFieldValue((Object)ctc, (String)"thread");
        AsynchronousRepeatingCommandWrapperTests.assertEquals((String)"sync", (String)t.getName());
        s.stop();
    }

    public void testExecuteCalledBeforeStart() throws Exception {
        SimpleCommand command = new SimpleCommand();
        AsynchronousRepeatingCommandWrapper synchronizer = new AsynchronousRepeatingCommandWrapper((Command)command, this.buildThreadFactory(), null, ExceptionHandler.Runtime.instance());
        synchronizer.execute();
        synchronizer.start();
        this.sleep(TICK);
        synchronizer.stop();
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)1, (int)command.count);
    }

    public void testException() throws Exception {
        BogusCommand command = new BogusCommand();
        CollectingExceptionHandler exHandler = new CollectingExceptionHandler();
        AsynchronousRepeatingCommandWrapper synchronizer = new AsynchronousRepeatingCommandWrapper((Command)command, this.buildThreadFactory(), null, (ExceptionHandler)exHandler);
        synchronizer.start();
        synchronizer.execute();
        this.sleep(TICK);
        synchronizer.execute();
        this.sleep(TICK);
        synchronizer.stop();
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)2, (int)CollectionTools.size((Iterable)exHandler.getExceptions()));
        AsynchronousRepeatingCommandWrapperTests.assertEquals((int)2, (int)command.count);
    }

    public void testDEBUG() {
        TestTools.assertFalseDEBUG(AsynchronousRepeatingCommandWrapper.class);
    }

    public class BogusCommand
    implements Command {
        int count = 0;

        public void execute() {
            ++this.count;
            throw new NullPointerException();
        }
    }

    public static class PrimaryModel1 {
        protected RepeatingCommand synchronizer;
        protected int count = 2;

        public PrimaryModel1() {
            this.setSynchronizer_(RepeatingCommand.Null.instance());
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            if (count != this.count) {
                this.count = count;
                this.stateChanged();
            }
        }

        protected void stateChanged() {
            this.synchronizer.execute();
        }

        public void setSynchronizer(RepeatingCommand synchronizer) throws InterruptedException {
            if (synchronizer == null) {
                throw new NullPointerException();
            }
            this.synchronizer.stop();
            this.setSynchronizer_(synchronizer);
        }

        protected void setSynchronizer_(RepeatingCommand synchronizer) {
            this.synchronizer = synchronizer;
            this.synchronizer.start();
        }

        public void startSynchronizer() {
            this.synchronizer.start();
        }

        public void dispose() throws InterruptedException {
            this.synchronizer.stop();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('(');
            this.toString(sb);
            sb.append(')');
            return sb.toString();
        }

        public void toString(StringBuilder sb) {
            sb.append("count=");
            sb.append(this.count);
        }
    }

    public static class PrimaryModel2
    extends PrimaryModel1 {
        private int countPlus3 = this.count + 3;

        public int getCountPlus3() {
            return this.countPlus3;
        }

        protected void setCountPlus3(int countPlus3) {
            if (countPlus3 != this.countPlus3) {
                this.countPlus3 = countPlus3;
                this.stateChanged();
            }
        }

        public void synchronize() {
            this.setCountPlus3(this.count + 3);
        }

        public void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", countPlus3=");
            sb.append(this.countPlus3);
        }
    }

    public static class SecondaryModel1 {
        protected final PrimaryModel1 primaryModel;
        protected int doubleCount = 0;

        public SecondaryModel1(PrimaryModel1 primaryModel) {
            this.primaryModel = primaryModel;
            this.synchronize();
        }

        public void synchronize() {
            this.doubleCount = this.primaryModel.getCount() * 2;
        }

        public int getDoubleCount() {
            return this.doubleCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('(');
            this.toString(sb);
            sb.append(')');
            return sb.toString();
        }

        public void toString(StringBuilder sb) {
            sb.append("doubleCount=");
            sb.append(this.doubleCount);
        }
    }

    public static class SecondaryModel2
    extends SecondaryModel1 {
        private int doubleCountPlus3 = 0;

        public SecondaryModel2(PrimaryModel2 extendedPrimaryModel) {
            super(extendedPrimaryModel);
        }

        protected PrimaryModel2 getExtendedPrimaryModel() {
            return (PrimaryModel2)this.primaryModel;
        }

        public void synchronize() {
            super.synchronize();
            int temp = this.getExtendedPrimaryModel().getCountPlus3() * 2;
            if (this.doubleCountPlus3 != temp) {
                this.doubleCountPlus3 = temp;
            }
        }

        public int getDoubleCountPlus3() {
            return this.doubleCountPlus3;
        }

        public void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", doubleCountPlus3=");
            sb.append(this.doubleCountPlus3);
        }
    }

    public class SimpleCommand
    implements Command {
        int count = 0;

        public void execute() {
            ++this.count;
        }
    }

    public static class SynchronizeSecondaryModelCommand1
    implements Command {
        private final SecondaryModel1 secondaryModel;

        public SynchronizeSecondaryModelCommand1(SecondaryModel1 secondaryModel) {
            this.secondaryModel = secondaryModel;
        }

        public void execute() {
            this.secondaryModel.synchronize();
        }
    }

    public static class SynchronizeSecondaryModelCommand2
    extends SynchronizeSecondaryModelCommand1 {
        private final PrimaryModel2 primaryModel;

        public SynchronizeSecondaryModelCommand2(PrimaryModel2 primaryModel, SecondaryModel2 secondaryModel) {
            super(secondaryModel);
            this.primaryModel = primaryModel;
        }

        public void execute() {
            super.execute();
            this.primaryModel.synchronize();
        }
    }
}

