/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.Date;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.BufferedWritablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedWritablePropertyValueModelTests
extends TestCase {
    private Employee employee;
    private ModifiablePropertyValueModel<Employee> employeeHolder;
    PropertyChangeEvent employeeEvent;
    private ModifiablePropertyValueModel<Integer> idAdapter;
    private ModifiablePropertyValueModel<String> nameAdapter;
    private ModifiablePropertyValueModel<Date> hireDateAdapter;
    PropertyChangeEvent adapterEvent;
    private BufferedWritablePropertyValueModel.Trigger trigger;
    private BufferedWritablePropertyValueModel<Integer> bufferedIDHolder;
    private BufferedWritablePropertyValueModel<String> bufferedNameHolder;
    private BufferedWritablePropertyValueModel<Date> bufferedHireDateHolder;
    PropertyChangeEvent bufferedEvent;

    public BufferedWritablePropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.employee = new Employee(17, "Freddy", new Date());
        this.employeeHolder = new SimplePropertyValueModel((Object)this.employee);
        this.trigger = new BufferedWritablePropertyValueModel.Trigger();
        this.idAdapter = this.buildIDAdapter((PropertyValueModel<Employee>)this.employeeHolder);
        this.bufferedIDHolder = new BufferedWritablePropertyValueModel(this.idAdapter, (PropertyValueModel)this.trigger);
        this.nameAdapter = this.buildNameAdapter((PropertyValueModel<Employee>)this.employeeHolder);
        this.bufferedNameHolder = new BufferedWritablePropertyValueModel(this.nameAdapter, (PropertyValueModel)this.trigger);
        this.hireDateAdapter = this.buildHireDateAdapter((PropertyValueModel<Employee>)this.employeeHolder);
        this.bufferedHireDateHolder = new BufferedWritablePropertyValueModel(this.hireDateAdapter, (PropertyValueModel)this.trigger);
    }

    private ModifiablePropertyValueModel<Integer> buildIDAdapter(PropertyValueModel<Employee> eHolder) {
        return new PropertyAspectAdapter<Employee, Integer>(eHolder, new String[]{"id"}){

            protected Integer buildValue_() {
                return new Integer(((Employee)((Object)this.subject)).getID());
            }

            protected void setValue_(Integer value) {
                ((Employee)((Object)this.subject)).setID(value);
            }
        };
    }

    private ModifiablePropertyValueModel<String> buildNameAdapter(PropertyValueModel<Employee> eHolder) {
        return new PropertyAspectAdapter<Employee, String>(eHolder, new String[]{"name"}){

            protected String buildValue_() {
                return ((Employee)((Object)this.subject)).getName();
            }

            protected void setValue_(String value) {
                ((Employee)((Object)this.subject)).setName(value);
            }
        };
    }

    private ModifiablePropertyValueModel<Date> buildHireDateAdapter(PropertyValueModel<Employee> eHolder) {
        return new PropertyAspectAdapter<Employee, Date>(eHolder, new String[]{"hireDate"}){

            protected Date buildValue_() {
                return ((Employee)((Object)this.subject)).getHireDate();
            }

            protected void setValue_(Date value) {
                ((Employee)((Object)this.subject)).setHireDate(value);
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetValue() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedIDHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.bufferedIDHolder.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.bufferedNameHolder.getValue()));
        Date temp = this.employee.getHireDate();
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.bufferedHireDateHolder.getValue());
        this.bufferedIDHolder.setValue((Object)new Integer(323));
        BufferedWritablePropertyValueModelTests.assertEquals((int)17, (int)this.employee.getID());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.bufferedIDHolder.getValue());
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        this.bufferedHireDateHolder.setValue(null);
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals(null, (Object)this.bufferedHireDateHolder.getValue());
    }

    public void testTriggerAccept() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedIDHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedIDHolder.setValue((Object)new Integer(323));
        BufferedWritablePropertyValueModelTests.assertEquals((int)17, (int)this.employee.getID());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.bufferedIDHolder.getValue());
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        Date temp = this.employee.getHireDate();
        this.bufferedHireDateHolder.setValue(null);
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals(null, (Object)this.bufferedHireDateHolder.getValue());
        this.trigger.accept();
        BufferedWritablePropertyValueModelTests.assertEquals((int)323, (int)this.employee.getID());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.idAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.bufferedIDHolder.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals(null, (Object)this.employee.getHireDate());
        BufferedWritablePropertyValueModelTests.assertEquals(null, (Object)this.hireDateAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals(null, (Object)this.bufferedHireDateHolder.getValue());
    }

    public void testTriggerReset() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedIDHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedIDHolder.setValue((Object)new Integer(323));
        BufferedWritablePropertyValueModelTests.assertEquals((int)17, (int)this.employee.getID());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(323), (Object)this.bufferedIDHolder.getValue());
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        Date temp = this.employee.getHireDate();
        this.bufferedHireDateHolder.setValue(null);
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals(null, (Object)this.bufferedHireDateHolder.getValue());
        this.trigger.reset();
        BufferedWritablePropertyValueModelTests.assertEquals((int)17, (int)this.employee.getID());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.idAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)new Integer(17), (Object)this.bufferedIDHolder.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.employee.getHireDate());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.hireDateAdapter.getValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)temp, (Object)this.bufferedHireDateHolder.getValue());
    }

    public void testLazyListening() {
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedIDHolder.hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedHireDateHolder.hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.idAdapter).hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.nameAdapter).hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.hireDateAdapter).hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("id"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("name"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("hireDate"));
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedIDHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedIDHolder.hasAnyPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.hasAnyPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedHireDateHolder.hasAnyPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.idAdapter).hasAnyPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.nameAdapter).hasAnyPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.hireDateAdapter).hasAnyPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasAnyPropertyChangeListeners("id"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasAnyPropertyChangeListeners("name"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasAnyPropertyChangeListeners("hireDate"));
        this.bufferedIDHolder.removePropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.removePropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedHireDateHolder.removePropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedIDHolder.hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedHireDateHolder.hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.idAdapter).hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.nameAdapter).hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)((AbstractModel)this.hireDateAdapter).hasNoPropertyChangeListeners("value"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("id"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("name"));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.employee.hasNoPropertyChangeListeners("hireDate"));
    }

    public void testPropertyChange1() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        ChangeListener adapterListener = this.buildAdapterListener();
        this.nameAdapter.addPropertyChangeListener("value", (PropertyChangeListener)adapterListener);
        ChangeListener employeeListener = this.buildEmployeeListener();
        this.employee.addPropertyChangeListener("name", (PropertyChangeListener)employeeListener);
        this.verifyPropertyChanges();
    }

    public void testPropertyChange2() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addChangeListener(bufferedListener);
        ChangeListener adapterListener = this.buildAdapterListener();
        this.nameAdapter.addChangeListener(adapterListener);
        ChangeListener employeeListener = this.buildEmployeeListener();
        this.employee.addChangeListener(employeeListener);
        this.verifyPropertyChanges();
    }

    private void verifyPropertyChanges() {
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.bufferedNameHolder.setValue((Object)"Ripley");
        this.verifyEvent(this.bufferedEvent, this.bufferedNameHolder, "value", "Freddy", "Ripley");
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.adapterEvent);
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.employeeEvent);
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.bufferedNameHolder.setValue((Object)"Charlie");
        this.verifyEvent(this.bufferedEvent, this.bufferedNameHolder, "value", "Ripley", "Charlie");
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.adapterEvent);
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.employeeEvent);
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.trigger.accept();
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.bufferedEvent);
        this.verifyEvent(this.adapterEvent, this.nameAdapter, "value", "Freddy", "Charlie");
        this.verifyEvent(this.employeeEvent, (Object)this.employee, "name", "Freddy", "Charlie");
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.bufferedNameHolder.setValue((Object)"Jason");
        this.verifyEvent(this.bufferedEvent, this.bufferedNameHolder, "value", "Charlie", "Jason");
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.adapterEvent);
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.employeeEvent);
        this.bufferedEvent = null;
        this.adapterEvent = null;
        this.employeeEvent = null;
        this.trigger.reset();
        this.verifyEvent(this.bufferedEvent, this.bufferedNameHolder, "value", "Jason", "Charlie");
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.adapterEvent);
        BufferedWritablePropertyValueModelTests.assertNull((Object)this.employeeEvent);
    }

    public void testBuffering1() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.isBuffering());
    }

    public void testBuffering2() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Freddy");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertFalse((boolean)this.bufferedNameHolder.isBuffering());
    }

    public void testBuffering3() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.isBuffering());
        this.bufferedNameHolder.setValue((Object)"Freddy");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedWritablePropertyValueModelTests.assertFalse((boolean)this.bufferedNameHolder.isBuffering());
    }

    public void testChangeConflict1() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        this.nameAdapter.setValue((Object)"Jason");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Jason", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Jason", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        this.trigger.accept();
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
    }

    public void testChangeConflict2() {
        ChangeListener bufferedListener = this.buildBufferedListener();
        this.bufferedNameHolder.addPropertyChangeListener("value", (PropertyChangeListener)bufferedListener);
        this.bufferedNameHolder.setValue((Object)"Ripley");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Freddy", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedWritablePropertyValueModelTests.assertTrue((boolean)this.bufferedNameHolder.isBuffering());
        this.nameAdapter.setValue((Object)"Ripley");
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)this.employee.getName());
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.nameAdapter.getValue()));
        BufferedWritablePropertyValueModelTests.assertEquals((String)"Ripley", (String)((String)this.bufferedNameHolder.getValue()));
        BufferedWritablePropertyValueModelTests.assertFalse((boolean)this.bufferedNameHolder.isBuffering());
    }

    private ChangeListener buildBufferedListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                BufferedWritablePropertyValueModelTests.this.bufferedEvent = e;
            }
        };
    }

    private ChangeListener buildAdapterListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                BufferedWritablePropertyValueModelTests.this.adapterEvent = e;
            }
        };
    }

    private ChangeListener buildEmployeeListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                BufferedWritablePropertyValueModelTests.this.employeeEvent = e;
            }
        };
    }

    private void verifyEvent(PropertyChangeEvent event, Object source, String propertyName, Object oldValue, Object newValue) {
        BufferedWritablePropertyValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        BufferedWritablePropertyValueModelTests.assertEquals((String)propertyName, (String)event.getPropertyName());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)oldValue, (Object)event.getOldValue());
        BufferedWritablePropertyValueModelTests.assertEquals((Object)newValue, (Object)event.getNewValue());
    }

    class Employee
    extends AbstractModel {
        private int id;
        public static final String ID_PROPERTY = "id";
        private String name;
        public static final String NAME_PROPERTY = "name";
        private Date hireDate;
        public static final String HIRE_DATE_PROPERTY = "hireDate";

        Employee(int id, String name, Date hireDate) {
            this.id = id;
            this.name = name;
            this.hireDate = hireDate;
        }

        int getID() {
            return this.id;
        }

        void setID(int id) {
            int old = this.id;
            this.id = id;
            this.firePropertyChanged(ID_PROPERTY, old, id);
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        Date getHireDate() {
            return this.hireDate;
        }

        void setHireDate(Date hireDate) {
            Date old = this.hireDate;
            this.hireDate = hireDate;
            this.firePropertyChanged(HIRE_DATE_PROPERTY, old, hireDate);
        }

        public void toString(StringBuilder sb) {
            sb.append(this.name);
        }
    }
}

