/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatedList<E>
implements List<E>,
ListChangeListener,
ListDataListener {
    private List<E> list = new ArrayList();

    public CoordinatedList(ListValueModel<E> listValueModel) {
        listValueModel.addListChangeListener("list values", (ListChangeListener)this);
        Iterator stream = listValueModel.iterator();
        while (stream.hasNext()) {
            this.add(stream.next());
        }
    }

    public CoordinatedList(ListModel listModel) {
        listModel.addListDataListener(this);
        int i = 0;
        while (i < listModel.getSize()) {
            this.add(i, this.getElementAt(listModel, i));
            ++i;
        }
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
    }

    @Override
    public boolean add(E o) {
        return this.list.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        return this.list.set(index, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public void itemsAdded(ListAddEvent e) {
        int i = e.getIndex();
        for (E item : this.getItems(e)) {
            this.list.add(i++, item);
        }
    }

    public void itemsRemoved(ListRemoveEvent e) {
        int base = e.getIndex();
        int i = e.getItemsSize();
        while (i-- > 0) {
            this.list.remove(base + i);
        }
    }

    public void itemsReplaced(ListReplaceEvent e) {
        int i = e.getIndex();
        for (E item : this.getNewItems(e)) {
            this.list.set(i++, item);
        }
    }

    public void itemsMoved(ListMoveEvent e) {
        CollectionTools.move(this.list, (int)e.getTargetIndex(), (int)e.getSourceIndex(), (int)e.getLength());
    }

    public void listCleared(ListClearEvent e) {
        this.list.clear();
    }

    public void listChanged(ListChangeEvent e) {
        this.list.clear();
        CollectionTools.addAll(this.list, (Iterator)this.getSource(e).iterator());
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.list.clear();
        ListModel lm = (ListModel)e.getSource();
        int size = lm.getSize();
        int i = 0;
        while (i < size) {
            this.list.add(i, this.getElementAt(lm, i));
            ++i;
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        ListModel lm = (ListModel)e.getSource();
        int start = Math.min(e.getIndex0(), e.getIndex1());
        int end = Math.max(e.getIndex0(), e.getIndex1());
        int i = start;
        while (i <= end) {
            this.list.add(i, this.getElementAt(lm, i));
            ++i;
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        int start = Math.min(e.getIndex0(), e.getIndex1());
        int end = Math.max(e.getIndex0(), e.getIndex1());
        int length = end - start + 1;
        int i = 1;
        while (i <= length) {
            this.list.remove(start);
            ++i;
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return this.list.toString();
    }

    private E getElementAt(ListModel listModel, int index) {
        return listModel.getElementAt(index);
    }

    private Iterable<E> getItems(ListAddEvent event) {
        return event.getItems();
    }

    private Iterable<E> getNewItems(ListReplaceEvent event) {
        return event.getNewItems();
    }

    private ListValueModel<E> getSource(ListChangeEvent event) {
        return (ListValueModel)event.getSource();
    }
}

