/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.DocumentAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class DocumentAdapterTests
extends TestCase {
    private ModifiablePropertyValueModel<String> stringHolder;
    Document documentAdapter;
    boolean eventFired;

    public DocumentAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.stringHolder = new SimplePropertyValueModel((Object)"0123456789");
        this.documentAdapter = new DocumentAdapter(this.stringHolder){

            protected PropertyChangeListener buildStringListener() {
                return this.buildStringListener_();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testRemove() throws Exception {
        this.eventFired = false;
        this.documentAdapter.addDocumentListener(new TestDocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                DocumentAdapterTests.this.eventFired = true;
                DocumentAdapterTests.assertEquals((Object)DocumentEvent.EventType.REMOVE, (Object)e.getType());
                DocumentAdapterTests.assertEquals((Object)DocumentAdapterTests.this.documentAdapter, (Object)e.getDocument());
                DocumentAdapterTests.assertEquals((int)2, (int)e.getOffset());
                DocumentAdapterTests.assertEquals((int)5, (int)e.getLength());
            }
        });
        this.documentAdapter.remove(2, 5);
        DocumentAdapterTests.assertTrue((boolean)this.eventFired);
        DocumentAdapterTests.assertEquals((String)"01789", (String)((String)this.stringHolder.getValue()));
    }

    public void testInsert() throws Exception {
        this.eventFired = false;
        this.documentAdapter.addDocumentListener(new TestDocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                DocumentAdapterTests.this.eventFired = true;
                DocumentAdapterTests.assertEquals((Object)DocumentEvent.EventType.INSERT, (Object)e.getType());
                DocumentAdapterTests.assertEquals((Object)DocumentAdapterTests.this.documentAdapter, (Object)e.getDocument());
                DocumentAdapterTests.assertEquals((int)2, (int)e.getOffset());
                DocumentAdapterTests.assertEquals((int)5, (int)e.getLength());
            }
        });
        this.documentAdapter.insertString(2, "xxxxx", null);
        DocumentAdapterTests.assertTrue((boolean)this.eventFired);
        DocumentAdapterTests.assertEquals((String)"01xxxxx23456789", (String)((String)this.stringHolder.getValue()));
    }

    public void testSetValue() throws Exception {
        this.eventFired = false;
        this.documentAdapter.addDocumentListener(new TestDocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                DocumentAdapterTests.this.eventFired = true;
                DocumentAdapterTests.assertEquals((Object)DocumentEvent.EventType.INSERT, (Object)e.getType());
                DocumentAdapterTests.assertEquals((Object)DocumentAdapterTests.this.documentAdapter, (Object)e.getDocument());
                DocumentAdapterTests.assertEquals((int)0, (int)e.getOffset());
                DocumentAdapterTests.assertEquals((int)3, (int)e.getLength());
            }

            public void removeUpdate(DocumentEvent e) {
                DocumentAdapterTests.assertEquals((Object)DocumentEvent.EventType.REMOVE, (Object)e.getType());
                DocumentAdapterTests.assertEquals((Object)DocumentAdapterTests.this.documentAdapter, (Object)e.getDocument());
                DocumentAdapterTests.assertEquals((int)0, (int)e.getOffset());
                DocumentAdapterTests.assertEquals((int)10, (int)e.getLength());
            }
        });
        DocumentAdapterTests.assertEquals((String)"0123456789", (String)this.documentAdapter.getText(0, this.documentAdapter.getLength()));
        this.stringHolder.setValue((Object)"foo");
        DocumentAdapterTests.assertTrue((boolean)this.eventFired);
        DocumentAdapterTests.assertEquals((String)"foo", (String)this.documentAdapter.getText(0, this.documentAdapter.getLength()));
    }

    public void testHasListeners() throws Exception {
        SimplePropertyValueModel localStringHolder = (SimplePropertyValueModel)this.stringHolder;
        DocumentAdapterTests.assertFalse((boolean)localStringHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.documentAdapter);
        TestDocumentListener listener = new TestDocumentListener();
        this.documentAdapter.addDocumentListener(listener);
        DocumentAdapterTests.assertTrue((boolean)localStringHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners(this.documentAdapter);
        this.documentAdapter.removeDocumentListener(listener);
        DocumentAdapterTests.assertFalse((boolean)localStringHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.documentAdapter);
    }

    private void verifyHasNoListeners(Object document) throws Exception {
        Object delegate = ReflectionTools.getFieldValue((Object)document, (String)"delegate");
        Object[] listeners = (Object[])ReflectionTools.executeMethod((Object)delegate, (String)"getDocumentListeners");
        DocumentAdapterTests.assertEquals((int)0, (int)listeners.length);
    }

    private void verifyHasListeners(Object document) throws Exception {
        Object delegate = ReflectionTools.getFieldValue((Object)document, (String)"delegate");
        Object[] listeners = (Object[])ReflectionTools.executeMethod((Object)delegate, (String)"getDocumentListeners");
        DocumentAdapterTests.assertFalse((listeners.length == 0 ? 1 : 0) != 0);
    }

    private class TestDocumentListener
    implements DocumentListener {
        TestDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            DocumentAdapterTests.fail((String)"unexpected event");
        }

        public void insertUpdate(DocumentEvent e) {
            DocumentAdapterTests.fail((String)"unexpected event");
        }

        public void removeUpdate(DocumentEvent e) {
            DocumentAdapterTests.fail((String)"unexpected event");
        }
    }
}

