/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.swing.CheckBoxModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ColumnAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ComboBoxModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.swing.DateSpinnerModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.swing.DocumentAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ListModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.swing.NumberSpinnerModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.TableModelAdapter;
import org.eclipse.jpt.common.utility.internal.swing.CheckBoxTableCellRenderer;
import org.eclipse.jpt.common.utility.internal.swing.ComboBoxTableCellRenderer;
import org.eclipse.jpt.common.utility.internal.swing.SpinnerTableCellRenderer;
import org.eclipse.jpt.common.utility.internal.swing.TableCellEditorAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.model.value.swing.TableModelAdapterTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelAdapterUITest {
    private SimpleCollectionValueModel<Object> eyeColorsHolder;
    private ModifiablePropertyValueModel<TableModelAdapterTests.Crowd> crowdHolder;
    private ModifiablePropertyValueModel<TableModelAdapterTests.Person> selectedPersonHolder;
    private ListValueModel<TableModelAdapterTests.Person> sortedPeopleAdapter;
    private TableModel tableModel;
    private ObjectListSelectionModel rowSelectionModel;
    private Action removeAction;
    private Action renameAction;

    public static void main(String[] args) throws Exception {
        new TableModelAdapterUITest().exec(args);
    }

    protected TableModelAdapterUITest() {
    }

    protected void exec(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        this.eyeColorsHolder = this.buildEyeColorCollectionHolder();
        this.crowdHolder = this.buildCrowdHolder();
        this.selectedPersonHolder = this.buildSelectedPersonHolder();
        this.sortedPeopleAdapter = this.buildSortedPeopleAdapter();
        this.tableModel = this.buildTableModel();
        this.rowSelectionModel = this.buildRowSelectionModel();
        this.openWindow();
    }

    private SimpleCollectionValueModel<Object> buildEyeColorCollectionHolder() {
        return new SimpleCollectionValueModel(new ArrayList<String>(TableModelAdapterTests.Person.getValidEyeColors()));
    }

    private ModifiablePropertyValueModel<TableModelAdapterTests.Crowd> buildCrowdHolder() {
        return new SimplePropertyValueModel((Object)this.buildCrowd());
    }

    private TableModelAdapterTests.Crowd buildCrowd() {
        TableModelAdapterTests.Crowd crowd = new TableModelAdapterTests.Crowd();
        TableModelAdapterTests.Person p = crowd.addPerson("Bilbo");
        p.setEyeColor("brown");
        p.setRank(22);
        p.setAdventureCount(1);
        p = crowd.addPerson("Gollum");
        p.setEyeColor("pink");
        p.setEvil(true);
        p.setRank(2);
        p.setAdventureCount(50);
        p = crowd.addPerson("Frodo");
        p.setEyeColor("blue");
        p.setRank(34);
        p.setAdventureCount(1);
        p = crowd.addPerson("Samwise");
        p.setEyeColor("green");
        p.setRank(19);
        p.setAdventureCount(1);
        return crowd;
    }

    private ModifiablePropertyValueModel<TableModelAdapterTests.Person> buildSelectedPersonHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<TableModelAdapterTests.Person> buildSortedPeopleAdapter() {
        return new SortedListValueModelWrapper(this.buildPeopleNameAdapter());
    }

    private ListValueModel<TableModelAdapterTests.Person> buildPeopleNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildPeopleAdapter(), new String[]{"name"});
    }

    private CollectionValueModel<TableModelAdapterTests.Person> buildPeopleAdapter() {
        return new CollectionAspectAdapter<TableModelAdapterTests.Crowd, TableModelAdapterTests.Person>(this.crowdHolder, new String[]{"people"}){

            protected Iterator<TableModelAdapterTests.Person> iterator_() {
                return ((TableModelAdapterTests.Crowd)((Object)this.subject)).people();
            }

            protected int size_() {
                return ((TableModelAdapterTests.Crowd)((Object)this.subject)).peopleSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.sortedPeopleAdapter, this.buildColumnAdapter());
    }

    protected ColumnAdapter buildColumnAdapter() {
        return new TableModelAdapterTests.PersonColumnAdapter();
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel rsm = new ObjectListSelectionModel((ListModel)new ListModelAdapter(this.sortedPeopleAdapter));
        rsm.addListSelectionListener(this.buildRowSelectionListener());
        rsm.setSelectionMode(0);
        return rsm;
    }

    private ListSelectionListener buildRowSelectionListener() {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                TableModelAdapterUITest.this.rowSelectionChanged(e);
            }
        };
    }

    void rowSelectionChanged(ListSelectionEvent event) {
        TableModelAdapterTests.Person selection = (TableModelAdapterTests.Person)this.rowSelectionModel.selectedValue();
        this.selectedPersonHolder.setValue((Object)selection);
        boolean personSelected = selection != null;
        this.removeAction.setEnabled(personSelected);
        this.renameAction.setEnabled(personSelected);
    }

    private void openWindow() {
        JFrame window = new JFrame(this.getClass().getSimpleName());
        window.setDefaultCloseOperation(0);
        window.addWindowListener(this.buildWindowListener());
        window.getContentPane().add(this.buildMainPanel(), "Center");
        window.setLocation(200, 200);
        window.setSize(600, 400);
        window.setVisible(true);
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
                System.exit(0);
            }
        };
    }

    private Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add(this.buildTablePane(), "Center");
        mainPanel.add(this.buildControlPanel(), "South");
        return mainPanel;
    }

    private Component buildTablePane() {
        return new JScrollPane(this.buildTable());
    }

    private JTable buildTable() {
        JTable table = new JTable(this.tableModel);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        table.setSelectionModel((ListSelectionModel)this.rowSelectionModel);
        table.setDoubleBuffered(true);
        table.setAutoResizeMode(1);
        int rowHeight = 20;
        TableColumn column = table.getColumnModel().getColumn(2);
        SpinnerTableCellRenderer spinnerRenderer = this.buildDateSpinnerRenderer();
        column.setCellRenderer((TableCellRenderer)spinnerRenderer);
        column.setCellEditor((TableCellEditor)new TableCellEditorAdapter((TableCellEditorAdapter.Renderer)this.buildDateSpinnerRenderer()));
        rowHeight = Math.max(rowHeight, spinnerRenderer.preferredHeight());
        column = table.getColumnModel().getColumn(3);
        ComboBoxTableCellRenderer eyeColorRenderer = this.buildEyeColorComboBoxRenderer();
        column.setCellRenderer((TableCellRenderer)eyeColorRenderer);
        column.setCellEditor((TableCellEditor)new TableCellEditorAdapter((TableCellEditorAdapter.Renderer)this.buildEyeColorComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, eyeColorRenderer.preferredHeight());
        column = table.getColumnModel().getColumn(4);
        CheckBoxTableCellRenderer evilRenderer = new CheckBoxTableCellRenderer();
        column.setCellRenderer((TableCellRenderer)evilRenderer);
        column.setCellEditor((TableCellEditor)new TableCellEditorAdapter((TableCellEditorAdapter.Renderer)new CheckBoxTableCellRenderer()));
        rowHeight = Math.max(rowHeight, evilRenderer.preferredHeight());
        column = table.getColumnModel().getColumn(6);
        spinnerRenderer = this.buildNumberSpinnerRenderer();
        column.setCellRenderer((TableCellRenderer)spinnerRenderer);
        column.setCellEditor((TableCellEditor)new TableCellEditorAdapter((TableCellEditorAdapter.Renderer)this.buildNumberSpinnerRenderer()));
        rowHeight = Math.max(rowHeight, spinnerRenderer.preferredHeight());
        table.setRowHeight(rowHeight);
        return table;
    }

    private SpinnerTableCellRenderer buildDateSpinnerRenderer() {
        return new SpinnerTableCellRenderer((SpinnerModel)new DateSpinnerModelAdapter((ModifiablePropertyValueModel)new SimplePropertyValueModel()));
    }

    private SpinnerTableCellRenderer buildNumberSpinnerRenderer() {
        return new SpinnerTableCellRenderer((SpinnerModel)new NumberSpinnerModelAdapter((ModifiablePropertyValueModel)new SimplePropertyValueModel()));
    }

    private ComboBoxTableCellRenderer buildEyeColorComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildReadOnlyEyeColorComboBoxModel(), this.buildEyeColorRenderer());
    }

    private ComboBoxModel buildReadOnlyEyeColorComboBoxModel() {
        return new ComboBoxModelAdapter(this.eyeColorsHolder, (ModifiablePropertyValueModel)new SimplePropertyValueModel());
    }

    private ListCellRenderer buildEyeColorRenderer() {
        return new EyeColorRenderer();
    }

    private Component buildControlPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(0, 1));
        controlPanel.add(this.buildButtonPanel());
        controlPanel.add(this.buildPersonPanel());
        return controlPanel;
    }

    private Component buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        buttonPanel.add(this.buildAddButton());
        buttonPanel.add(this.buildRemoveButton());
        buttonPanel.add(this.buildRenameButton());
        buttonPanel.add(this.buildAddEyeColorButton());
        buttonPanel.add(this.buildPrintButton());
        buttonPanel.add(this.buildResetButton());
        return buttonPanel;
    }

    private Component buildPersonPanel() {
        JPanel personPanel = new JPanel(new GridLayout(1, 0));
        personPanel.add(this.buildNameTextField());
        personPanel.add(this.buildBirthDateSpinner());
        personPanel.add(this.buildGoneWestDateSpinner());
        personPanel.add(this.buildEyeColorComboBox());
        personPanel.add(this.buildEvilCheckBox());
        personPanel.add(this.buildRankSpinner());
        personPanel.add(this.buildAdventureCountSpinner());
        return personPanel;
    }

    private JButton buildAddButton() {
        return new JButton(this.buildAddAction());
    }

    private Action buildAddAction() {
        AbstractAction action = new AbstractAction("add"){

            public void actionPerformed(ActionEvent event) {
                TableModelAdapterUITest.this.addPerson();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void addPerson() {
        String name = this.getNameFromUser();
        if (name != null) {
            this.setSelectedPerson(this.crowd().addPerson(name));
        }
    }

    private JButton buildRemoveButton() {
        return new JButton(this.buildRemoveAction());
    }

    private Action buildRemoveAction() {
        this.removeAction = new AbstractAction("remove"){

            public void actionPerformed(ActionEvent event) {
                TableModelAdapterUITest.this.removePerson();
            }
        };
        this.removeAction.setEnabled(false);
        return this.removeAction;
    }

    void removePerson() {
        TableModelAdapterTests.Person person = this.selectedPerson();
        if (person != null) {
            this.crowd().removePerson(person);
        }
    }

    private JButton buildRenameButton() {
        return new JButton(this.buildRenameAction());
    }

    private Action buildRenameAction() {
        this.renameAction = new AbstractAction("rename"){

            public void actionPerformed(ActionEvent event) {
                TableModelAdapterUITest.this.renamePerson();
            }
        };
        this.renameAction.setEnabled(false);
        return this.renameAction;
    }

    void renamePerson() {
        String name;
        TableModelAdapterTests.Person person = this.selectedPerson();
        if (person != null && (name = this.promptUserForName(person.getName())) != null) {
            person.setName(name);
            this.setSelectedPerson(person);
        }
    }

    private JButton buildAddEyeColorButton() {
        return new JButton(this.buildAddEyeColorAction());
    }

    private Action buildAddEyeColorAction() {
        AbstractAction action = new AbstractAction("add eye color"){

            public void actionPerformed(ActionEvent event) {
                TableModelAdapterUITest.this.addEyeColor();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void addEyeColor() {
        String color = this.promptUserForEyeColor();
        if (color != null) {
            this.eyeColorsHolder.add((Object)color);
        }
    }

    private String promptUserForEyeColor() {
        String eyeColor;
        while (true) {
            if ((eyeColor = JOptionPane.showInputDialog("Eye Color")) == null) {
                return null;
            }
            if (eyeColor.length() == 0) {
                JOptionPane.showMessageDialog(null, "The eye color is required.", "Invalid Eye Color", 0);
                continue;
            }
            if (!CollectionTools.contains((Iterator)this.eyeColorsHolder.iterator(), (Object)eyeColor)) break;
            JOptionPane.showMessageDialog(null, "The eye color already exists.", "Invalid Eye Color", 0);
        }
        return eyeColor;
    }

    private JButton buildPrintButton() {
        return new JButton(this.buildPrintAction());
    }

    private Action buildPrintAction() {
        AbstractAction action = new AbstractAction("print"){

            public void actionPerformed(ActionEvent event) {
                TableModelAdapterUITest.this.printCrowd();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void printCrowd() {
        System.out.println((Object)this.crowd());
        Iterator<TableModelAdapterTests.Person> stream = this.crowd().people();
        while (stream.hasNext()) {
            System.out.println("\t" + stream.next());
        }
    }

    private JButton buildResetButton() {
        return new JButton(this.buildResetAction());
    }

    private Action buildResetAction() {
        AbstractAction action = new AbstractAction("reset"){

            public void actionPerformed(ActionEvent event) {
                TableModelAdapterUITest.this.reset();
            }
        };
        action.setEnabled(true);
        return action;
    }

    void reset() {
        this.crowdHolder.setValue((Object)this.buildCrowd());
    }

    private String getNameFromUser() {
        return this.promptUserForName(null);
    }

    private String promptUserForName(String originalName) {
        String name;
        while (true) {
            if ((name = JOptionPane.showInputDialog("Person Name")) == null) {
                return null;
            }
            if (name.length() == 0) {
                JOptionPane.showMessageDialog(null, "The name is required.", "Invalid Name", 0);
                continue;
            }
            if (!CollectionTools.contains(this.crowd().peopleNames(), (Object)name)) break;
            JOptionPane.showMessageDialog(null, "The name already exists.", "Invalid Name", 0);
        }
        return name;
    }

    private Component buildNameTextField() {
        JTextField textField = new JTextField(this.buildNameDocument(), null, 0);
        textField.setEditable(false);
        return textField;
    }

    private Document buildNameDocument() {
        return new DocumentAdapter(this.buildNameAdapter());
    }

    private ModifiablePropertyValueModel<String> buildNameAdapter() {
        return new PropertyAspectAdapter<TableModelAdapterTests.Person, String>(this.selectedPersonHolder, new String[]{"name"}){

            protected String buildValue_() {
                return ((TableModelAdapterTests.Person)this.subject).getName();
            }

            protected void setValue_(String value) {
                ((TableModelAdapterTests.Person)this.subject).setName(value);
            }
        };
    }

    private JSpinner buildBirthDateSpinner() {
        return new JSpinner(this.buildBirthDateSpinnerModel());
    }

    private SpinnerModel buildBirthDateSpinnerModel() {
        return new DateSpinnerModelAdapter(this.buildBirthDateAdapter());
    }

    private ModifiablePropertyValueModel<Object> buildBirthDateAdapter() {
        return new PropertyAspectAdapter<TableModelAdapterTests.Person, Object>(this.selectedPersonHolder, new String[]{"birthDate"}){

            protected Date buildValue_() {
                return ((TableModelAdapterTests.Person)this.subject).getBirthDate();
            }

            protected void setValue_(Object value) {
                ((TableModelAdapterTests.Person)this.subject).setBirthDate((Date)value);
            }
        };
    }

    private JSpinner buildGoneWestDateSpinner() {
        return new JSpinner(this.buildGoneWestDateSpinnerModel());
    }

    private SpinnerModel buildGoneWestDateSpinnerModel() {
        return new DateSpinnerModelAdapter(this.buildGoneWestDateAdapter());
    }

    private ModifiablePropertyValueModel<Object> buildGoneWestDateAdapter() {
        return new PropertyAspectAdapter<TableModelAdapterTests.Person, Object>(this.selectedPersonHolder, new String[]{"goneWestDate"}){

            protected Date buildValue_() {
                return ((TableModelAdapterTests.Person)this.subject).getGoneWestDate();
            }

            protected void setValue_(Object value) {
                ((TableModelAdapterTests.Person)this.subject).setGoneWestDate((Date)value);
            }
        };
    }

    private JComboBox buildEyeColorComboBox() {
        return new JComboBox(this.buildEyeColorComboBoxModel());
    }

    private ComboBoxModel buildEyeColorComboBoxModel() {
        return new ComboBoxModelAdapter(this.eyeColorsHolder, this.buildEyeColorAdapter());
    }

    private ModifiablePropertyValueModel<Object> buildEyeColorAdapter() {
        return new PropertyAspectAdapter<TableModelAdapterTests.Person, Object>(this.selectedPersonHolder, new String[]{"eyeColor"}){

            protected Object buildValue_() {
                return ((TableModelAdapterTests.Person)this.subject).getEyeColor();
            }

            protected void setValue_(Object value) {
                ((TableModelAdapterTests.Person)this.subject).setEyeColor((String)value);
            }
        };
    }

    private JCheckBox buildEvilCheckBox() {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setText("evil");
        checkBox.setModel(this.buildEvilCheckBoxModel());
        return checkBox;
    }

    private ButtonModel buildEvilCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildEvilAdapter());
    }

    private ModifiablePropertyValueModel<Boolean> buildEvilAdapter() {
        return new PropertyAspectAdapter<TableModelAdapterTests.Person, Boolean>(this.selectedPersonHolder, new String[]{"evil"}){

            protected Boolean buildValue_() {
                return ((TableModelAdapterTests.Person)this.subject).isEvil();
            }

            protected void setValue_(Boolean value) {
                ((TableModelAdapterTests.Person)this.subject).setEvil(value);
            }
        };
    }

    private JSpinner buildRankSpinner() {
        return new JSpinner(this.buildRankSpinnerModel());
    }

    private SpinnerModel buildRankSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildRankAdapter());
    }

    private ModifiablePropertyValueModel<Number> buildRankAdapter() {
        return new PropertyAspectAdapter<TableModelAdapterTests.Person, Number>(this.selectedPersonHolder, new String[]{"rank"}){

            protected Number buildValue_() {
                return new Integer(((TableModelAdapterTests.Person)this.subject).getRank());
            }

            protected void setValue_(Number value) {
                ((TableModelAdapterTests.Person)this.subject).setRank(value.intValue());
            }
        };
    }

    private JSpinner buildAdventureCountSpinner() {
        return new JSpinner(this.buildAdventureCountSpinnerModel());
    }

    private SpinnerModel buildAdventureCountSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildAdventureCountAdapter());
    }

    private ModifiablePropertyValueModel<Number> buildAdventureCountAdapter() {
        return new PropertyAspectAdapter<TableModelAdapterTests.Person, Number>(this.selectedPersonHolder, new String[]{"adventureCount"}){

            protected Number buildValue_() {
                return new Integer(((TableModelAdapterTests.Person)this.subject).getAdventureCount());
            }

            protected void setValue_(Number value) {
                ((TableModelAdapterTests.Person)this.subject).setAdventureCount(value.intValue());
            }
        };
    }

    private TableModelAdapterTests.Crowd crowd() {
        return (TableModelAdapterTests.Crowd)((Object)this.crowdHolder.getValue());
    }

    private TableModelAdapterTests.Person selectedPerson() {
        if (this.rowSelectionModel.isSelectionEmpty()) {
            return null;
        }
        return (TableModelAdapterTests.Person)this.rowSelectionModel.selectedValue();
    }

    private void setSelectedPerson(TableModelAdapterTests.Person person) {
        this.rowSelectionModel.setSelectedValue((Object)person);
    }

    private class EyeColorRenderer
    extends DefaultListCellRenderer {
        EyeColorRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

