/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.rhino.tests.RequestTest;
import org.eclipse.wst.jsdt.debug.rhino.tests.Util;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptRequestTests
extends RequestTest {
    public void testScriptsWithNoScripts() throws Exception {
        RhinoRequest request = new RhinoRequest("scripts");
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        ScriptRequestTests.assertTrue((boolean)response.isSuccess());
        Collection scripts = (Collection)response.getBody().get("scripts");
        ScriptRequestTests.assertNotNull((Object)scripts);
        ScriptRequestTests.assertTrue((boolean)scripts.isEmpty());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScript() throws Exception {
        String script = Util.getTestSource("scripts", "script1.js");
        ScriptRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        ScriptableObject scope = null;
        Context context = this.contextFactory.enterContext();
        try {
            scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, script, "script", 0, null);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        Context.exit();
        RhinoRequest request = new RhinoRequest("scripts");
        this.debugSession.send((Packet)request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        ScriptRequestTests.assertTrue((boolean)response.isSuccess());
        List scripts = (List)response.getBody().get("scripts");
        ScriptRequestTests.assertNotNull((Object)scripts);
        ScriptRequestTests.assertFalse((boolean)scripts.isEmpty());
        request = new RhinoRequest("script");
        request.getArguments().put("scriptId", scripts.get(0));
        this.debugSession.send((Packet)request);
        response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        ScriptRequestTests.assertTrue((boolean)response.isSuccess());
        Map result = (Map)response.getBody().get("script");
        ScriptRequestTests.assertEquals((Object)script, result.get("source"));
        List lineNumbers = (List)result.get("lines");
        ScriptRequestTests.assertEquals((int)8, (int)lineNumbers.size());
        ScriptRequestTests.assertTrue((String)"The line number [10] should be returned", (boolean)lineNumbers.contains(new BigDecimal(10.0)));
        ScriptRequestTests.assertTrue((String)"The line number [11] should be returned", (boolean)lineNumbers.contains(new BigDecimal(11.0)));
        ScriptRequestTests.assertTrue((String)"The line number [12] should be returned", (boolean)lineNumbers.contains(new BigDecimal(12.0)));
        ScriptRequestTests.assertTrue((String)"The line number [15] should be returned", (boolean)lineNumbers.contains(new BigDecimal(15.0)));
        ScriptRequestTests.assertTrue((String)"The line number [16] should be returned", (boolean)lineNumbers.contains(new BigDecimal(16.0)));
        ScriptRequestTests.assertTrue((String)"The line number [19] should be returned", (boolean)lineNumbers.contains(new BigDecimal(19.0)));
        ScriptRequestTests.assertTrue((String)"The line number [22] should be returned", (boolean)lineNumbers.contains(new BigDecimal(22.0)));
        ScriptRequestTests.assertTrue((String)"The line number [23] should be returned", (boolean)lineNumbers.contains(new BigDecimal(23.0)));
        List functionNames = (List)result.get("functions");
        ScriptRequestTests.assertEquals((int)2, (int)functionNames.size());
        ScriptRequestTests.assertEquals((Object)"test", functionNames.get(0));
        ScriptRequestTests.assertEquals((Object)"test2", functionNames.get(1));
    }
}

