/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryNode;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.TransformerAdapter;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryAnnotatedElement
extends BinaryNode
implements JavaResourceAnnotatedElement {
    final Adapter adapter;
    private final Hashtable<String, Annotation> annotations = new Hashtable();
    private final Hashtable<String, AnnotationContainer> annotationContainers = new Hashtable();
    private final Hashtable<String, Annotation> nullAnnotationsCache = new Hashtable();
    private static final Transformer<AnnotationContainer, Iterable<NestableAnnotation>> ANNOTATION_CONTAINER_NESTED_ANNOTATIONS_TRANSFORMER = new AnnotationContainerNestedAnnotationsTransformer();
    private static final Transformer<AnnotationContainer, Annotation> TOP_LEVEL_ANNOTATION_CONTAINER_TRANSFORMER = new TopLevelAnnotationContainerTransformer();
    private static final IAnnotation[] EMPTY_JDT_ANNOTATION_ARRAY = new IAnnotation[0];
    static final IMemberValuePair[] EMPTY_MEMBER_VALUE_PAIR_ARRAY = new IMemberValuePair[0];
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    BinaryAnnotatedElement(JavaResourceNode parent, Adapter adapter) {
        super(parent);
        this.adapter = adapter;
        this.initializeAnnotations();
    }

    private void initializeAnnotations() {
        IAnnotation[] iAnnotationArray = this.getJdtAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            this.addAnnotation(annotation);
            ++n2;
        }
    }

    private void addAnnotation(IAnnotation jdtAnnotation) {
        String jdtAnnotationName = jdtAnnotation.getElementName();
        if (this.annotationIsValidContainer(jdtAnnotationName)) {
            String nestableAnnotationName = this.getAnnotationProvider().getNestableAnnotationName(jdtAnnotationName);
            AnnotationContainer container = new AnnotationContainer();
            container.initializeFromContainerAnnotation(jdtAnnotation);
            this.annotationContainers.put(nestableAnnotationName, container);
        } else if (this.annotationIsValid(jdtAnnotationName)) {
            this.annotations.put(jdtAnnotationName, this.buildAnnotation(jdtAnnotation));
        } else if (this.annotationIsValidNestable(jdtAnnotationName) && this.annotationContainers.get(jdtAnnotationName) == null) {
            AnnotationContainer container = new AnnotationContainer();
            container.initializeFromStandaloneAnnotation(jdtAnnotation);
            this.annotationContainers.put(jdtAnnotationName, container);
        }
    }

    private boolean annotationIsValid(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().getAnnotationNames(), (Object)annotationName);
    }

    private boolean annotationIsValidContainer(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().getContainerAnnotationNames(), (Object)annotationName);
    }

    private boolean annotationIsValidNestable(String annotationName) {
        return CollectionTools.contains(this.getAnnotationProvider().getNestableAnnotationNames(), (Object)annotationName);
    }

    @Override
    public void update() {
        super.update();
        this.updateAnnotations();
    }

    private void updateAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterable<Annotation> getAnnotations() {
        return new LiveCloneIterable(this.annotations.values());
    }

    @Override
    public int getAnnotationsSize() {
        return this.annotations.size();
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        return this.annotations.get(annotationName);
    }

    @Override
    public Annotation getNonNullAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        return annotation != null ? annotation : this.getNullAnnotation(annotationName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Annotation getNullAnnotation(String annotationName) {
        Hashtable<String, Annotation> hashtable = this.nullAnnotationsCache;
        synchronized (hashtable) {
            Annotation annotation = this.nullAnnotationsCache.get(annotationName);
            if (annotation == null) {
                annotation = this.buildNullAnnotation(annotationName);
                this.nullAnnotationsCache.put(annotationName, annotation);
            }
            return annotation;
        }
    }

    private Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullAnnotation(this, annotationName);
    }

    Annotation buildAnnotation(IAnnotation jdtAnnotation) {
        return this.getAnnotationProvider().buildAnnotation(this, jdtAnnotation);
    }

    private Iterable<NestableAnnotation> getNestableAnnotations() {
        return new CompositeIterable(this.getNestableAnnotationLists());
    }

    private Iterable<Iterable<NestableAnnotation>> getNestableAnnotationLists() {
        return new TransformationIterable(this.getAnnotationContainers(), ANNOTATION_CONTAINER_NESTED_ANNOTATIONS_TRANSFORMER);
    }

    private Iterable<AnnotationContainer> getAnnotationContainers() {
        return new LiveCloneIterable(this.annotationContainers.values());
    }

    @Override
    public ListIterable<NestableAnnotation> getAnnotations(String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container != null ? container.getNestedAnnotations() : EmptyListIterable.instance();
    }

    @Override
    public int getAnnotationsSize(String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container == null ? 0 : container.getNestedAnnotationsSize();
    }

    @Override
    public NestableAnnotation getAnnotation(int index, String nestableAnnotationName) {
        AnnotationContainer container = this.annotationContainers.get(nestableAnnotationName);
        return container == null ? null : container.getNestedAnnotation(index);
    }

    private Iterable<Annotation> getContainerOrStandaloneNestableAnnotations() {
        return new TransformationIterable(this.getAnnotationContainers(), TOP_LEVEL_ANNOTATION_CONTAINER_TRANSFORMER);
    }

    NestableAnnotation buildAnnotation(IAnnotation jdtAnnotation, int index) {
        return this.getAnnotationProvider().buildAnnotation((JavaResourceAnnotatedElement)this, jdtAnnotation, index);
    }

    @Override
    public Iterable<Annotation> getTopLevelAnnotations() {
        return new CompositeIterable(new Iterable[]{this.getAnnotations(), this.getContainerOrStandaloneNestableAnnotations()});
    }

    @Override
    public boolean isAnnotated() {
        return !this.isUnannotated();
    }

    private boolean isUnannotated() {
        return this.annotations.isEmpty() && this.annotationContainers.isEmpty();
    }

    @Override
    public boolean isAnnotatedWithAnyOf(Iterable<String> annotationNames) {
        for (Annotation annotation : this.getSignificantAnnotations()) {
            if (!CollectionTools.contains(annotationNames, (Object)annotation.getAnnotationName())) continue;
            return true;
        }
        return false;
    }

    private Iterable<Annotation> getSignificantAnnotations() {
        return new CompositeIterable(new Iterable[]{this.getAnnotations(), this.getNestableAnnotations()});
    }

    @Override
    protected AnnotationProvider getAnnotationProvider() {
        return super.getAnnotationProvider();
    }

    private IAnnotation[] getJdtAnnotations() {
        try {
            return this.adapter.getAnnotations();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EMPTY_JDT_ANNOTATION_ARRAY;
        }
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String nestableAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextRange getTextRange(String nestableAnnotationName, CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    static interface Adapter {
        public IJavaElement getElement();

        public IAnnotation[] getAnnotations() throws JavaModelException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AnnotationContainer {
        private Annotation containerAnnotation;
        private final Vector<NestableAnnotation> nestedAnnotations = new Vector();

        AnnotationContainer() {
        }

        void initializeFromContainerAnnotation(IAnnotation jdtContainerAnnotation) {
            this.initializeNestedAnnotations(jdtContainerAnnotation);
            this.containerAnnotation = BinaryAnnotatedElement.this.buildAnnotation(jdtContainerAnnotation);
        }

        void initializeNestedAnnotations(IAnnotation jdtContainerAnnotation) {
            Object[] jdtNestedAnnotations = this.getJdtNestedAnnotations(jdtContainerAnnotation);
            int len = jdtNestedAnnotations.length;
            int i = 0;
            while (i < len) {
                IAnnotation jdtNestedAnnotation = (IAnnotation)jdtNestedAnnotations[i];
                this.addAnnotation(jdtNestedAnnotation, i);
                ++i;
            }
        }

        private Object[] getJdtNestedAnnotations(IAnnotation jdtContainerAnnotation) {
            return BinaryAnnotatedElement.this.getJdtMemberValues(jdtContainerAnnotation, "value");
        }

        void initializeFromStandaloneAnnotation(IAnnotation jdtNestableAnnotation) {
            this.addAnnotation(jdtNestableAnnotation, 0);
        }

        private void addAnnotation(IAnnotation jdtNestableAnnotation, int index) {
            this.nestedAnnotations.add(BinaryAnnotatedElement.this.buildAnnotation(jdtNestableAnnotation, index));
        }

        Annotation getContainerAnnotation() {
            return this.containerAnnotation;
        }

        ListIterable<NestableAnnotation> getNestedAnnotations() {
            return new LiveCloneListIterable(this.nestedAnnotations);
        }

        int getNestedAnnotationsSize() {
            return this.nestedAnnotations.size();
        }

        NestableAnnotation getNestedAnnotation(int index) {
            return this.nestedAnnotations.get(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AnnotationContainerNestedAnnotationsTransformer
    extends TransformerAdapter<AnnotationContainer, Iterable<NestableAnnotation>> {
        AnnotationContainerNestedAnnotationsTransformer() {
        }

        public Iterable<NestableAnnotation> transform(AnnotationContainer container) {
            return container.getNestedAnnotations();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TopLevelAnnotationContainerTransformer
    extends TransformerAdapter<AnnotationContainer, Annotation> {
        TopLevelAnnotationContainerTransformer() {
        }

        public Annotation transform(AnnotationContainer container) {
            Annotation containerAnnotation = container.getContainerAnnotation();
            return containerAnnotation != null ? containerAnnotation : container.getNestedAnnotation(0);
        }
    }
}

