/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryAttribute
extends BinaryMember
implements JavaResourceAttribute {
    private int modifiers;
    private String typeName;
    private boolean typeIsInterface;
    private boolean typeIsEnum;
    private boolean typeIsArray;
    private int typeArrayDimensionality;
    private String typeArrayComponentTypeName;
    private final Vector<String> typeSuperclassNames = new Vector();
    private final Vector<String> typeInterfaceNames = new Vector();
    private final Vector<String> typeTypeArgumentNames = new Vector();

    protected BinaryAttribute(JavaResourceType parent, Adapter adapter) {
        super((JavaResourceNode)parent, adapter);
        IMember member = adapter.getElement();
        this.modifiers = this.buildModifiers(member);
        String typeSignature = this.getTypeSignature();
        Iterable<ITypeParameter> typeParameters = this.getAdapter().getTypeParameters();
        this.typeName = this.buildTypeName(typeSignature, typeParameters);
        this.typeIsArray = this.buildTypeIsArray(typeSignature);
        this.typeArrayDimensionality = this.buildTypeArrayDimensionality(typeSignature);
        this.typeArrayComponentTypeName = this.buildTypeArrayComponentTypeName(typeSignature, typeParameters);
        this.typeTypeArgumentNames.addAll(this.buildTypeTypeArgumentNames(typeSignature, typeParameters));
        IType type = this.getType(member.getJavaProject());
        this.typeIsInterface = this.buildTypeIsInterface(type);
        this.typeIsEnum = this.buildTypeIsEnum(type);
        this.typeSuperclassNames.addAll(this.buildTypeSuperclassNames(type));
        this.typeInterfaceNames.addAll(this.buildTypeInterfaceNames(type));
    }

    @Override
    public void update() {
        super.update();
        String typeSignature = this.getTypeSignature();
        Iterable<ITypeParameter> typeParameters = this.getAdapter().getTypeParameters();
        this.setTypeName(this.buildTypeName(typeSignature, typeParameters));
        this.setTypeIsArray(this.buildTypeIsArray(typeSignature));
        this.setTypeArrayDimensionality(this.buildTypeArrayDimensionality(typeSignature));
        this.setTypeArrayComponentTypeName(this.buildTypeArrayComponentTypeName(typeSignature, typeParameters));
        this.setTypeTypeArgumentNames(this.buildTypeTypeArgumentNames(typeSignature, typeParameters));
    }

    @Override
    protected void update(IMember member) {
        super.update(member);
        this.setModifiers(this.buildModifiers(member));
        IType type = this.getType(member.getJavaProject());
        this.setTypeIsInterface(this.buildTypeIsInterface(type));
        this.setTypeIsEnum(this.buildTypeIsEnum(type));
        this.setTypeSuperclassNames(this.buildTypeSuperclassNames(type));
        this.setTypeInterfaceNames(this.buildTypeInterfaceNames(type));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    private Adapter getAdapter() {
        return (Adapter)this.adapter;
    }

    @Override
    public JavaResourceType getParent() {
        return (JavaResourceType)super.getParent();
    }

    @Override
    public JavaResourceType getResourceType() {
        return this.getParent();
    }

    @Override
    public String getName() {
        return this.getAdapter().getAttributeName();
    }

    @Override
    public boolean typeIsSubTypeOf(String tn) {
        return this.typeName != null && this.typeName.equals(tn) || this.typeInterfaceNames.contains(tn) || this.typeSuperclassNames.contains(tn);
    }

    @Override
    public boolean typeIsVariablePrimitive() {
        return this.typeName != null && ClassName.isVariablePrimitive((String)this.typeName);
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    private void setModifiers(int modifiers) {
        int old = this.modifiers;
        this.modifiers = modifiers;
        this.firePropertyChanged("modifiers", old, modifiers);
    }

    private int buildModifiers(IMember member) {
        try {
            return member.getFlags();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return 0;
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    private void setTypeName(String typeName) {
        String old = this.typeName;
        this.typeName = typeName;
        this.firePropertyChanged("typeName", old, typeName);
    }

    private String buildTypeName(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        return BinaryAttribute.convertTypeSignatureToTypeName(typeSignature, typeParameters);
    }

    @Override
    public boolean typeIsInterface() {
        return this.typeIsInterface;
    }

    private void setTypeIsInterface(boolean typeIsInterface) {
        boolean old = this.typeIsInterface;
        this.typeIsInterface = typeIsInterface;
        this.firePropertyChanged("typeIsInterface", old, typeIsInterface);
    }

    private boolean buildTypeIsInterface(IType type) {
        try {
            return type != null && type.isInterface();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean typeIsEnum() {
        return this.typeIsEnum;
    }

    private void setTypeIsEnum(boolean typeIsEnum) {
        boolean old = this.typeIsEnum;
        this.typeIsEnum = typeIsEnum;
        this.firePropertyChanged("typeIsEnum", old, typeIsEnum);
    }

    private boolean buildTypeIsEnum(IType type) {
        try {
            return type != null && type.isEnum();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return false;
        }
    }

    @Override
    public boolean typeIsArray() {
        return this.typeIsArray;
    }

    private void setTypeIsArray(boolean typeIsArray) {
        boolean old = this.typeIsArray;
        this.typeIsArray = typeIsArray;
        this.firePropertyChanged("typeIsArray", old, typeIsArray);
    }

    private boolean buildTypeIsArray(String typeSignature) {
        return BinaryAttribute.convertTypeSignatureToTypeIsArray(typeSignature);
    }

    @Override
    public int getTypeArrayDimensionality() {
        return this.typeArrayDimensionality;
    }

    private void setTypeArrayDimensionality(int typeArrayDimensionality) {
        int old = this.typeArrayDimensionality;
        this.typeArrayDimensionality = typeArrayDimensionality;
        this.firePropertyChanged("typeArrayDimensionality", old, typeArrayDimensionality);
    }

    private int buildTypeArrayDimensionality(String typeSignature) {
        return BinaryAttribute.convertTypeSignatureToTypeArrayDimensionality(typeSignature);
    }

    @Override
    public String getTypeArrayComponentTypeName() {
        return this.typeArrayComponentTypeName;
    }

    private void setTypeArrayComponentTypeName(String typeArrayComponentTypeName) {
        String old = this.typeArrayComponentTypeName;
        this.typeArrayComponentTypeName = typeArrayComponentTypeName;
        this.firePropertyChanged("typeArrayComponentTypeName", old, typeArrayComponentTypeName);
    }

    private String buildTypeArrayComponentTypeName(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        int arrayDimensionality = BinaryAttribute.convertTypeSignatureToTypeArrayDimensionality(typeSignature);
        return arrayDimensionality == 0 ? null : BinaryAttribute.convertTypeSignatureToTypeArrayComponentTypeName(typeSignature, typeParameters);
    }

    @Override
    public ListIterable<String> getTypeSuperclassNames() {
        return new LiveCloneListIterable(this.typeSuperclassNames);
    }

    public boolean typeSuperclassNamesContains(String superclassName) {
        return this.typeSuperclassNames.contains(superclassName);
    }

    private void setTypeSuperclassNames(List<String> typeSuperclassNames) {
        this.synchronizeList(typeSuperclassNames, this.typeSuperclassNames, "typeSuperclassNames");
    }

    private List<String> buildTypeSuperclassNames(IType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        type = this.findSuperclass(type);
        while (type != null) {
            names.add(type.getFullyQualifiedName('.'));
            type = this.findSuperclass(type);
        }
        return names;
    }

    @Override
    public Iterable<String> getTypeInterfaceNames() {
        return new LiveCloneIterable(this.typeInterfaceNames);
    }

    public boolean typeInterfaceNamesContains(String interfaceName) {
        return this.typeInterfaceNames.contains(interfaceName);
    }

    private void setTypeInterfaceNames(Collection<String> typeInterfaceNames) {
        this.synchronizeCollection(typeInterfaceNames, this.typeInterfaceNames, "typeInterfaceNames");
    }

    private Collection<String> buildTypeInterfaceNames(IType type) {
        if (type == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        while (type != null) {
            this.addInterfaceNamesTo(type, names);
            type = this.findSuperclass(type);
        }
        return names;
    }

    private void addInterfaceNamesTo(IType type, HashSet<String> names) {
        String[] stringArray = this.getSuperInterfaceTypeSignatures(type);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceSignature = stringArray[n2];
            String interfaceName = BinaryAttribute.convertTypeSignatureToTypeName(interfaceSignature);
            names.add(interfaceName);
            IType interfaceType = BinaryAttribute.findType(interfaceName, type.getJavaProject());
            if (interfaceType != null) {
                this.addInterfaceNamesTo(interfaceType, names);
            }
            ++n2;
        }
    }

    @Override
    public ListIterable<String> getTypeTypeArgumentNames() {
        return new LiveCloneListIterable(this.typeTypeArgumentNames);
    }

    @Override
    public int getTypeTypeArgumentNamesSize() {
        return this.typeTypeArgumentNames.size();
    }

    @Override
    public String getTypeTypeArgumentName(int index) {
        return this.typeTypeArgumentNames.get(index);
    }

    private void setTypeTypeArgumentNames(List<String> typeTypeArgumentNames) {
        this.synchronizeList(typeTypeArgumentNames, this.typeTypeArgumentNames, "typeTypeArgumentNames");
    }

    private List<String> buildTypeTypeArgumentNames(String typeSignature, Iterable<ITypeParameter> typeParameters) {
        int arrayDimensionality = BinaryAttribute.convertTypeSignatureToTypeArrayDimensionality(typeSignature);
        return arrayDimensionality != 0 ? Collections.emptyList() : BinaryAttribute.convertTypeSignatureToTypeTypeArgumentNames(typeSignature, typeParameters);
    }

    private String getTypeSignature() {
        try {
            return this.getAdapter().getTypeSignature();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    private IType findSuperclass(IType type) {
        return this.findTypeBySignature(this.getSuperclassSignature(type), type.getJavaProject());
    }

    private String getSuperclassSignature(IType type) {
        try {
            return type.getSuperclassTypeSignature();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    private String[] getSuperInterfaceTypeSignatures(IType type) {
        try {
            return type.getSuperInterfaceTypeSignatures();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return StringTools.EMPTY_STRING_ARRAY;
        }
    }

    private IType findTypeBySignature(String typeSignature, IJavaProject javaProject) {
        return typeSignature == null ? null : BinaryAttribute.findType(BinaryAttribute.convertTypeSignatureToTypeName_(typeSignature), javaProject);
    }

    private IType getType(IJavaProject javaProject) {
        return this.typeName == null ? null : BinaryAttribute.findType(this.typeName, javaProject);
    }

    private static IType findType(String fullyQualifiedName, IJavaProject javaProject) {
        try {
            return javaProject.findType(fullyQualifiedName);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return null;
        }
    }

    static interface Adapter
    extends BinaryMember.Adapter {
        public String getAttributeName();

        public String getTypeSignature() throws JavaModelException;
    }
}

