/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryClassFile;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceClassFile;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragment;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryPackageFragment
extends BinaryNode
implements JavaResourcePackageFragment {
    private final IPackageFragment packageFragment;
    private final Vector<JavaResourceClassFile> classFiles = new Vector();
    protected static final IJavaElement[] EMPTY_JAVA_ELEMENT_ARRAY = new IJavaElement[0];

    BinaryPackageFragment(JavaResourcePackageFragmentRoot parent, IPackageFragment packageFragment) {
        super(parent);
        this.packageFragment = packageFragment;
        this.classFiles.addAll(this.buildClassFiles());
    }

    private Collection<JavaResourceClassFile> buildClassFiles() {
        IJavaElement[] children = this.getJDTChildren();
        ArrayList<JavaResourceClassFile> result = new ArrayList<JavaResourceClassFile>(children.length);
        HashBag annotationNames = CollectionTools.collection(this.getAnnotationProvider().getAnnotationNames());
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            IClassFile jdtClassFile = (IClassFile)child;
            IType jdtType = jdtClassFile.getType();
            if (BinaryPackageFragment.typeIsRelevant(jdtType, (Collection<String>)annotationNames)) {
                result.add(new BinaryClassFile(this, jdtClassFile, jdtType));
            }
            ++n2;
        }
        return result;
    }

    static boolean typeIsRelevant(IType type, Collection<String> annotationNames) {
        try {
            return type != null && type.exists() && (type.isClass() || type.isInterface() || type.isEnum()) && BinaryPackageFragment.typeHasAnnotations(type, annotationNames);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    static boolean typeHasAnnotations(IType type, Collection<String> annotationNames) {
        IAnnotation[] annotations;
        try {
            annotations = type.getAnnotations();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        IAnnotation[] iAnnotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if (annotationNames.contains(annotation.getElementName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.updateClassFiles();
    }

    private void updateClassFiles() {
        throw new UnsupportedOperationException();
    }

    public ListIterable<JavaResourceClassFile> getClassFiles() {
        return new LiveCloneListIterable(this.classFiles);
    }

    @Override
    public int getClassFilesSize() {
        return this.classFiles.size();
    }

    @Override
    public Iterable<JavaResourceAbstractType> getTypes() {
        return new TransformationIterable<JavaResourceClassFile, JavaResourceAbstractType>(this.getClassFiles()){

            protected JavaResourceAbstractType transform(JavaResourceClassFile classFile) {
                return classFile.getType();
            }
        };
    }

    private IJavaElement[] getJDTChildren() {
        try {
            return this.packageFragment.getChildren();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.log(ex);
            return EMPTY_JAVA_ELEMENT_ARRAY;
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.packageFragment.getElementName());
    }
}

