/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jpt.common.core.internal.utility.JobSynchronizer;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.synchronizers.CallbackSynchronizer;

public class CallbackJobSynchronizer
extends JobSynchronizer
implements CallbackSynchronizer {
    private final ListenerList<CallbackSynchronizer.Listener> listenerList = new ListenerList(CallbackSynchronizer.Listener.class);

    public CallbackJobSynchronizer(String jobName, JobCommand command) {
        super(jobName, command);
    }

    public CallbackJobSynchronizer(String jobName, JobCommand command, ISchedulingRule schedulingRule) {
        super(jobName, command, schedulingRule);
    }

    JobSynchronizer.SynchronizationJob buildJob(String jobName, JobCommand command, ISchedulingRule schedulingRule) {
        return new CallbackSynchronizationJob(jobName, command, schedulingRule);
    }

    public void addListener(CallbackSynchronizer.Listener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeListener(CallbackSynchronizer.Listener listener) {
        this.listenerList.remove((Object)listener);
    }

    void synchronizationQuiesced() {
        for (CallbackSynchronizer.Listener listener : this.listenerList.getListeners()) {
            listener.synchronizationQuiesced((CallbackSynchronizer)this);
        }
    }

    class CallbackSynchronizationJob
    extends JobSynchronizer.SynchronizationJob {
        private volatile boolean scheduled;

        CallbackSynchronizationJob(String jobName, JobCommand command, ISchedulingRule schedulingRule) {
            super(jobName, command, schedulingRule);
            this.scheduled = false;
        }

        void synchronize() {
            if (this.shouldSchedule) {
                this.scheduled = true;
            }
            super.synchronize();
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.scheduled = false;
            IStatus status = super.run(monitor);
            if (!this.scheduled) {
                CallbackJobSynchronizer.this.synchronizationQuiesced();
            }
            return status;
        }

        void stop() {
            this.scheduled = false;
            super.stop();
        }
    }
}

