/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformTools {
    public static <A> A getAdapter(Object o, Class<A> adapterType) {
        return (A)Platform.getAdapterManager().getAdapter(o, adapterType);
    }

    public static IContainer getContainer(IPath fullContainerPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = fullContainerPath.segment(0).toString();
        IPath projectRelativePath = fullContainerPath.removeFirstSegments(1);
        IProject project = root.getProject(projectName);
        if (projectRelativePath.isEmpty()) {
            return project;
        }
        return project.getFolder(projectRelativePath);
    }

    public static IFile getFile(IPath fullFilePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = fullFilePath.segment(0).toString();
        IPath projectRelativePath = fullFilePath.removeFirstSegments(1);
        IProject project = root.getProject(projectName);
        return project.getFile(projectRelativePath);
    }

    public static IContentType getContentType(IFile file) {
        String fileName = file.getName();
        InputStream fileContents = null;
        try {
            fileContents = file.getContents();
        }
        catch (CoreException coreException) {
            return PlatformTools.findContentTypeFor(fileName);
        }
        IContentType contentType = null;
        try {
            try {
                contentType = PlatformTools.findContentTypeFor(fileContents, fileName);
            }
            catch (IOException ex) {
                JptCommonCorePlugin.log(ex);
                try {
                    fileContents.close();
                }
                catch (IOException ex2) {
                    JptCommonCorePlugin.log(ex2);
                }
            }
        }
        finally {
            try {
                fileContents.close();
            }
            catch (IOException ex) {
                JptCommonCorePlugin.log(ex);
            }
        }
        return contentType;
    }

    private static IContentType findContentTypeFor(InputStream fileContents, String fileName) throws IOException {
        return PlatformTools.getContentTypeManager().findContentTypeFor(fileContents, fileName);
    }

    private static IContentType findContentTypeFor(String fileName) {
        return PlatformTools.getContentTypeManager().findContentTypeFor(fileName);
    }

    private static IContentTypeManager getContentTypeManager() {
        return Platform.getContentTypeManager();
    }

    private PlatformTools() {
        throw new UnsupportedOperationException();
    }
}

