/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbQName;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaQName;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.QNameAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementDeclAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaElementFactoryMethod
extends AbstractJavaContextNode
implements JaxbElementFactoryMethod {
    protected final JavaResourceMethod resourceMethod;
    protected String scope;
    protected JaxbQName qName;
    protected JaxbQName substitutionHeadQName;
    protected String defaultValue;

    public GenericJavaElementFactoryMethod(XmlRegistry parent, JavaResourceMethod resourceMethod) {
        super(parent);
        this.resourceMethod = resourceMethod;
        this.scope = this.getResourceScope();
        this.qName = this.buildQName();
        this.substitutionHeadQName = this.buildSubstitutionHeadQName();
        this.defaultValue = this.getResourceDefaultValue();
    }

    protected JaxbQName buildQName() {
        return new XmlElementDeclQName(this);
    }

    protected JaxbQName buildSubstitutionHeadQName() {
        return new XmlElementDeclSubstitutionHeadQName(this);
    }

    protected XmlRegistry getRegistry() {
        return (XmlRegistry)this.getParent();
    }

    @Override
    public JavaResourceMethod getResourceMethod() {
        return this.resourceMethod;
    }

    protected XmlElementDeclAnnotation getXmlElementDeclAnnotation() {
        return (XmlElementDeclAnnotation)this.getResourceMethod().getAnnotation("javax.xml.bind.annotation.XmlElementDecl");
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setScope_(this.getResourceScope());
        this.qName.synchronizeWithResourceModel();
        this.substitutionHeadQName.synchronizeWithResourceModel();
        this.setDefaultValue_(this.getResourceDefaultValue());
    }

    @Override
    public void update() {
        super.update();
        this.qName.update();
        this.substitutionHeadQName.update();
    }

    @Override
    public String getName() {
        return this.resourceMethod.getName();
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    protected void setScope_(String scope) {
        String old = this.scope;
        this.scope = scope;
        this.firePropertyChanged("scope", old, scope);
    }

    @Override
    public void setScope(String scope) {
        this.getXmlElementDeclAnnotation().setScope(scope);
        this.setScope_(scope);
    }

    protected String getResourceScope() {
        return this.getXmlElementDeclAnnotation().getScope();
    }

    @Override
    public String getFullyQualifiedScope() {
        return this.scope == null ? "javax.xml.bind.annotation.XmlElementDecl.GLOBAL" : this.getXmlElementDeclAnnotation().getFullyQualifiedScopeClassName();
    }

    @Override
    public boolean isGlobalScope() {
        return "javax.xml.bind.annotation.XmlElementDecl.GLOBAL".equals(this.getFullyQualifiedScope());
    }

    @Override
    public JaxbQName getQName() {
        return this.qName;
    }

    @Override
    public JaxbQName getSubstitutionHeadQName() {
        return this.substitutionHeadQName;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue_(String defaultValue) {
        String old = this.defaultValue;
        this.defaultValue = defaultValue;
        this.firePropertyChanged("defaultValue", old, defaultValue);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.getXmlElementDeclAnnotation().setDefaultValue(defaultValue);
        this.setDefaultValue_(defaultValue);
    }

    protected String getResourceDefaultValue() {
        return this.getXmlElementDeclAnnotation().getDefaultValue();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.qName.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        result = this.substitutionHeadQName.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getXmlElementDeclAnnotation().getTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.qName.validate(messages, reporter, astRoot);
        this.substitutionHeadQName.validate(messages, reporter, astRoot);
        JavaResourceMethod resourceMethod = this.getResourceMethod();
        this.validateMethodReturnType(resourceMethod, messages, astRoot);
        if (resourceMethod.getParametersSize() != 1) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_DECL__INVALID_METHOD_SIGNATURE_PARAM", this, this.getValidationTextRange(astRoot)));
        }
    }

    protected void validateMethodReturnType(JavaResourceMethod resourceMethod, List<IMessage> messages, CompilationUnit astRoot) {
        if (!"javax.xml.bind.JAXBElement".equals(resourceMethod.getTypeName())) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_DECL__INVALID_METHOD_SIGNATURE_RETURN_TYPE", this, this.getValidationTextRange(astRoot)));
        }
    }

    protected class QNameAnnotationProxy
    extends AbstractJavaQName.AbstractQNameAnnotationProxy {
        protected QNameAnnotationProxy() {
        }

        protected QNameAnnotation getAnnotation(boolean createIfNull) {
            return GenericJavaElementFactoryMethod.this.getXmlElementDeclAnnotation();
        }
    }

    protected class SubstitutionHeadQNameAnnotationProxy
    implements AbstractJavaQName.AnnotationProxy {
        protected SubstitutionHeadQNameAnnotationProxy() {
        }

        protected XmlElementDeclAnnotation getAnnotation() {
            return GenericJavaElementFactoryMethod.this.getXmlElementDeclAnnotation();
        }

        public String getNamespace() {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? null : annotation.getSubstitutionHeadNamespace();
        }

        public void setNamespace(String newSpecifiedNamespace) {
            this.getAnnotation().setSubstitutionHeadNamespace(newSpecifiedNamespace);
        }

        public boolean namespaceTouches(int pos, CompilationUnit astRoot) {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? false : annotation.substitutionHeadNamespaceTouches(pos, astRoot);
        }

        public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? null : annotation.getSubstitutionHeadNamespaceTextRange(astRoot);
        }

        public String getName() {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? null : annotation.getSubstitutionHeadName();
        }

        public void setName(String newSpecifiedName) {
            this.getAnnotation().setSubstitutionHeadName(newSpecifiedName);
        }

        public boolean nameTouches(int pos, CompilationUnit astRoot) {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? false : annotation.substitutionHeadNameTouches(pos, astRoot);
        }

        public TextRange getNameTextRange(CompilationUnit astRoot) {
            XmlElementDeclAnnotation annotation = this.getAnnotation();
            return annotation == null ? null : annotation.getSubstitutionHeadNameTextRange(astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlElementDeclQName
    extends AbstractJavaQName {
        protected XmlElementDeclQName(JavaContextNode parent) {
            super(parent, new QNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaElementFactoryMethod.this.getRegistry().getJaxbClass().getJaxbPackage();
        }

        @Override
        public String getDefaultName() {
            return null;
        }

        @Override
        public String getDefaultNamespace() {
            JaxbPackage jaxbPackage = this.getJaxbPackage();
            return jaxbPackage == null ? null : jaxbPackage.getNamespace();
        }

        @Override
        public Iterable<String> getNameProposals(Filter<String> filter) {
            XsdSchema xsdSchema;
            if (!GenericJavaElementFactoryMethod.this.isGlobalScope()) {
                XsdTypeDefinition xsdType;
                String fqScope = GenericJavaElementFactoryMethod.this.getFullyQualifiedScope();
                JaxbTypeMapping scopeTypeMapping = GenericJavaElementFactoryMethod.this.getJaxbProject().getContextRoot().getTypeMapping(fqScope);
                if (scopeTypeMapping != null && (xsdType = scopeTypeMapping.getXsdTypeDefinition()) != null) {
                    return xsdType.getElementNameProposals(this.getNamespace(), filter, true);
                }
            }
            if ((xsdSchema = this.getXsdSchema()) != null) {
                return xsdSchema.getElementNameProposals(this.getNamespace(), filter);
            }
            return EmptyIterable.instance();
        }

        @Override
        public Iterable<String> getNamespaceProposals(Filter<String> filter) {
            XsdSchema xsdSchema = this.getXsdSchema();
            return xsdSchema == null ? EmptyIterable.instance() : xsdSchema.getNamespaceProposals(filter);
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.XML_ELEMENT_DESC;
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            if (!GenericJavaElementFactoryMethod.this.isGlobalScope()) {
                String fqScope = GenericJavaElementFactoryMethod.this.getFullyQualifiedScope();
                JaxbTypeMapping scopeTypeMapping = GenericJavaElementFactoryMethod.this.getJaxbProject().getContextRoot().getTypeMapping(fqScope);
                if (scopeTypeMapping != null) {
                    XsdTypeDefinition xsdType = scopeTypeMapping.getXsdTypeDefinition();
                    if (xsdType == null) {
                        return;
                    }
                    if (xsdType.getElement(this.getNamespace(), this.getName(), true) == null) {
                        messages.add(this.getUnresolveSchemaComponentMessage(astRoot));
                    }
                }
            } else {
                XsdSchema xsdSchema = this.getXsdSchema();
                if (xsdSchema != null && xsdSchema.getElementDeclaration(this.getNamespace(), this.getName()) == null) {
                    messages.add(this.getUnresolveSchemaComponentMessage(astRoot));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlElementDeclSubstitutionHeadQName
    extends AbstractJavaQName {
        protected XmlElementDeclSubstitutionHeadQName(JavaContextNode parent) {
            super(parent, new SubstitutionHeadQNameAnnotationProxy());
        }

        @Override
        protected JaxbPackage getJaxbPackage() {
            return GenericJavaElementFactoryMethod.this.getRegistry().getJaxbClass().getJaxbPackage();
        }

        @Override
        public String getDefaultName() {
            return null;
        }

        @Override
        public String getDefaultNamespace() {
            JaxbPackage jaxbPackage = this.getJaxbPackage();
            return jaxbPackage == null ? null : jaxbPackage.getNamespace();
        }

        @Override
        public Iterable<String> getNameProposals(Filter<String> filter) {
            XsdTypeDefinition xsdType;
            String fqScope = GenericJavaElementFactoryMethod.this.getFullyQualifiedScope();
            JaxbTypeMapping scopeTypeMapping = GenericJavaElementFactoryMethod.this.getJaxbProject().getContextRoot().getTypeMapping(fqScope);
            if (scopeTypeMapping != null && (xsdType = scopeTypeMapping.getXsdTypeDefinition()) != null) {
                return xsdType.getElementNameProposals(this.getNamespace(), filter);
            }
            XsdSchema xsdSchema = this.getXsdSchema();
            if (xsdSchema != null) {
                return xsdSchema.getElementNameProposals(this.getNamespace(), filter);
            }
            return EmptyIterable.instance();
        }

        @Override
        public Iterable<String> getNamespaceProposals(Filter<String> filter) {
            XsdSchema xsdSchema = this.getXsdSchema();
            return xsdSchema == null ? EmptyIterable.instance() : xsdSchema.getNamespaceProposals(filter);
        }

        @Override
        public String getReferencedComponentTypeDescription() {
            return JptJaxbCoreMessages.SUBSTITUTION_HEAD_DESC;
        }

        @Override
        protected void validateName(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            if ("".equals(this.getName())) {
                messages.add(DefaultValidationMessages.buildMessage(1, "QNAME__MISSING_NAME", new String[]{this.getReferencedComponentTypeDescription()}, this, this.getNameTextRange(astRoot)));
            } else if (!StringTools.stringIsEmpty((String)this.getName()) && Tools.valuesAreEqual((Object)this.getName(), (Object)GenericJavaElementFactoryMethod.this.getQName().getName())) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_DECL__SUBST_HEAD_NAME_EQUALS_NAME", this, this.getNameTextRange(astRoot)));
            }
        }

        @Override
        protected void validateReference(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
            XsdSchema xsdSchema = this.getXsdSchema();
            if (xsdSchema != null && xsdSchema.getElementDeclaration(this.getNamespace(), this.getName()) == null) {
                messages.add(this.getUnresolveSchemaComponentMessage(astRoot));
            }
            for (JaxbElementFactoryMethod elementDecl : GenericJavaElementFactoryMethod.this.getRegistry().getElementFactoryMethods()) {
                if (!Tools.valuesAreEqual((Object)this.getName(), (Object)elementDecl.getSubstitutionHeadQName().getName()) || !Tools.valuesAreEqual((Object)this.getNamespace(), (Object)elementDecl.getSubstitutionHeadQName().getNamespace())) continue;
                return;
            }
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ELEMENT_DECL__SUBST_HEAD_NO_MATCHING_ELEMENT_DECL", new String[]{this.getNamespace(), this.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }
}

