/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbEnum;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbType;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaEnumMapping
extends AbstractJavaTypeMapping
implements JaxbEnumMapping {
    protected String specifiedXmlEnumValue;
    protected final EnumConstantContainer enumConstantContainer = new EnumConstantContainer();

    public GenericJavaEnumMapping(JaxbEnum parent) {
        super(parent);
        this.initXmlEnumValue();
        this.initEnumConstants();
    }

    public JavaResourceEnum getJavaResourceType() {
        return (JavaResourceEnum)super.getJavaResourceType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncXmlEnumValue();
        this.syncEnumConstants();
    }

    @Override
    public void update() {
        super.update();
        this.updateEnumConstants();
    }

    @Override
    public String getXmlEnumValue() {
        return this.specifiedXmlEnumValue != null ? this.specifiedXmlEnumValue : "java.lang.String";
    }

    @Override
    public String getSpecifiedXmlEnumValue() {
        return this.specifiedXmlEnumValue;
    }

    @Override
    public void setSpecifiedXmlEnumValue(String xmlEnumValue) {
        this.getXmlEnumAnnotation().setValue(xmlEnumValue);
        this.setSpecifiedXmlEnumValue_(xmlEnumValue);
    }

    protected void setSpecifiedXmlEnumValue_(String xmlEnumValue) {
        String old = this.specifiedXmlEnumValue;
        this.specifiedXmlEnumValue = xmlEnumValue;
        this.firePropertyChanged("specifiedXmlEnum", old, xmlEnumValue);
    }

    @Override
    public String getFullyQualifiedXmlEnumValue() {
        return this.specifiedXmlEnumValue != null ? this.getXmlEnumAnnotation().getFullyQualifiedValueClassName() : "java.lang.String";
    }

    protected XmlEnumAnnotation getXmlEnumAnnotation() {
        return (XmlEnumAnnotation)this.getJavaResourceType().getNonNullAnnotation("javax.xml.bind.annotation.XmlEnum");
    }

    protected String getResourceXmlEnumValue() {
        return this.getXmlEnumAnnotation().getValue();
    }

    protected void initXmlEnumValue() {
        this.specifiedXmlEnumValue = this.getResourceXmlEnumValue();
    }

    protected void syncXmlEnumValue() {
        this.setSpecifiedXmlEnumValue_(this.getResourceXmlEnumValue());
    }

    @Override
    public Iterable<JaxbEnumConstant> getEnumConstants() {
        return this.enumConstantContainer.getContextElements();
    }

    @Override
    public int getEnumConstantsSize() {
        return this.enumConstantContainer.getContextElementsSize();
    }

    protected void initEnumConstants() {
        this.enumConstantContainer.initialize();
    }

    protected void syncEnumConstants() {
        this.enumConstantContainer.synchronizeWithResourceModel();
    }

    protected void updateEnumConstants() {
        this.enumConstantContainer.update();
    }

    protected Iterable<JavaResourceEnumConstant> getResourceEnumConstants() {
        return this.getJavaResourceType().getEnumConstants();
    }

    private JaxbEnumConstant buildEnumConstant(JavaResourceEnumConstant resourceEnumConstant) {
        return this.getFactory().buildJavaEnumConstant(this, resourceEnumConstant);
    }

    @Override
    protected Iterable<String> getNonTransientReferencedXmlTypeNames() {
        if (this.specifiedXmlEnumValue != null) {
            return new CompositeIterable(new Iterable[]{super.getNonTransientReferencedXmlTypeNames(), new SingleElementIterable((Object)this.getFullyQualifiedXmlEnumValue())});
        }
        return super.getNonTransientReferencedXmlTypeNames();
    }

    @Override
    public XsdSimpleTypeDefinition getValueXsdTypeDefinition() {
        XsdTypeDefinition xsdType = this.getValueXsdTypeDefinition_();
        if (xsdType == null || xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE) {
            return null;
        }
        return (XsdSimpleTypeDefinition)xsdType;
    }

    protected XsdTypeDefinition getValueXsdTypeDefinition_() {
        String fqXmlEnumValue = this.getFullyQualifiedXmlEnumValue();
        JaxbType jaxbType = this.getContextRoot().getType(fqXmlEnumValue);
        if (jaxbType != null) {
            JaxbTypeMapping typeMapping = jaxbType.getMapping();
            if (typeMapping != null) {
                return typeMapping.getXsdTypeDefinition();
            }
        } else {
            String typeMapping = this.getJaxbProject().getPlatform().getDefinition().getSchemaTypeMapping(fqXmlEnumValue);
            if (typeMapping != null) {
                XsdSchema xsdSchema = XsdUtil.getSchemaForSchema();
                return xsdSchema.getTypeDefinition(typeMapping);
            }
        }
        return null;
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        for (JaxbEnumConstant constant : this.getEnumConstants()) {
            result = constant.getJavaCompletionProposals(pos, filter, astRoot);
            if (CollectionTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateXmlType(messages, reporter, astRoot);
        this.validateXmlEnum(messages, reporter, astRoot);
        for (JaxbEnumConstant constant : this.getEnumConstants()) {
            constant.validate(messages, reporter, astRoot);
        }
    }

    protected void validateXmlType(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        XmlTypeAnnotation annotation = this.getXmlTypeAnnotation();
        if (annotation.getFactoryClass() != null) {
            messages.add(DefaultValidationMessages.buildMessage(2, "XML_TYPE__FACTORY_CLASS_IGNORED_FOR_ENUM", this, annotation.getFactoryClassTextRange(astRoot)));
        }
        if (annotation.getFactoryMethod() != null) {
            messages.add(DefaultValidationMessages.buildMessage(2, "XML_TYPE__FACTORY_METHOD_IGNORED_FOR_ENUM", this, annotation.getFactoryMethodTextRange(astRoot)));
        }
        if (!CollectionTools.isEmpty(annotation.getPropOrder())) {
            messages.add(DefaultValidationMessages.buildMessage(2, "XML_TYPE__PROP_ORDER_IGNORED_FOR_ENUM", this, annotation.getPropOrderTextRange(astRoot)));
        }
    }

    protected void validateXmlEnum(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        XsdSchema xsdSchema = this.getJaxbPackage().getXsdSchema();
        XsdTypeDefinition xsdType = this.getValueXsdTypeDefinition_();
        if (xsdSchema != null && xsdType == null || xsdType != null && xsdType.getKind() != XsdTypeDefinition.Kind.SIMPLE) {
            messages.add(DefaultValidationMessages.buildMessage(1, "XML_ENUM__NON_SIMPLE_SCHEMA_TYPE", new String[]{this.getFullyQualifiedXmlEnumValue()}, this, this.getXmlEnumValueTextRange(astRoot)));
        }
    }

    protected TextRange getXmlEnumValueTextRange(CompilationUnit astRoot) {
        return this.getXmlEnumAnnotation().getValueTextRange(astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EnumConstantContainer
    extends AbstractJaxbNode.ContextCollectionContainer<JaxbEnumConstant, JavaResourceEnumConstant> {
        protected EnumConstantContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "enumConstants";
        }

        @Override
        protected JaxbEnumConstant buildContextElement(JavaResourceEnumConstant resourceElement) {
            return GenericJavaEnumMapping.this.buildEnumConstant(resourceElement);
        }

        @Override
        protected Iterable<JavaResourceEnumConstant> getResourceElements() {
            return GenericJavaEnumMapping.this.getResourceEnumConstants();
        }

        @Override
        protected JavaResourceEnumConstant getResourceElement(JaxbEnumConstant contextElement) {
            return contextElement.getResourceEnumConstant();
        }
    }
}

