/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.JptResourceModelListener;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxbFileResourceModel<S>
implements JptResourceModel {
    protected final IFile file;
    protected final String packageName;
    protected final S state;
    protected final ListenerList<JptResourceModelListener> resourceModelListenerList = new ListenerList(JptResourceModelListener.class);

    protected AbstractJaxbFileResourceModel(IFile file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.packageName = this.buildPackageName();
        this.state = this.buildState();
        this.load();
    }

    protected String buildPackageName() {
        String pkg = this.buildPackageName_();
        return StringTools.stringIsEmpty((String)pkg) ? null : pkg;
    }

    protected String buildPackageName_() {
        IJavaElement javaElement = JavaCore.create((IResource)this.file.getParent());
        if (javaElement != null && javaElement.getElementType() == 4) {
            return ((IPackageFragment)javaElement).getElementName();
        }
        return null;
    }

    protected abstract S buildState();

    public String getPackageName() {
        return this.packageName;
    }

    protected void reload() {
        this.load();
    }

    protected void load() {
        InputStream stream = null;
        try {
            try {
                stream = this.file.getContents();
                if (stream != null) {
                    this.load(new BufferedInputStream(stream));
                }
            }
            catch (CoreException coreException) {
                this.closeStream(stream);
            }
            catch (Exception ex) {
                JptJaxbCorePlugin.log(ex);
                this.closeStream(stream);
            }
        }
        finally {
            this.closeStream(stream);
        }
    }

    protected abstract void load(InputStream var1) throws IOException;

    protected void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException ex) {
            JptJaxbCorePlugin.log(ex);
        }
    }

    public void update() {
        this.reload();
        this.resourceModelChanged();
    }

    public IFile getFile() {
        return this.file;
    }

    public void addResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.add((Object)listener);
    }

    public void removeResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.remove((Object)listener);
    }

    protected void resourceModelChanged() {
        for (JptResourceModelListener listener : this.resourceModelListenerList.getListeners()) {
            listener.resourceModelChanged((JptResourceModel)this);
        }
    }
}

