/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAttributeAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceXmlAttributeAnnotation
extends SourceAnnotation
implements XmlAttributeAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlAttribute");
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private final DeclarationAnnotationElementAdapter<String> namespaceDeclarationAdapter;
    private final AnnotationElementAdapter<String> namespaceAdapter;
    private String namespace;
    private final DeclarationAnnotationElementAdapter<Boolean> requiredDeclarationAdapter;
    private final AnnotationElementAdapter<Boolean> requiredAdapter;
    private Boolean required;

    public SourceXmlAttributeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        this(parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new ElementAnnotationAdapter(annotatedElement, DECLARATION_ANNOTATION_ADAPTER));
    }

    public SourceXmlAttributeAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super((JavaResourceNode)parent, annotatedElement, daa, annotationAdapter);
        this.nameDeclarationAdapter = this.buildNameAdapter(daa);
        this.nameAdapter = this.buildAnnotationElementAdapter(this.nameDeclarationAdapter);
        this.namespaceDeclarationAdapter = this.buildNamespaceAdapter(daa);
        this.namespaceAdapter = this.buildAnnotationElementAdapter(this.namespaceDeclarationAdapter);
        this.requiredDeclarationAdapter = this.buildRequiredAdapter(daa);
        this.requiredAdapter = this.buildShortCircuitBooleanElementAdapter(this.requiredDeclarationAdapter);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"name");
    }

    private DeclarationAnnotationElementAdapter<String> buildNamespaceAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)daa, (String)"namespace");
    }

    private DeclarationAnnotationElementAdapter<Boolean> buildRequiredAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forBooleans((DeclarationAnnotationAdapter)daa, (String)"required");
    }

    private AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private AnnotationElementAdapter<Boolean> buildShortCircuitBooleanElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlAttribute";
    }

    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.namespace = this.buildNamespace(astRoot);
        this.required = this.buildRequired(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncNamespace(this.buildNamespace(astRoot));
        this.syncRequired(this.buildRequired(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        if (this.attributeValueHasChanged(this.namespace, namespace)) {
            this.namespace = namespace;
            this.namespaceAdapter.setValue((Object)namespace);
        }
    }

    private void syncNamespace(String astNamespace) {
        String old = this.namespace;
        this.namespace = astNamespace;
        this.firePropertyChanged("namespace", old, astNamespace);
    }

    private String buildNamespace(CompilationUnit astRoot) {
        return (String)this.namespaceAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNamespaceTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.namespaceDeclarationAdapter, astRoot);
    }

    @Override
    public boolean namespaceTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.namespaceDeclarationAdapter, pos, astRoot);
    }

    @Override
    public Boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(Boolean required) {
        if (this.attributeValueHasChanged(this.required, required)) {
            this.required = required;
            this.requiredAdapter.setValue((Object)required);
        }
    }

    private void syncRequired(Boolean astRequired) {
        Boolean old = this.required;
        this.required = astRequired;
        this.firePropertyChanged("required", old, astRequired);
    }

    private Boolean buildRequired(CompilationUnit astRoot) {
        return (Boolean)this.requiredAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getRequiredTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.requiredDeclarationAdapter, astRoot);
    }
}

