/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.validation;

import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class DefaultValidationMessages {
    private static String[] DEFAULT_PARMS = new String[0];
    private static TextRange DEFAULT_TEXT_RANGE = TextRange.Empty.instance();
    private static final MessageFactory MESSAGE_FACTORY = new GenericMessageFactory();

    public static IMessage buildMessage(int defaultSeverity, String messageId, JaxbNode targetObject) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, targetObject.getResource());
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, IResource targetObject) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, JaxbNode targetObject) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, parms, targetObject.getResource());
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, IResource targetObject) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, parms, targetObject, DEFAULT_TEXT_RANGE);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, JaxbNode targetObject, TextRange textRange) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, targetObject.getResource(), textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, IResource targetObject, TextRange textRange) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, DEFAULT_PARMS, targetObject, textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, JaxbNode targetObject, TextRange textRange) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, parms, targetObject.getResource(), textRange);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, IResource targetObject, TextRange textRange) {
        return DefaultValidationMessages.buildMessage(defaultSeverity, messageId, parms, targetObject, textRange, MESSAGE_FACTORY);
    }

    public static IMessage buildMessage(int defaultSeverity, String messageId, String[] parms, IResource targetObject, TextRange textRange, MessageFactory messageFactory) {
        IMessage message = messageFactory.buildMessage(defaultSeverity, messageId, parms, targetObject);
        message.setMarkerId("org.eclipse.jpt.jaxb.core.jaxbProblemMarker");
        if (textRange == null) {
            textRange = DEFAULT_TEXT_RANGE;
            JptJaxbCorePlugin.log(new NullPointerException("Null text range for message ID: " + messageId));
        }
        int lineNumber = textRange.getLineNumber();
        message.setLineNo(lineNumber);
        if (lineNumber == 0) {
            message.setAttribute("location", (Object)" ");
        }
        message.setOffset(textRange.getOffset());
        message.setLength(textRange.getLength());
        return message;
    }

    private DefaultValidationMessages() {
        throw new UnsupportedOperationException();
    }

    static class GenericMessageFactory
    implements MessageFactory {
        GenericMessageFactory() {
        }

        public IMessage buildMessage(int severity, String messageId, String[] parms, IResource targetObject) {
            Message message = new Message("jaxb_validation", severity, messageId, parms, (Object)targetObject);
            message.setMarkerId("org.eclipse.jpt.jaxb.core.jaxbProblemMarker");
            return message;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    public static interface MessageFactory {
        public IMessage buildMessage(int var1, String var2, String[] var3, IResource var4);
    }
}

