/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.ddlgen.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.OutputMode;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.ddlgen.wizards.GenerationOutputModeWizardPage;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.DatabaseSchemaWizardPage;

public class GenerateDDLWizard
extends Wizard {
    private JpaProject jpaProject;
    private DatabaseSchemaWizardPage dbSettingsPage;
    private GenerationOutputModeWizardPage generationOutputModePage;

    public GenerateDDLWizard(JpaProject jpaProject) {
        this.jpaProject = jpaProject;
        this.setWindowTitle(JptUiMessages.GenerateDDLWizard_title);
    }

    public void addPages() {
        super.addPages();
        if (this.getJpaProjectConnectionProfile() == null) {
            this.dbSettingsPage = new DatabaseSchemaWizardPage(this.jpaProject);
            this.addPage((IWizardPage)this.dbSettingsPage);
        }
        this.generationOutputModePage = new GenerationOutputModeWizardPage();
        this.addPage((IWizardPage)this.generationOutputModePage);
    }

    public boolean performFinish() {
        return this.getJpaProjectConnectionProfile() != null;
    }

    public boolean canFinish() {
        return this.dbSettingsPageCanFinish() && this.generationOutputModePageCanFinish();
    }

    public OutputMode getOutputMode() {
        return this.generationOutputModePage.getOutputMode();
    }

    private boolean dbSettingsPageCanFinish() {
        return this.dbSettingsPage != null ? this.dbSettingsPage.isPageComplete() : true;
    }

    private boolean generationOutputModePageCanFinish() {
        return this.generationOutputModePage.isPageComplete();
    }

    private ConnectionProfile getJpaProjectConnectionProfile() {
        return this.jpaProject.getConnectionProfile();
    }
}

