/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.caching;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Caching;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.CachingEntity;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.caching.EntityCachingPropertyComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityListComposite<T extends Caching>
extends Pane<T> {
    ModifiablePropertyValueModel<CachingEntity> entityHolder;

    public EntityListComposite(Pane<T> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    protected void initialize() {
        super.initialize();
        this.entityHolder = this.buildEntityHolder();
    }

    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, EclipseLinkUiMessages.CachingEntityListComposite_groupTitle);
        new AddRemoveListPane((Pane)this, container, this.buildEntitiesAdapter(), this.buildEntitiesListHolder(), this.entityHolder, this.buildEntityLabelProvider(), "org.eclipse.jpt.jpa.ui.persistence_caching");
        EntityCachingPropertyComposite pane = new EntityCachingPropertyComposite(this, (PropertyValueModel<CachingEntity>)this.entityHolder, container);
        this.installPaneEnabler(this.entityHolder, pane);
    }

    private AddRemovePane.Adapter buildEntitiesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                EntityListComposite.this.addEntities(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Caching caching = (Caching)EntityListComposite.this.getSubject();
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    CachingEntity entityCaching = (CachingEntity)item;
                    caching.removeEntity(entityCaching.getName());
                    ++n2;
                }
            }
        };
    }

    private void addEntities(ObjectListSelectionModel listSelectionModel) {
        IType type = this.chooseEntity();
        if (type != null) {
            String entityName = this.getEntityName(type.getFullyQualifiedName());
            if (entityName == null) {
                entityName = type.getElementName();
            }
            if (!((Caching)this.getSubject()).entityExists(entityName)) {
                ((Caching)this.getSubject()).addEntity(entityName);
                int index = CollectionTools.indexOf((Iterable)((Caching)this.getSubject()).getEntityNames(), (Object)entityName);
                CachingEntity entity = (CachingEntity)listSelectionModel.getListModel().getElementAt(index);
                listSelectionModel.setSelectedValue((Object)entity);
                this.entityHolder.setValue((Object)entity);
            }
        }
    }

    private String getEntityName(String fullyQualifiedTypeName) {
        Entity entity = ((Caching)this.getSubject()).getPersistenceUnit().getEntity(fullyQualifiedTypeName);
        return entity != null ? entity.getName() : null;
    }

    private IType chooseEntity() {
        SelectionDialog typeSelectionDialog;
        IJavaProject javaProject = this.getJavaProject();
        IJavaElement[] elements = new IJavaElement[]{javaProject};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            JptJpaEclipseLinkUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(EclipseLinkUiMessages.CachingEntityListComposite_dialogTitle);
        typeSelectionDialog.setMessage(EclipseLinkUiMessages.CachingEntityListComposite_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        return ((Caching)this.getSubject()).getJpaProject().getJavaProject();
    }

    private ILabelProvider buildEntityLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                CachingEntity entityCaching = (CachingEntity)element;
                return entityCaching.getName();
            }
        };
    }

    private ModifiablePropertyValueModel<CachingEntity> buildEntityHolder() {
        return new SimplePropertyValueModel();
    }

    private ListValueModel<CachingEntity> buildEntitiesListHolder() {
        return new ListAspectAdapter<Caching, CachingEntity>(this.getSubjectHolder(), new String[]{"entities"}){

            protected ListIterable<CachingEntity> getListIterable() {
                return ((Caching)this.subject).getEntities();
            }

            protected int size_() {
                return ((Caching)this.subject).getEntitiesSize();
            }
        };
    }

    private void installPaneEnabler(ModifiablePropertyValueModel<CachingEntity> entityHolder, EntityCachingPropertyComposite pane) {
        new PaneEnabler(this.buildPaneEnablerHolder(entityHolder), (Pane)pane);
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder(ModifiablePropertyValueModel<CachingEntity> entityHolder) {
        return new TransformationPropertyValueModel<CachingEntity, Boolean>(entityHolder){

            protected Boolean transform_(CachingEntity value) {
                return value.entityNameIsValid();
            }
        };
    }
}

