/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CacheIndex;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.WriteLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Record;

public class IsolatedClientSessionIdentityMapAccessor
extends IdentityMapAccessor {
    protected Map objectsLockedForClone;

    public IsolatedClientSessionIdentityMapAccessor(AbstractSession session) {
        super(session);
    }

    @Override
    public CacheKey acquireDeferredLock(Object primaryKey, Class javaClass, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().acquireDeferredLock(primaryKey, javaClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireDeferredLock(primaryKey, javaClass, descriptor);
    }

    @Override
    public CacheKey acquireLock(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().acquireLock(primaryKey, domainClass, forMerge, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireLock(primaryKey, domainClass, forMerge, descriptor);
    }

    @Override
    public CacheKey acquireLockNoWait(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().acquireLockNoWait(primaryKey, domainClass, forMerge, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, domainClass, forMerge, descriptor);
    }

    @Override
    public CacheKey acquireLockWithWait(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor, int wait) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().acquireLockWithWait(primaryKey, domainClass, forMerge, descriptor, wait);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireLockWithWait(primaryKey, domainClass, forMerge, descriptor, wait);
    }

    @Override
    public CacheKey acquireReadLockOnCacheKey(Object primaryKey, Class domainClass, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().acquireReadLockOnCacheKey(primaryKey, domainClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireReadLockOnCacheKey(primaryKey, domainClass, descriptor);
    }

    @Override
    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey, Class domainClass, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().acquireReadLockOnCacheKeyNoWait(primaryKey, domainClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireReadLockOnCacheKeyNoWait(primaryKey, domainClass, descriptor);
    }

    @Override
    public boolean acquireWriteLock() {
        this.getIdentityMapManager().acquireWriteLock();
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().acquireWriteLock();
    }

    @Override
    public boolean containsObjectInIdentityMap(Object primaryKey, Class theClass, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            if (this.identityMapManager == null) {
                return false;
            }
            return this.getIdentityMapManager().containsKey(primaryKey, theClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, theClass, descriptor);
    }

    @Override
    public Vector getClassesRegistered() {
        Vector results = this.getIdentityMapManager().getClassesRegistered();
        results.addAll(((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getClassesRegistered());
        return results;
    }

    @Override
    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        if (!this.session.getDescriptor(theClass).getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, shouldReturnInvalidatedObjects);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, shouldReturnInvalidatedObjects);
    }

    @Override
    public CacheKey getCacheKeyForObject(Object primaryKey, Class myClass, ClassDescriptor descriptor, boolean forMerge) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            if (this.identityMapManager == null) {
                return null;
            }
            return this.getIdentityMapManager().getCacheKeyForObject(primaryKey, myClass, descriptor, forMerge);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, myClass, descriptor, forMerge);
    }

    @Override
    public CacheKey getCacheKeyForObjectForLock(Object primaryKey, Class myClass, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            if (this.identityMapManager == null) {
                return null;
            }
            return this.getIdentityMapManager().getCacheKeyForObjectForLock(primaryKey, myClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKey, myClass, descriptor);
    }

    @Override
    public Object getFromIdentityMap(Object primaryKey, Object object, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            Object cachedObject = null;
            if (this.identityMapManager != null) {
                cachedObject = this.getIdentityMapManager().getFromIdentityMap(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
            }
            if (descriptor.getCachePolicy().isIsolated()) {
                return cachedObject;
            }
            return this.getAndCloneCacheKeyFromParent(primaryKey, object, theClass, shouldReturnInvalidatedObjects, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, object, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Object getAndCloneCacheKeyFromParent(Object primaryKey, Object objectToClone, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        block29: {
            block30: {
                cacheKey = null;
                if (objectToClone != null && objectToClone instanceof PersistenceEntity) {
                    cacheKey = ((PersistenceEntity)objectToClone)._persistence_getCacheKey();
                }
                if (cacheKey == null || cacheKey.isIsolated() || cacheKey.getOwningMap() == null) {
                    parentIdentityMapAccessor = this.session.getParent().getIdentityMapAccessorInstance();
                    cacheKey = parentIdentityMapAccessor.getCacheKeyForObject(primaryKey, theClass, descriptor, false);
                }
                objectFromCache = null;
                if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
                    var8_8 = cacheKey.getMutex();
                    synchronized (var8_8) {
                        block27: {
                            objectFromCache = cacheKey.getObject();
                            try {
                                while (cacheKey.isAcquired() && objectFromCache == null) {
                                    cacheKey.getMutex().wait(5L);
                                }
                            }
                            catch (InterruptedException v0) {}
                            if (objectFromCache != null) break block27;
                            return null;
                        }
                    }
                }
                return null;
                concreteDescriptor = descriptor;
                if (objectFromCache.getClass() != descriptor.getJavaClass()) {
                    concreteDescriptor = this.session.getDescriptor(objectFromCache);
                }
                builder = concreteDescriptor.getObjectBuilder();
                workingClone = null;
                parentIdentityMapAccessor = this.session.getParent().getIdentityMapAccessorInstance();
                identityMapLocked = parentIdentityMapAccessor.acquireWriteLock();
                rootOfCloneRecursion = false;
                if (identityMapLocked) {
                    this.session.checkAndRefreshInvalidObject(objectFromCache, cacheKey, descriptor);
                } else if (this.objectsLockedForClone == null) {
                    if (concreteDescriptor.shouldAcquireCascadedLocks()) {
                        this.objectsLockedForClone = parentIdentityMapAccessor.getWriteLockManager().acquireLocksForClone(objectFromCache, concreteDescriptor, cacheKey, this.session);
                    } else {
                        this.session.checkAndRefreshInvalidObject(objectFromCache, cacheKey, descriptor);
                        cacheKey.acquireReadLock();
                    }
                    rootOfCloneRecursion = true;
                }
                try {
                    workingClone = builder.instantiateWorkingCopyClone(objectFromCache, this.session);
                    if (workingClone instanceof PersistenceEntity) {
                        ((PersistenceEntity)workingClone)._persistence_setId(cacheKey.getKey());
                    }
                    localCacheKey = this.acquireLock(primaryKey, theClass, descriptor);
                    try {
                        localCacheKey.setObject(workingClone);
                        localCacheKey.setReadTime(cacheKey.getReadTime());
                        localCacheKey.setWriteLockValue(cacheKey.getWriteLockValue());
                        builder.populateAttributesForClone(objectFromCache, cacheKey, workingClone, null, this.session);
                    }
                    finally {
                        localCacheKey.release();
                    }
                    if (concreteDescriptor.hasFetchGroupManager()) {
                        concreteDescriptor.getFetchGroupManager().copyFetchGroupInto(objectFromCache, workingClone, this.session);
                    }
                }
                finally {
                    if (identityMapLocked) {
                        parentIdentityMapAccessor.releaseWriteLock();
                        break block29;
                    }
                    if (!rootOfCloneRecursion) break block29;
                    if (this.objectsLockedForClone == null) {
                        cacheKey.releaseReadLock();
                        break block30;
                    }
                    iterator = this.objectsLockedForClone.values().iterator();
                    if (true) ** GOTO lbl78
                }
                {
                }
                do {
                    ((CacheKey)iterator.next()).releaseReadLock();
lbl78:
                    // 2 sources

                } while (iterator.hasNext());
                this.objectsLockedForClone = null;
            }
            this.session.executeDeferredEvents();
        }
        concreteDescriptor.getObjectBuilder().instantiateEagerMappings(workingClone, this.session);
        return workingClone;
    }

    @Override
    public Object getFromLocalIdentityMap(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return this.getFromIdentityMap(primaryKey, null, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    @Override
    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, shouldReturnInvalidatedObjects, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, shouldReturnInvalidatedObjects, descriptor);
    }

    @Override
    public Object getFromIdentityMapWithDeferredLock(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            if (this.identityMapManager == null) {
                return null;
            }
            return this.getIdentityMapManager().getFromIdentityMapWithDeferredLock(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    @Override
    public IdentityMapManager getIdentityMapManager() {
        if (this.identityMapManager == null) {
            this.identityMapManager = new IdentityMapManager(this.session);
        }
        return this.identityMapManager;
    }

    @Override
    public IdentityMap getIdentityMap(ClassDescriptor descriptor, boolean returnNullIfMissing) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().getIdentityMap(descriptor, returnNullIfMissing);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getIdentityMap(descriptor, returnNullIfMissing);
    }

    @Override
    public Object getQueryResult(ReadQuery query, List parameters, boolean checkExpiry) {
        if (((IsolatedClientSession)this.session).isIsolatedQuery(query)) {
            return this.getIdentityMapManager().getQueryResult(query, parameters, checkExpiry);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getQueryResult(query, parameters, checkExpiry);
    }

    @Override
    public AbstractSession getSession() {
        return this.session;
    }

    @Override
    public Object getWrapper(Object primaryKey, Class theClass) {
        if (!this.session.getDescriptor(theClass).getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().getWrapper(primaryKey, theClass);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWrapper(primaryKey, theClass);
    }

    @Override
    public WriteLockManager getWriteLockManager() {
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWriteLockManager();
    }

    @Override
    public Object getWriteLockValue(Object primaryKey, Class theClass, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().getWriteLockValue(primaryKey, theClass, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, theClass, descriptor);
    }

    @Override
    public void initializeAllIdentityMaps() {
        super.initializeAllIdentityMaps();
        ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().initializeAllIdentityMaps();
    }

    @Override
    public void initializeIdentityMap(Class theClass) {
        this.getSession().log(2, "cache", "initialize_identitymap", theClass);
        if (!this.session.getDescriptor(theClass).getCachePolicy().isSharedIsolation()) {
            this.getIdentityMapManager().initializeIdentityMap(theClass);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().initializeIdentityMap(theClass);
        }
    }

    @Override
    public void initializeIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
        this.getSession().getCommitManager().reinitialize();
    }

    @Override
    public void putQueryResult(ReadQuery query, List parameters, Object results) {
        if (((IsolatedClientSession)this.session).isIsolatedQuery(query)) {
            this.getIdentityMapManager().putQueryResult(query, parameters, results);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().putQueryResult(query, parameters, results);
        }
    }

    @Override
    public void putCacheKeyByIndex(CacheIndex index, CacheId indexValues, CacheKey cacheKey, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            this.getIdentityMapManager().putCacheKeyByIndex(index, indexValues, cacheKey, descriptor);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().putCacheKeyByIndex(index, indexValues, cacheKey, descriptor);
        }
    }

    @Override
    public CacheKey getCacheKeyByIndex(CacheIndex index, CacheId indexValues, boolean shouldCheckExpiry, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().getCacheKeyByIndex(index, indexValues, shouldCheckExpiry, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().getCacheKeyByIndex(index, indexValues, shouldCheckExpiry, descriptor);
    }

    @Override
    public void printIdentityMap(Class businessClass) {
        if (this.getSession().shouldLog(7, "cache")) {
            if (!this.session.getDescriptor(businessClass).getCachePolicy().isSharedIsolation()) {
                this.getIdentityMapManager().printIdentityMap(businessClass);
            } else {
                ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMap(businessClass);
            }
        }
    }

    @Override
    public void printIdentityMaps() {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMaps();
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMaps();
        }
    }

    @Override
    public void printIdentityMapLocks() {
        if (this.getSession().shouldLog(1, "cache")) {
            this.getIdentityMapManager().printLocks();
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().printIdentityMapLocks();
        }
    }

    @Override
    public CacheKey internalPutInIdentityMap(Object domainObject, Object key, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        if (!descriptor.getCachePolicy().isSharedIsolation()) {
            return this.getIdentityMapManager().putInIdentityMap(domainObject, key, writeLockValue, readTime, descriptor);
        }
        return ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().internalPutInIdentityMap(domainObject, key, writeLockValue, readTime, descriptor);
    }

    @Override
    public void invalidateObjects(Expression selectionCriteria, Class theClass, Record translationRow, boolean shouldInvalidateOnException) {
        if (!this.session.getDescriptor(theClass).getCachePolicy().isSharedIsolation()) {
            this.getIdentityMapManager().invalidateObjects(selectionCriteria, theClass, translationRow, shouldInvalidateOnException);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().invalidateObjects(selectionCriteria, theClass, translationRow, shouldInvalidateOnException);
        }
    }

    @Override
    public void releaseWriteLock() {
        ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().releaseWriteLock();
        this.getIdentityMapManager().releaseWriteLock();
    }

    @Override
    public Object removeFromIdentityMap(Object key, Class theClass, ClassDescriptor descriptor, Object object) {
        Object removedObject = null;
        if (descriptor.isIsolated() || descriptor.isProtectedIsolation()) {
            removedObject = this.getIdentityMapManager().removeFromIdentityMap(key, theClass, descriptor, object);
        }
        if (!descriptor.isIsolated()) {
            removedObject = ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().removeFromIdentityMap(key, theClass, descriptor, object);
        }
        return removedObject;
    }

    @Override
    public void setIdentityMapManager(IdentityMapManager identityMapManager) {
        this.identityMapManager = identityMapManager;
    }

    @Override
    public void setWrapper(Object primaryKey, Class theClass, Object wrapper) {
        if (!this.getSession().getDescriptor(theClass).getCachePolicy().isSharedIsolation()) {
            this.getIdentityMapManager().setWrapper(primaryKey, theClass, wrapper);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().setWrapper(primaryKey, theClass, wrapper);
        }
    }

    @Override
    public void updateWriteLockValue(Object primaryKey, Class theClass, Object writeLockValue) {
        if (!this.getSession().getDescriptor(theClass).getCachePolicy().isSharedIsolation()) {
            this.getIdentityMapManager().setWriteLockValue(primaryKey, theClass, writeLockValue);
        } else {
            ((IsolatedClientSession)this.session).getParent().getIdentityMapAccessorInstance().updateWriteLockValue(primaryKey, theClass, writeLockValue);
        }
    }
}

