/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.internal.details.AddQueryStateObject;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddQueryDialog
extends ValidatingDialog<AddQueryStateObject> {
    public static final String NAMED_QUERY = "namedQuery";
    public static final String NAMED_NATIVE_QUERY = "namedNativeQuery";
    private PersistenceUnit pUnit;

    public AddQueryDialog(Shell parent, PersistenceUnit pUnit) {
        super(parent);
        this.pUnit = pUnit;
    }

    protected AddQueryStateObject buildStateObject() {
        return new AddQueryStateObject(this.pUnit);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return JptUiDetailsMessages.AddQueryDialog_title;
    }

    protected String getDescriptionTitle() {
        return JptUiDetailsMessages.AddQueryDialog_descriptionTitle;
    }

    protected String getDescription() {
        return JptUiDetailsMessages.AddQueryDialog_description;
    }

    protected DialogPane<AddQueryStateObject> buildLayout(Composite container) {
        return new QueryDialogPane(container);
    }

    public void create() {
        super.create();
        QueryDialogPane pane = (QueryDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    public String getName() {
        return ((AddQueryStateObject)this.getSubject()).getName();
    }

    public String getQueryType() {
        return ((AddQueryStateObject)this.getSubject()).getQueryType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryDialogPane
    extends DialogPane<AddQueryStateObject> {
        private Text nameText;

        QueryDialogPane(Composite parent) {
            super(AddQueryDialog.this.getSubjectHolder(), parent);
        }

        protected void initializeLayout(Composite container) {
            this.nameText = this.addLabeledText(container, JptUiDetailsMessages.AddQueryDialog_name, this.buildNameHolder());
            this.addLabeledCombo(container, JptUiDetailsMessages.AddQueryDialog_queryType, this.buildQueryTypeListHolder(), this.buildQueryTypeHolder(), this.buildStringConverter(), null);
        }

        protected ListValueModel<String> buildQueryTypeListHolder() {
            ArrayList<String> queryTypes = new ArrayList<String>();
            queryTypes.add(AddQueryDialog.NAMED_QUERY);
            queryTypes.add(AddQueryDialog.NAMED_NATIVE_QUERY);
            return new StaticListValueModel(queryTypes);
        }

        private StringConverter<String> buildStringConverter() {
            return new StringConverter<String>(){

                public String convertToString(String value) {
                    if (value == AddQueryDialog.NAMED_QUERY) {
                        return JptUiDetailsMessages.AddQueryDialog_namedQuery;
                    }
                    if (value == AddQueryDialog.NAMED_NATIVE_QUERY) {
                        return JptUiDetailsMessages.AddQueryDialog_namedNativeQuery;
                    }
                    return value;
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildNameHolder() {
            return new PropertyAspectAdapter<AddQueryStateObject, String>(this.getSubjectHolder(), new String[]{"nameProperty"}){

                protected String buildValue_() {
                    return ((AddQueryStateObject)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((AddQueryStateObject)((Object)this.subject)).setName(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildQueryTypeHolder() {
            return new PropertyAspectAdapter<AddQueryStateObject, String>(this.getSubjectHolder(), new String[]{"queryTypeProperty"}){

                protected String buildValue_() {
                    return ((AddQueryStateObject)((Object)this.subject)).getQueryType();
                }

                protected void setValue_(String value) {
                    ((AddQueryStateObject)((Object)this.subject)).setQueryType(value);
                }
            };
        }

        void selectAll() {
            this.nameText.selectAll();
        }
    }
}

