/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporalTypeComposite
extends Pane<BaseTemporalConverter> {
    public TemporalTypeComposite(PropertyValueModel<? extends BaseTemporalConverter> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void initializeLayout(Composite container) {
        this.addCombo(container, this.buildTemporalTypeListHolder(), this.buildTemporalTypeHolder(), this.buildTemporalTypeConverter(), this.buildBooleanHolder());
    }

    private ModifiablePropertyValueModel<TemporalType> buildTemporalTypeHolder() {
        return new PropertyAspectAdapter<BaseTemporalConverter, TemporalType>(this.getSubjectHolder(), new String[]{"temporalType"}){

            protected TemporalType buildValue_() {
                return ((BaseTemporalConverter)this.subject).getTemporalType();
            }

            protected void setValue_(TemporalType value) {
                ((BaseTemporalConverter)this.subject).setTemporalType(value);
            }
        };
    }

    private ListValueModel<TemporalType> buildTemporalTypeListHolder() {
        return new SimpleListValueModel(this.buildSortedTemporalTypeList());
    }

    private List<TemporalType> buildSortedTemporalTypeList() {
        return CollectionTools.sort((List)CollectionTools.list((Object[])TemporalType.values()), this.buildTemporalTypeComparator());
    }

    private Comparator<TemporalType> buildTemporalTypeComparator() {
        return new Comparator<TemporalType>(){

            @Override
            public int compare(TemporalType type1, TemporalType type2) {
                String displayString1 = TemporalTypeComposite.this.displayString(type1);
                String displayString2 = TemporalTypeComposite.this.displayString(type2);
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    private StringConverter<TemporalType> buildTemporalTypeConverter() {
        return new StringConverter<TemporalType>(){

            public String convertToString(TemporalType value) {
                return value == null ? null : TemporalTypeComposite.this.displayString(value);
            }
        };
    }

    String displayString(TemporalType temporalType) {
        switch (temporalType) {
            case DATE: {
                return JptUiDetailsMessages.TemporalTypeComposite_date;
            }
            case TIME: {
                return JptUiDetailsMessages.TemporalTypeComposite_time;
            }
            case TIMESTAMP: {
                return JptUiDetailsMessages.TemporalTypeComposite_timestamp;
            }
        }
        throw new IllegalStateException();
    }

    protected PropertyValueModel<Boolean> buildBooleanHolder() {
        return new TransformationPropertyValueModel<BaseTemporalConverter, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(BaseTemporalConverter value) {
                if (TemporalTypeComposite.this.getSubject() != null && ((BaseTemporalConverter)TemporalTypeComposite.this.getSubject()).getParent().getPersistentAttribute().isVirtual()) {
                    return Boolean.FALSE;
                }
                return value != null;
            }
        };
    }
}

