/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.PersistentAttributeTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractAccessor;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.PersistentPropertyValidator;

public class PropertyAccessor
extends AbstractAccessor {
    private final JavaResourceMethod resourceGetter;
    private final JavaResourceMethod resourceSetter;

    public PropertyAccessor(ReadOnlyPersistentAttribute parent, JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        super(parent);
        this.resourceGetter = resourceGetter;
        this.resourceSetter = resourceSetter;
    }

    public JavaResourceAttribute getResourceAttribute() {
        return this.resourceGetter != null ? this.resourceGetter : this.resourceSetter;
    }

    public boolean isFor(JavaResourceField resourceField) {
        return false;
    }

    public boolean isFor(JavaResourceMethod getterMethod, JavaResourceMethod setterMethod) {
        return this.resourceGetter == getterMethod && this.resourceSetter == setterMethod;
    }

    public AccessType getDefaultAccess() {
        return AccessType.PROPERTY;
    }

    public JavaResourceMethod getResourceGetter() {
        return this.resourceGetter;
    }

    public JavaResourceMethod getResourceSetter() {
        return this.resourceSetter;
    }

    public JavaPersistentAttribute buildUnannotatedJavaAttribute(PersistentType parent) {
        return this.buildJavaAttribute(parent, this.buildUnannotatedJavaResourceGetter(), this.buildUnannotatedJavaResourceSetter());
    }

    protected JavaResourceMethod buildUnannotatedJavaResourceGetter() {
        return new UnannotatedJavaResourceMethod(this.getResourceGetter());
    }

    protected JavaResourceMethod buildUnannotatedJavaResourceSetter() {
        return new UnannotatedJavaResourceMethod(this.getResourceSetter());
    }

    protected JavaPersistentAttribute buildJavaAttribute(PersistentType parent, JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return this.getJpaFactory().buildJavaPersistentProperty(parent, resourceGetter, resourceSetter);
    }

    public JptValidator buildAttributeValidator(PersistentAttribute persistentAttribute, PersistentAttributeTextRangeResolver textRangeResolver) {
        return new PersistentPropertyValidator(persistentAttribute, this, textRangeResolver);
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getResourceAttribute().getNameTextRange(astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UnannotatedJavaResourceMethod
    extends AbstractAccessor.UnannotatedJavaResourceAttribute<JavaResourceMethod>
    implements JavaResourceMethod {
        protected UnannotatedJavaResourceMethod(JavaResourceMethod method) {
            super((AbstractAccessor)PropertyAccessor.this, (JavaResourceAttribute)method);
        }

        public JavaResourceAnnotatedElement.Kind getKind() {
            return JavaResourceAnnotatedElement.Kind.METHOD;
        }

        public String getMethodName() {
            return ((JavaResourceMethod)this.member).getMethodName();
        }

        public ListIterable<String> getParameterTypeNames() {
            return ((JavaResourceMethod)this.member).getParameterTypeNames();
        }

        public String getParameterTypeName(int index) {
            return ((JavaResourceMethod)this.member).getParameterTypeName(index);
        }

        public int getParametersSize() {
            return ((JavaResourceMethod)this.member).getParametersSize();
        }

        public boolean isConstructor() {
            return ((JavaResourceMethod)this.member).isConstructor();
        }

        public boolean isFor(MethodSignature methodSignature, int occurrence) {
            return ((JavaResourceMethod)this.member).isFor(methodSignature, occurrence);
        }

        public void synchronizeWith(MethodDeclaration methodDeclaration) {
        }

        public void initialize(MethodDeclaration methodDeclaration) {
        }
    }
}

