/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.BodySourceWriter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ChainIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.java.PropertyAccessor;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelSourceType;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaPersistentType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmPersistentType2_0;
import org.eclipse.jpt.jpa.core.resource.orm.Attributes;
import org.eclipse.jpt.jpa.core.resource.orm.OrmPackage;
import org.eclipse.jpt.jpa.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.jpa.core.resource.xml.EmfTools;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpecifiedOrmPersistentType
extends AbstractOrmXmlContextNode
implements OrmPersistentType2_0 {
    protected OrmTypeMapping mapping;
    protected String name;
    protected JavaPersistentType javaPersistentType;
    protected AccessType specifiedAccess;
    protected AccessType defaultAccess;
    protected final Vector<OrmPersistentAttribute> specifiedAttributes = new Vector();
    protected final SpecifiedAttributeContainerAdapter specifiedAttributeContainerAdapter = new SpecifiedAttributeContainerAdapter();
    protected final Vector<OrmReadOnlyPersistentAttribute> defaultAttributes = new Vector();
    protected PersistentType superPersistentType;
    protected String declaringTypeName;
    protected final MetamodelSourceType.Synchronizer metamodelSynchronizer;
    protected static final Comparator<OrmPersistentAttribute> ATTRIBUTE_COMPARATOR = new Comparator<OrmPersistentAttribute>(){

        @Override
        public int compare(OrmPersistentAttribute attribute1, OrmPersistentAttribute attribute2) {
            int seq2;
            int seq1 = attribute1.getMapping().getXmlSequence();
            return seq1 == (seq2 = attribute2.getMapping().getXmlSequence()) ? 0 : (seq1 < seq2 ? -1 : 1);
        }
    };

    protected SpecifiedOrmPersistentType(EntityMappings parent, XmlTypeMapping xmlTypeMapping) {
        super(parent);
        this.mapping = this.buildMapping(xmlTypeMapping);
        this.name = this.getMappingClassName();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.defaultAccess = AccessType.FIELD;
        this.initializeSpecifiedAttributes();
        this.metamodelSynchronizer = this.buildMetamodelSynchronizer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.mapping.synchronizeWithResourceModel();
        this.syncJavaPersistentType();
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.syncSpecifiedAttributes();
        this.synchronizeNodesWithResourceModel((Iterable<? extends JpaContextNode>)this.getDefaultAttributes());
    }

    @Override
    public void update() {
        super.update();
        this.mapping.update();
        this.setName(this.buildName());
        this.updateJavaPersistentType();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedAttributes());
        this.updateDefaultAttributes();
        this.setSuperPersistentType(this.buildSuperPersistentType());
        this.setDeclaringTypeName(this.buildDeclaringTypeName());
    }

    @Override
    public OrmTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public void setMappingKey(String mappingKey) {
        if (this.valuesAreDifferent(this.getMappingKey(), mappingKey)) {
            this.setMappingKey_(mappingKey);
        }
    }

    protected void setMappingKey_(String mappingKey) {
        OrmTypeMapping old = this.mapping;
        OrmTypeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getTypeMappingDefinition(mappingKey);
        XmlTypeMapping xmlTypeMapping = mappingDefinition.buildResourceMapping(this.getResourceNodeFactory());
        this.mapping = this.buildMapping(xmlTypeMapping);
        this.getEntityMappings().changeMapping(this, old, this.mapping);
        this.firePropertyChanged("mapping", old, this.mapping);
    }

    protected OrmTypeMapping buildMapping(XmlTypeMapping xmlTypeMapping) {
        OrmTypeMappingDefinition md = this.getMappingFileDefinition().getTypeMappingDefinition(xmlTypeMapping.getMappingKey());
        return md.buildContextMapping(this, xmlTypeMapping, this.getContextNodeFactory());
    }

    protected XmlTypeMapping getXmlTypeMapping() {
        return this.mapping.getXmlTypeMapping();
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        String old = this.name;
        this.name = name;
        if (this.firePropertyChanged("name", old, name) && this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
            this.setJavaPersistentType(null);
        }
    }

    protected String buildName() {
        return this.getEntityMappings().getFullyQualifiedName(this.getMappingClassName());
    }

    @Override
    public String getSimpleName() {
        String className = this.getName();
        return StringTools.stringIsEmpty((String)className) ? null : ClassName.getSimpleName((String)className);
    }

    protected String getMappingClassName() {
        return this.mapping.getClass_();
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType javaPersistentType) {
        JavaPersistentType old = this.javaPersistentType;
        this.javaPersistentType = javaPersistentType;
        this.firePropertyChanged("javaPersistentType", old, javaPersistentType);
    }

    protected void syncJavaPersistentType() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.synchronizeWithResourceModel();
        }
    }

    protected void updateJavaPersistentType() {
        if (this.getName() == null) {
            if (this.javaPersistentType != null) {
                this.javaPersistentType.dispose();
                this.setJavaPersistentType(null);
            }
        } else {
            JavaResourceType resourceType = this.resolveJavaResourceType();
            if (this.javaPersistentType == null) {
                this.setJavaPersistentType(this.buildJavaPersistentType(resourceType));
            } else if (this.javaPersistentType.getJavaResourceType() == resourceType) {
                this.javaPersistentType.update();
            } else {
                this.javaPersistentType.dispose();
                this.setJavaPersistentType(this.buildJavaPersistentType(resourceType));
            }
        }
    }

    protected JavaResourceType resolveJavaResourceType() {
        if (this.name == null) {
            return null;
        }
        return (JavaResourceType)this.getJpaProject().getJavaResourceType(this.name, JavaResourceAnnotatedElement.Kind.TYPE);
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourceType jrt) {
        return jrt != null ? this.getJpaFactory().buildJavaPersistentType(this, jrt) : null;
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType access) {
        this.setSpecifiedAccess_(access);
        this.getXmlTypeMapping().setAccess(AccessType.toOrmResourceModel(access));
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", old, access);
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromOrmResourceModel(this.getXmlTypeMapping().getAccess(), this.getJpaPlatform(), this.getResourceType());
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    protected AccessType buildDefaultAccess() {
        AccessType access;
        if (!this.mapping.isMetadataComplete()) {
            if (this.javaPersistentType != null && this.javaPersistentTypeHasSpecifiedAccess()) {
                return this.javaPersistentType.getAccess();
            }
            if (this.superPersistentType != null) {
                return this.superPersistentType.getAccess();
            }
        }
        return (access = this.getMappingFileRoot().getAccess()) != null ? access : AccessType.FIELD;
    }

    protected boolean javaPersistentTypeHasSpecifiedAccess() {
        return this.javaPersistentType.getSpecifiedAccess() != null || this.javaPersistentType.hasAnyAnnotatedAttributes();
    }

    @Override
    public AccessType getOwnerOverrideAccess() {
        return this.getEntityMappings().getOverridePersistentTypeAccess();
    }

    @Override
    public AccessType getOwnerDefaultAccess() {
        return this.getEntityMappings().getDefaultPersistentTypeAccess();
    }

    @Override
    public ListIterable<OrmReadOnlyPersistentAttribute> getAttributes() {
        return new CompositeListIterable(new ListIterable[]{this.getReadOnlySpecifiedAttributes(), this.getDefaultAttributes()});
    }

    @Override
    public int getAttributesSize() {
        return this.getSpecifiedAttributesSize() + this.getDefaultAttributesSize();
    }

    @Override
    public Iterable<String> getAttributeNames() {
        return this.convertToNames((Iterable<? extends ReadOnlyPersistentAttribute>)this.getAttributes());
    }

    @Override
    public OrmReadOnlyPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<OrmReadOnlyPersistentAttribute> stream = this.getAttributesNamed(attributeName).iterator();
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public Iterable<ReadOnlyPersistentAttribute> getAllAttributes() {
        return new CompositeIterable((Iterable)new TransformationIterable<PersistentType, Iterable<ReadOnlyPersistentAttribute>>(this.getInheritanceHierarchy()){

            protected Iterable<ReadOnlyPersistentAttribute> transform(PersistentType pt) {
                return new SuperListIterableWrapper(pt.getAttributes());
            }
        });
    }

    @Override
    public Iterable<String> getAllAttributeNames() {
        return this.convertToNames(this.getAllAttributes());
    }

    protected Iterable<OrmReadOnlyPersistentAttribute> getAttributesNamed(final String attributeName) {
        return new FilteringIterable<OrmReadOnlyPersistentAttribute>(this.getAttributes()){

            protected boolean accept(OrmReadOnlyPersistentAttribute attribute) {
                return Tools.valuesAreEqual((Object)attributeName, (Object)attribute.getName());
            }
        };
    }

    @Override
    public ReadOnlyPersistentAttribute resolveAttribute(String attributeName) {
        Iterator<OrmReadOnlyPersistentAttribute> attributes = this.getAttributesNamed(attributeName).iterator();
        if (attributes.hasNext()) {
            OrmReadOnlyPersistentAttribute attribute = attributes.next();
            return attributes.hasNext() ? null : attribute;
        }
        return this.superPersistentType == null ? null : this.superPersistentType.resolveAttribute(attributeName);
    }

    protected Iterable<String> convertToNames(Iterable<? extends ReadOnlyPersistentAttribute> attributes) {
        return new TransformationIterable<ReadOnlyPersistentAttribute, String>(attributes){

            protected String transform(ReadOnlyPersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public OrmPersistentAttribute addAttributeToXml(OrmReadOnlyPersistentAttribute defaultAttribute) {
        return this.addAttributeToXml(defaultAttribute, defaultAttribute.getMappingKey());
    }

    @Override
    public OrmPersistentAttribute addAttributeToXml(OrmReadOnlyPersistentAttribute defaultAttribute, String mappingKey) {
        if (!defaultAttribute.isVirtual()) {
            throw new IllegalArgumentException("Attribute is already specified: " + defaultAttribute);
        }
        if (mappingKey == null) {
            throw new IllegalArgumentException("Use convertAttributeToSpecified(OrmReadOnlyPersistentAttribute, String) instead and specify a mapping key");
        }
        return this.convertAttributeToSpecified_(defaultAttribute, mappingKey);
    }

    protected OrmPersistentAttribute convertAttributeToSpecified_(OrmReadOnlyPersistentAttribute defaultAttribute, String mappingKey) {
        int defaultIndex = this.defaultAttributes.indexOf(defaultAttribute);
        this.defaultAttributes.remove(defaultIndex);
        defaultAttribute.dispose();
        OrmAttributeMappingDefinition md = this.getMappingFileDefinition().getAttributeMappingDefinition(mappingKey);
        XmlAttributeMapping xmlMapping = md.buildResourceMapping(this.getResourceNodeFactory());
        OrmPersistentAttribute specifiedAttribute = this.buildSpecifiedAttribute(xmlMapping);
        int specifiedIndex = this.getSpecifiedAttributeInsertionIndex(specifiedAttribute);
        this.specifiedAttributes.add(specifiedIndex, specifiedAttribute);
        specifiedAttribute.getMapping().setName(defaultAttribute.getName());
        this.fireItemRemoved("defaultAttributes", defaultIndex, defaultAttribute);
        this.fireItemAdded("specifiedAttributes", specifiedIndex, specifiedAttribute);
        Attributes xmlAttributes = this.getXmlAttributesForUpdate();
        specifiedAttribute.getMapping().addXmlAttributeMappingTo(xmlAttributes);
        this.getXmlTypeMapping().setAttributes(xmlAttributes);
        AccessType oldAccess = defaultAttribute.getJavaPersistentAttribute().getSpecifiedAccess();
        if (oldAccess != null) {
            specifiedAttribute.setSpecifiedAccess(oldAccess);
        }
        return specifiedAttribute;
    }

    protected int getSpecifiedAttributeInsertionIndex(OrmPersistentAttribute attribute) {
        return CollectionTools.insertionIndexOf(this.specifiedAttributes, (Object)attribute, this.getAttributeComparator());
    }

    protected Comparator<OrmPersistentAttribute> getAttributeComparator() {
        return ATTRIBUTE_COMPARATOR;
    }

    @Override
    public OrmReadOnlyPersistentAttribute removeAttributeFromXml(OrmPersistentAttribute specifiedAttribute) {
        if (specifiedAttribute.isVirtual()) {
            throw new IllegalArgumentException("Attribute is not specified: " + specifiedAttribute);
        }
        int defaultIndex = this.defaultAttributes.size();
        OrmReadOnlyPersistentAttribute defaultAttribute = null;
        if (specifiedAttribute.getJavaResourceAttribute() != null) {
            if (specifiedAttribute.getJavaResourceAttribute().getKind() == JavaResourceAnnotatedElement.Kind.FIELD) {
                JavaResourceField javaResourceField = (JavaResourceField)specifiedAttribute.getJavaResourceAttribute();
                if (this.javaResourceFieldWillBeDefault(javaResourceField, specifiedAttribute)) {
                    defaultAttribute = this.buildDefaultAttribute(javaResourceField);
                    this.defaultAttributes.add(defaultIndex, defaultAttribute);
                }
            } else {
                JavaResourceMethod resourceSetter;
                PropertyAccessor propertyAccessor = (PropertyAccessor)specifiedAttribute.getJavaPersistentAttribute().getAccessor();
                JavaResourceMethod resourceGetter = propertyAccessor.getResourceGetter();
                if (this.javaResourcePropertyWillBeDefault(resourceGetter, resourceSetter = propertyAccessor.getResourceSetter(), specifiedAttribute)) {
                    defaultAttribute = this.buildVirtualAttribute(resourceGetter, resourceSetter);
                    this.defaultAttributes.add(defaultIndex, defaultAttribute);
                }
            }
        }
        this.removeSpecifiedAttribute(specifiedAttribute);
        if (defaultAttribute != null) {
            this.fireItemAdded("defaultAttributes", defaultIndex, defaultAttribute);
        }
        return defaultAttribute;
    }

    protected boolean javaResourceFieldWillBeDefault(JavaResourceField javaResourceField, OrmPersistentAttribute specifiedAttributeToBeRemoved) {
        return CollectionTools.contains(this.getJavaResourceFields(), (Object)javaResourceField) && this.getSpecifiedAttributeFor(javaResourceField, specifiedAttributeToBeRemoved) == null;
    }

    protected boolean javaResourcePropertyWillBeDefault(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter, OrmPersistentAttribute specifiedAttributeToBeRemoved) {
        return CollectionTools.contains(this.getJavaResourceMethods(), (Object)javaResourceGetter) && CollectionTools.contains(this.getJavaResourceMethods(), (Object)javaResourceSetter) && this.getSpecifiedAttributeFor(javaResourceGetter, javaResourceSetter, specifiedAttributeToBeRemoved) == null;
    }

    protected Attributes getXmlAttributes() {
        return this.getXmlTypeMapping().getAttributes();
    }

    protected Attributes getXmlAttributesForUpdate() {
        Attributes xmlAttributes = this.getXmlAttributes();
        return xmlAttributes != null ? xmlAttributes : this.buildXmlAttributes();
    }

    protected Attributes buildXmlAttributes() {
        return EmfTools.create(this.getResourceNodeFactory(), OrmPackage.eINSTANCE.getAttributes(), Attributes.class);
    }

    protected void removeXmlAttributesIfUnset() {
        if (this.getXmlAttributes().isUnset()) {
            this.getXmlTypeMapping().setAttributes(null);
        }
    }

    @Override
    public ListIterable<OrmPersistentAttribute> getSpecifiedAttributes() {
        return new LiveCloneListIterable(this.specifiedAttributes);
    }

    protected ListIterable<OrmReadOnlyPersistentAttribute> getReadOnlySpecifiedAttributes() {
        return new SuperListIterableWrapper(this.getSpecifiedAttributes());
    }

    @Override
    public int getSpecifiedAttributesSize() {
        return this.specifiedAttributes.size();
    }

    protected void removeSpecifiedAttribute(OrmPersistentAttribute attribute) {
        this.removeSpecifiedAttribute_(attribute);
        attribute.getMapping().removeXmlAttributeMappingFrom(this.getXmlAttributes());
        this.removeXmlAttributesIfUnset();
    }

    @Override
    public void changeMapping(OrmPersistentAttribute attribute, OrmAttributeMapping oldMapping, OrmAttributeMapping newMapping) {
        int sourceIndex = this.specifiedAttributes.indexOf(attribute);
        this.specifiedAttributes.remove(sourceIndex);
        oldMapping.removeXmlAttributeMappingFrom(this.getXmlAttributes());
        int targetIndex = this.getSpecifiedAttributeInsertionIndex(attribute);
        this.specifiedAttributes.add(targetIndex, attribute);
        newMapping.addXmlAttributeMappingTo(this.getXmlAttributes());
        oldMapping.initializeOn(newMapping);
        this.fireItemMoved("specifiedAttributes", targetIndex, sourceIndex);
    }

    protected void initializeSpecifiedAttributes() {
        for (XmlAttributeMapping xmlMapping : this.getXmlAttributeMappings()) {
            this.specifiedAttributes.add(this.buildSpecifiedAttribute(xmlMapping));
        }
    }

    protected Iterable<XmlAttributeMapping> getXmlAttributeMappings() {
        Attributes xmlAttributes = this.getXmlAttributes();
        return xmlAttributes != null ? xmlAttributes.getAttributeMappings() : EmptyIterable.instance();
    }

    protected OrmPersistentAttribute buildSpecifiedAttribute(XmlAttributeMapping xmlMapping) {
        return this.getContextNodeFactory().buildOrmPersistentAttribute(this, xmlMapping);
    }

    protected void syncSpecifiedAttributes() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedAttributeContainerAdapter);
    }

    protected void moveSpecifiedAttribute_(int index, OrmPersistentAttribute attribute) {
        this.moveItemInList(index, attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    protected void addSpecifiedAttribute_(int index, XmlAttributeMapping xmlMapping) {
        OrmPersistentAttribute attribute = this.buildSpecifiedAttribute(xmlMapping);
        this.addItemToList(index, attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    protected void removeSpecifiedAttribute_(OrmPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.specifiedAttributes, "specifiedAttributes");
    }

    @Override
    public ListIterable<OrmReadOnlyPersistentAttribute> getDefaultAttributes() {
        return new LiveCloneListIterable(this.defaultAttributes);
    }

    @Override
    public int getDefaultAttributesSize() {
        return this.defaultAttributes.size();
    }

    protected void updateDefaultAttributes() {
        if (this.getDefaultJavaAccess() == AccessType.FIELD) {
            this.syncFieldAccessDefaultAttributes();
        } else if (this.getDefaultJavaAccess() == AccessType.PROPERTY) {
            this.syncPropertyAccessDefaultAttributes();
        }
    }

    private void syncFieldAccessDefaultAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getDefaultAttributes());
        this.syncFieldDefaultAttributes(contextAttributes, SpecifiedOrmPersistentType.buildNonTransientNonStaticResourceFieldsFilter());
        if (!this.getMapping().isMetadataComplete()) {
            this.syncAnnotatedPropertyDefaultAttributes(contextAttributes);
        }
        for (OrmReadOnlyPersistentAttribute contextAttribute : contextAttributes) {
            this.removeDefaultAttribute(contextAttribute);
        }
    }

    private void syncPropertyAccessDefaultAttributes() {
        HashSet contextAttributes = CollectionTools.set(this.getDefaultAttributes());
        if (!this.getMapping().isMetadataComplete()) {
            this.syncFieldDefaultAttributes(contextAttributes, AbstractJavaPersistentType.ANNOTATED_RESOURCE_FIELDS_FILTER);
        }
        HashBag resourceMethods = CollectionTools.collection(this.getJavaResourceMethods());
        for (JavaResourceMethod getterMethod : this.getJavaResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod;
            if (this.javaResourcePropertyIsDefault(getterMethod, setterMethod = AbstractJavaPersistentType.getValidSiblingSetMethod(getterMethod, (Iterable<JavaResourceMethod>)resourceMethods)) && AbstractJavaPersistentType.methodsArePersistableProperties(getterMethod, setterMethod)) {
                boolean match = false;
                Iterator stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    OrmReadOnlyPersistentAttribute contextAttribute = (OrmReadOnlyPersistentAttribute)stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addDefaultAttribute(this.getDefaultAttributesSize(), this.buildVirtualAttribute(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceDefaultMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
        for (OrmReadOnlyPersistentAttribute contextAttribute : contextAttributes) {
            this.removeDefaultAttribute(contextAttribute);
        }
    }

    private void syncAnnotatedPropertyDefaultAttributes(HashSet<OrmReadOnlyPersistentAttribute> contextAttributes) {
        HashBag resourceMethods = CollectionTools.collection(this.getJavaResourceMethods());
        for (JavaResourceMethod getterMethod : this.getJavaResourceMethods(this.buildPersistablePropertyGetterMethodsFilter())) {
            JavaResourceMethod setterMethod;
            if (this.javaResourcePropertyIsDefault(getterMethod, setterMethod = AbstractJavaPersistentType.getValidSiblingSetMethod(getterMethod, (Iterable<JavaResourceMethod>)resourceMethods)) && (getterMethod.isAnnotated() || setterMethod != null && setterMethod.isAnnotated())) {
                boolean match = false;
                Iterator<OrmReadOnlyPersistentAttribute> stream = contextAttributes.iterator();
                while (stream.hasNext()) {
                    OrmReadOnlyPersistentAttribute contextAttribute = stream.next();
                    if (!contextAttribute.isFor(getterMethod, setterMethod)) continue;
                    match = true;
                    contextAttribute.update();
                    stream.remove();
                    break;
                }
                if (!match) {
                    this.addDefaultAttribute(this.getDefaultAttributesSize(), this.buildVirtualAttribute(getterMethod, setterMethod));
                }
            }
            resourceMethods.remove(getterMethod);
            resourceMethods.remove(setterMethod);
        }
        this.syncRemainingResourceDefaultMethods(contextAttributes, (Collection<JavaResourceMethod>)resourceMethods);
    }

    private void syncFieldDefaultAttributes(HashSet<OrmReadOnlyPersistentAttribute> contextAttributes, Filter<JavaResourceField> filter) {
        for (JavaResourceField resourceField : this.getDefaultJavaResourceFields(filter)) {
            boolean match = false;
            Iterator<OrmReadOnlyPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                OrmReadOnlyPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(resourceField)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addDefaultAttribute(this.getDefaultAttributesSize(), this.buildDefaultAttribute(resourceField));
        }
    }

    private void syncRemainingResourceDefaultMethods(HashSet<OrmReadOnlyPersistentAttribute> contextAttributes, Collection<JavaResourceMethod> resourceMethods) {
        for (JavaResourceMethod resourceMethod : resourceMethods) {
            if (!resourceMethod.isAnnotated()) continue;
            boolean match = false;
            Iterator<OrmReadOnlyPersistentAttribute> stream = contextAttributes.iterator();
            while (stream.hasNext()) {
                OrmReadOnlyPersistentAttribute contextAttribute = stream.next();
                if (!contextAttribute.isFor(null, resourceMethod)) continue;
                match = true;
                contextAttribute.update();
                stream.remove();
                break;
            }
            if (match) continue;
            this.addDefaultAttribute(this.getDefaultAttributesSize(), this.buildVirtualAttribute(null, resourceMethod));
        }
    }

    protected Iterable<JavaResourceField> getDefaultJavaResourceFields() {
        return new FilteringIterable<JavaResourceField>(this.getJavaResourceFields()){

            protected boolean accept(JavaResourceField javaResourceField) {
                return SpecifiedOrmPersistentType.this.javaResourceFieldIsDefault(javaResourceField);
            }
        };
    }

    protected Iterable<JavaResourceField> getJavaResourceFields() {
        JavaResourceType javaResourceType = this.getJavaResourceType();
        if (javaResourceType == null) {
            return EmptyListIterable.instance();
        }
        return javaResourceType.getFields();
    }

    protected Iterable<JavaResourceField> getDefaultJavaResourceFields(Filter<JavaResourceField> filter) {
        return new FilteringIterable(this.getDefaultJavaResourceFields(), filter);
    }

    protected Iterable<JavaResourceMethod> getJavaResourceMethods(Filter<JavaResourceMethod> filter) {
        return new FilteringIterable(this.getJavaResourceMethods(), filter);
    }

    protected Iterable<JavaResourceMethod> getJavaResourceMethods() {
        JavaResourceType javaResourceType = this.getJavaResourceType();
        if (javaResourceType == null) {
            return EmptyListIterable.instance();
        }
        return javaResourceType.getMethods();
    }

    public static Filter<JavaResourceField> buildNonTransientNonStaticResourceFieldsFilter() {
        return AbstractJavaPersistentType.buildNonTransientNonStaticResourceFieldsFilter();
    }

    protected Filter<JavaResourceMethod> buildPersistablePropertyGetterMethodsFilter() {
        return new Filter<JavaResourceMethod>(){

            public boolean accept(JavaResourceMethod resourceMethod) {
                return AbstractJavaPersistentType.methodIsPersistablePropertyGetter(resourceMethod, SpecifiedOrmPersistentType.this.getJavaResourceMethods());
            }
        };
    }

    protected JavaResourceType getJavaResourceType() {
        return this.javaPersistentType == null ? null : this.javaPersistentType.getJavaResourceType();
    }

    protected AccessType getDefaultJavaAccess() {
        if (this.specifiedAccess != null) {
            return this.specifiedAccess;
        }
        if (this.mapping.isMetadataComplete()) {
            return this.defaultAccess;
        }
        AccessType javaAccess = this.javaPersistentType == null ? null : this.javaPersistentType.getSpecifiedAccess();
        return javaAccess != null ? javaAccess : this.defaultAccess;
    }

    protected boolean javaResourceFieldIsDefault(JavaResourceField javaResourceField) {
        return this.getSpecifiedAttributeFor(javaResourceField) == null;
    }

    protected OrmPersistentAttribute getSpecifiedAttributeFor(JavaResourceField javaResourceField) {
        return this.getSpecifiedAttributeFor(javaResourceField, null);
    }

    protected OrmPersistentAttribute getSpecifiedAttributeFor(JavaResourceField javaResourceField, OrmPersistentAttribute exclude) {
        for (OrmPersistentAttribute ormAttribute : this.getSpecifiedAttributes()) {
            if (ormAttribute == exclude || !ormAttribute.isFor(javaResourceField)) continue;
            return ormAttribute;
        }
        return null;
    }

    protected boolean javaResourcePropertyIsDefault(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter) {
        return this.getSpecifiedAttributeFor(javaResourceGetter, javaResourceSetter) == null;
    }

    protected OrmPersistentAttribute getSpecifiedAttributeFor(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter) {
        return this.getSpecifiedAttributeFor(javaResourceGetter, javaResourceSetter, null);
    }

    protected OrmPersistentAttribute getSpecifiedAttributeFor(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter, OrmPersistentAttribute exclude) {
        for (OrmPersistentAttribute ormAttribute : this.getSpecifiedAttributes()) {
            if (ormAttribute == exclude || !ormAttribute.isFor(javaResourceGetter, javaResourceSetter)) continue;
            return ormAttribute;
        }
        return null;
    }

    protected void moveDefaultAttribute(int index, OrmReadOnlyPersistentAttribute defaultAttribute) {
        this.moveItemInList(index, defaultAttribute, this.defaultAttributes, "defaultAttributes");
    }

    protected void addDefaultAttribute(int index, OrmReadOnlyPersistentAttribute defaultAttribute) {
        this.addItemToList(index, defaultAttribute, this.defaultAttributes, "defaultAttributes");
    }

    protected OrmReadOnlyPersistentAttribute buildDefaultAttribute(JavaResourceField javaResourceField) {
        return this.getContextNodeFactory().buildVirtualOrmPersistentField(this, javaResourceField);
    }

    protected OrmReadOnlyPersistentAttribute buildVirtualAttribute(JavaResourceMethod javaResourceGetter, JavaResourceMethod javaResourceSetter) {
        return this.getContextNodeFactory().buildVirtualOrmPersistentProperty(this, javaResourceGetter, javaResourceSetter);
    }

    protected void removeDefaultAttribute(OrmReadOnlyPersistentAttribute defaultAttribute) {
        defaultAttribute.dispose();
        this.removeItemFromList(defaultAttribute, this.defaultAttributes, "defaultAttributes");
    }

    @Override
    public PersistentType getSuperPersistentType() {
        return this.superPersistentType;
    }

    protected void setSuperPersistentType(PersistentType persistentType) {
        PersistentType old = this.superPersistentType;
        this.superPersistentType = persistentType;
        this.firePropertyChanged("superPersistentType", old, persistentType);
    }

    protected PersistentType buildSuperPersistentType() {
        PersistentType spt = this.buildSuperPersistentType_();
        if (spt == null) {
            return null;
        }
        return CollectionTools.contains(spt.getInheritanceHierarchy(), (Object)this) ? null : spt;
    }

    protected PersistentType buildSuperPersistentType_() {
        return this.javaPersistentType == null ? null : this.javaPersistentType.getSuperPersistentType();
    }

    @Override
    public Iterable<PersistentType> getInheritanceHierarchy() {
        return this.getInheritanceHierarchyOf(this);
    }

    @Override
    public Iterable<PersistentType> getAncestors() {
        return this.getInheritanceHierarchyOf(this.superPersistentType);
    }

    protected Iterable<PersistentType> getInheritanceHierarchyOf(PersistentType start) {
        return new ChainIterable<PersistentType>(start){

            protected PersistentType nextLink(PersistentType persistentType) {
                return persistentType.getSuperPersistentType();
            }
        };
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    protected void setDeclaringTypeName(String name) {
        String old = this.declaringTypeName;
        this.declaringTypeName = name;
        this.firePropertyChanged("declaringTypeName", old, name);
    }

    protected String buildDeclaringTypeName() {
        return this.isJpa2_0Compatible() ? this.buildDeclaringTypeName_() : null;
    }

    protected String buildDeclaringTypeName_() {
        return this.javaPersistentType == null ? null : ((JavaPersistentType2_0)this.javaPersistentType).getDeclaringTypeName();
    }

    protected MetamodelSourceType.Synchronizer buildMetamodelSynchronizer() {
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildMetamodelSynchronizer(this) : null;
    }

    @Override
    public IFile getMetamodelFile() {
        return this.javaPersistentType == null ? null : this.metamodelSynchronizer.getFile();
    }

    public void initializeMetamodel() {
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public void synchronizeMetamodel(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        if (this.javaPersistentType != null) {
            this.metamodelSynchronizer.synchronize(memberTypeTree);
        }
    }

    @Override
    public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        if (this.javaPersistentType != null) {
            this.metamodelSynchronizer.printBodySourceOn(pw, memberTypeTree);
        }
    }

    public void disposeMetamodel() {
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    public Class<OrmPersistentType> getType() {
        return OrmPersistentType.class;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentAttribute attribute : this.getSpecifiedAttributes()) {
            if (!attribute.contains(textOffset)) continue;
            return attribute;
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.mapping.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
        }
        for (OrmReadOnlyPersistentAttribute defaultAttribute : this.getDefaultAttributes()) {
            defaultAttribute.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        AccessType accessType;
        if (this.specifiedAccess != null) {
            return this.specifiedAccess;
        }
        if (this.superPersistentType instanceof OrmPersistentType && (accessType = ((OrmPersistentType)this.superPersistentType).getSpecifiedAccess()) != null) {
            return accessType;
        }
        if (this.mapping.isMetadataComplete() && (accessType = this.getOwnerDefaultAccess()) != null) {
            return accessType;
        }
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        AccessType accessType;
        if (this.superPersistentType instanceof OrmPersistentType && (accessType = ((OrmPersistentType)this.superPersistentType).getDefaultAccess()) != null) {
            return accessType;
        }
        return this.getOwnerDefaultAccess();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(IType type) {
        return this.isFor(type.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.mapping.createDeleteEdit()) : EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{this.mapping.createRenameTypeEdits(originalType, newName), this.createSpecifiedAttributesRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedAttributesRenameTypeEdits(final IType originalType, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentAttribute, Iterable<ReplaceEdit>>(this.getSpecifiedAttributes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentAttribute persistentAttribute) {
                return persistentAttribute.createRenameTypeEdits(originalType, newName);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{this.mapping.createMoveTypeEdits(originalType, newPackage), this.createSpecifiedAttributesMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedAttributesMoveTypeEdits(final IType originalType, final IPackageFragment newPackage) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentAttribute, Iterable<ReplaceEdit>>(this.getSpecifiedAttributes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentAttribute persistentAttribute) {
                return persistentAttribute.createMoveTypeEdits(originalType, newPackage);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{this.mapping.createRenamePackageEdits(originalPackage, newName), this.createSpecifiedAttributesRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedAttributesRenamePackageEdits(final IPackageFragment originalPackage, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<OrmPersistentAttribute, Iterable<ReplaceEdit>>(this.getSpecifiedAttributes()){

            protected Iterable<ReplaceEdit> transform(OrmPersistentAttribute persistentAttribute) {
                return persistentAttribute.createRenamePackageEdits(originalPackage, newName);
            }
        });
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages);
        this.validateMapping(messages, reporter);
        this.validateAttributes(messages, reporter);
    }

    protected void validateClass(List<IMessage> messages) {
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNRESOLVED_CLASS", new String[]{this.getName()}, this, this.mapping.getClassTextRange()));
        }
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter) {
        try {
            this.mapping.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter) {
        for (OrmReadOnlyPersistentAttribute attribute : this.getAttributes()) {
            this.validateAttribute(attribute, messages, reporter);
        }
    }

    protected void validateAttribute(OrmReadOnlyPersistentAttribute attribute, List<IMessage> messages, IReporter reporter) {
        try {
            attribute.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptJpaCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.mapping.getValidationTextRange();
    }

    @Override
    public Iterable<String> getXmlCompletionProposals(int pos) {
        Iterable result = super.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.mapping.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmPersistentAttribute attribute : this.getSpecifiedAttributes()) {
            result = attribute.getXmlCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public EntityMappings getParent() {
        return (EntityMappings)super.getParent();
    }

    protected EntityMappings getEntityMappings() {
        return this.getParent();
    }

    @Override
    public String getDefaultPackage() {
        return this.getEntityMappings().getDefaultPersistentTypePackage();
    }

    @Override
    public boolean isFor(String typeName) {
        return Tools.valuesAreEqual((Object)typeName, (Object)this.getName());
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        String packageName = this.getPackageName();
        return Tools.valuesAreEqual((Object)packageName, (Object)packageFragment.getElementName());
    }

    protected String getPackageName() {
        String className = this.getMappingClassName();
        if (className == null) {
            return null;
        }
        int lastPeriod = className.lastIndexOf(46);
        return lastPeriod == -1 ? this.getDefaultPackage() : className.substring(0, lastPeriod);
    }

    @Override
    public boolean contains(int textOffset) {
        return this.mapping.containsOffset(textOffset);
    }

    @Override
    public PersistentType getOverriddenPersistentType() {
        return this.mapping.isMetadataComplete() ? null : this.javaPersistentType;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedAttributeContainerAdapter
    implements ContextContainerTools.Adapter<OrmPersistentAttribute, XmlAttributeMapping> {
        protected SpecifiedAttributeContainerAdapter() {
        }

        @Override
        public Iterable<OrmPersistentAttribute> getContextElements() {
            return SpecifiedOrmPersistentType.this.getSpecifiedAttributes();
        }

        @Override
        public Iterable<XmlAttributeMapping> getResourceElements() {
            return SpecifiedOrmPersistentType.this.getXmlAttributeMappings();
        }

        @Override
        public XmlAttributeMapping getResourceElement(OrmPersistentAttribute contextElement) {
            return contextElement.getMapping().getXmlAttributeMapping();
        }

        @Override
        public void moveContextElement(int index, OrmPersistentAttribute element) {
            SpecifiedOrmPersistentType.this.moveSpecifiedAttribute_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlAttributeMapping resourceElement) {
            SpecifiedOrmPersistentType.this.addSpecifiedAttribute_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmPersistentAttribute element) {
            SpecifiedOrmPersistentType.this.removeSpecifiedAttribute_(element);
        }
    }
}

