/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1;

import org.eclipse.jpt.jpa.core.JpaDataSource;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.db.ConnectionAdapter;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.ConnectionProfileListener;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.DatabaseIdentifierAdapter;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaDataSource
extends AbstractJpaNode
implements JpaDataSource {
    protected String connectionProfileName;
    protected transient ConnectionProfile connectionProfile;
    protected final ConnectionProfileListener connectionProfileListener;
    protected final ConnectionListener connectionListener;

    public GenericJpaDataSource(JpaProject jpaProject, String connectionProfileName) {
        super(jpaProject);
        this.connectionProfileName = connectionProfileName;
        this.connectionProfile = this.buildConnectionProfile(connectionProfileName);
        this.connectionProfileListener = this.buildConnectionProfileListener();
        this.getConnectionProfileFactory().addConnectionProfileListener(this.connectionProfileListener);
        this.connectionListener = this.buildConnectionListener();
        if (this.connectionProfile != null) {
            this.connectionProfile.addConnectionListener(this.connectionListener);
        }
    }

    protected ConnectionProfileFactory getConnectionProfileFactory() {
        return this.getJpaPlatform().getConnectionProfileFactory();
    }

    protected ConnectionProfileListener buildConnectionProfileListener() {
        return new LocalConnectionProfileListener();
    }

    protected ConnectionListener buildConnectionListener() {
        return new LocalConnectionListener();
    }

    @Override
    public String getConnectionProfileName() {
        return this.connectionProfileName;
    }

    @Override
    public void setConnectionProfileName(String name) {
        String old = this.connectionProfileName;
        this.connectionProfileName = name;
        if (this.firePropertyChanged("connectionProfileName", old, name)) {
            this.setConnectionProfile(this.buildConnectionProfile(name));
            JptJpaCorePlugin.setConnectionProfileName(this.getJpaProject().getProject(), name);
        }
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    @Override
    public boolean connectionProfileIsActive() {
        ConnectionProfile cp = this.connectionProfile;
        return cp != null && cp.isActive();
    }

    @Override
    public Database getDatabase() {
        ConnectionProfile cp = this.connectionProfile;
        return cp == null ? null : cp.getDatabase();
    }

    @Override
    public Table selectTableForIdentifier(Iterable<Table> tables, String identifier) {
        Database db = this.getDatabase();
        return db == null ? null : db.selectTableForIdentifier(tables, identifier);
    }

    @Override
    public void dispose() {
        if (this.connectionProfile != null) {
            this.connectionProfile.removeConnectionListener(this.connectionListener);
        }
        this.getConnectionProfileFactory().removeConnectionProfileListener(this.connectionProfileListener);
    }

    protected ConnectionProfile buildConnectionProfile(String name) {
        return this.getConnectionProfileFactory().buildConnectionProfile(name, this.buildDatabaseIdentifierAdapter());
    }

    protected DatabaseIdentifierAdapter buildDatabaseIdentifierAdapter() {
        return this.isJpa2_0Compatible() ? this.getJpaFactory2_0().buildDatabaseIdentifierAdapter(this) : DatabaseIdentifierAdapter.Default.instance();
    }

    protected void setConnectionProfile(ConnectionProfile connectionProfile) {
        ConnectionProfile old = this.connectionProfile;
        if (old != null) {
            old.removeConnectionListener(this.connectionListener);
        }
        this.connectionProfile = connectionProfile;
        if (connectionProfile != null) {
            connectionProfile.addConnectionListener(this.connectionListener);
        }
        this.firePropertyChanged("connectionProfile", old, connectionProfile);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.connectionProfileName);
    }

    protected class LocalConnectionListener
    extends ConnectionAdapter {
        protected LocalConnectionListener() {
        }

        public void opened(ConnectionProfile profile) {
            GenericJpaDataSource.this.stateChanged();
        }

        public void closed(ConnectionProfile profile) {
            GenericJpaDataSource.this.stateChanged();
        }
    }

    protected class LocalConnectionProfileListener
    implements ConnectionProfileListener {
        protected LocalConnectionProfileListener() {
        }

        public void connectionProfileAdded(String name) {
            if (GenericJpaDataSource.this.connectionProfile == null && name.equals(GenericJpaDataSource.this.getConnectionProfileName())) {
                GenericJpaDataSource.this.setConnectionProfileName(name);
            }
        }

        public void connectionProfileRemoved(String name) {
            if (GenericJpaDataSource.this.connectionProfile == null) {
                return;
            }
            if (name.equals(GenericJpaDataSource.this.connectionProfile.getName())) {
                GenericJpaDataSource.this.setConnectionProfile(null);
            }
        }

        public void connectionProfileRenamed(String oldName, String newName) {
            if (GenericJpaDataSource.this.connectionProfile == null) {
                if (newName.equals(GenericJpaDataSource.this.connectionProfileName)) {
                    GenericJpaDataSource.this.setConnectionProfileName(newName);
                }
                return;
            }
            if (newName.equals(GenericJpaDataSource.this.connectionProfile.getName())) {
                GenericJpaDataSource.this.setConnectionProfileName(newName);
            }
        }
    }
}

