/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.MappingFileRoot;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.MetamodelSynchronizer;
import org.eclipse.jpt.jpa.core.jpa2.context.JpaRootContextNode2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceXml2_0;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRootContextNode
extends AbstractJpaContextNode
implements JpaRootContextNode2_0 {
    protected final JpaProject jpaProject;
    protected PersistenceXml persistenceXml;

    public GenericRootContextNode(JpaProject jpaProject) {
        super(null);
        if (jpaProject == null) {
            throw new NullPointerException();
        }
        this.jpaProject = jpaProject;
        this.persistenceXml = this.buildPersistenceXml();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncPersistenceXml();
    }

    @Override
    public void update() {
        super.update();
        this.updatePersistenceXml();
    }

    @Override
    public PersistenceXml getPersistenceXml() {
        return this.persistenceXml;
    }

    protected void setPersistenceXml(PersistenceXml persistenceXml) {
        PersistenceXml old = this.persistenceXml;
        this.persistenceXml = persistenceXml;
        this.firePropertyChanged("persistenceXml", old, persistenceXml);
    }

    protected PersistenceXml buildPersistenceXml() {
        JpaXmlResource xmlResource = this.resolvePersistenceXmlResource();
        return xmlResource == null ? null : this.buildPersistenceXml(xmlResource);
    }

    protected void syncPersistenceXml() {
        this.syncPersistenceXml(true);
    }

    protected void syncPersistenceXml(boolean sync) {
        JpaXmlResource xmlResource = this.resolvePersistenceXmlResource();
        if (xmlResource == null) {
            if (this.persistenceXml != null) {
                this.persistenceXml.dispose();
                this.setPersistenceXml(null);
            }
        } else if (this.persistenceXml == null) {
            this.setPersistenceXml(this.buildPersistenceXml(xmlResource));
        } else if (sync) {
            this.persistenceXml.synchronizeWithResourceModel();
        } else {
            this.persistenceXml.update();
        }
    }

    protected JpaXmlResource resolvePersistenceXmlResource() {
        JpaXmlResource xmlResource = this.jpaProject.getPersistenceXmlResource();
        if (xmlResource == null) {
            return null;
        }
        if (xmlResource.isReverting()) {
            return null;
        }
        JptResourceType resourceType = xmlResource.getResourceType();
        if (resourceType == null) {
            return null;
        }
        if (!this.getJpaPlatform().supportsResourceType(resourceType)) {
            return null;
        }
        return xmlResource;
    }

    protected PersistenceXml buildPersistenceXml(JpaXmlResource xmlResource) {
        return this.getJpaFactory().buildPersistenceXml(this, xmlResource);
    }

    protected void updatePersistenceXml() {
        this.syncPersistenceXml(false);
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public void stateChanged() {
        super.stateChanged();
        this.jpaProject.stateChanged();
    }

    @Override
    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected IProject getProject() {
        return this.jpaProject.getProject();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return null;
    }

    @Override
    public MappingFileRoot getMappingFileRoot() {
        return null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.jpaProject.getName());
    }

    @Override
    public void initializeMetamodel() {
        if (this.persistenceXml != null) {
            ((PersistenceXml2_0)this.persistenceXml).initializeMetamodel();
        }
    }

    @Override
    public IStatus synchronizeMetamodel(IProgressMonitor monitor) {
        return this.persistenceXml != null ? ((PersistenceXml2_0)this.persistenceXml).synchronizeMetamodel(monitor) : Status.OK_STATUS;
    }

    @Override
    public void disposeMetamodel() {
        if (this.persistenceXml != null) {
            ((PersistenceXml2_0)this.persistenceXml).disposeMetamodel();
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        if (this.persistenceXml == null) {
            messages.add(this.buildPersistenceXmlValidationMessage());
            return;
        }
        if (!this.jpaProject.discoversAnnotatedClasses()) {
            this.validateOrphanClasses(messages);
        }
        this.persistenceXml.validate(messages, reporter);
    }

    protected IMessage buildPersistenceXmlValidationMessage() {
        int severity = 1;
        IFile file = this.getPlatformFile();
        if (file != null && file.exists()) {
            JpaXmlResource xmlResource = this.jpaProject.getPersistenceXmlResource();
            if (xmlResource != null && !this.getJpaPlatform().supportsResourceType(xmlResource.getResourceType())) {
                return DefaultJpaValidationMessages.buildMessage(severity, "PERSISTENCE_XML_UNSUPPORTED_CONTENT", (IResource)file);
            }
            return DefaultJpaValidationMessages.buildMessage(severity, "PERSISTENCE_XML_INVALID_CONTENT", (IResource)file);
        }
        return DefaultJpaValidationMessages.buildMessage(severity, "PROJECT_NO_PERSISTENCE_XML", this);
    }

    protected IFile getPlatformFile() {
        return this.jpaProject.getPlatformFile(JptJpaCorePlugin.DEFAULT_PERSISTENCE_XML_RUNTIME_PATH);
    }

    protected void validateOrphanClasses(List<IMessage> messages) {
        Persistence persistence = this.persistenceXml.getPersistence();
        if (persistence == null) {
            return;
        }
        if (persistence.getPersistenceUnitsSize() != 1) {
            return;
        }
        PersistenceUnit persistenceUnit = (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
        HashBag annotatedClassNames = CollectionTools.bag(this.jpaProject.getAnnotatedJavaSourceClassNames());
        HashBag orphans = annotatedClassNames.clone();
        for (String annotatedClassName : annotatedClassNames) {
            if (persistenceUnit.specifiesPersistentType(annotatedClassName)) {
                orphans.remove((Object)annotatedClassName);
                continue;
            }
            if (!MetamodelSynchronizer.MetamodelTools.isMetamodel(this.getJpaProject().getJavaResourceType(annotatedClassName))) continue;
            orphans.remove((Object)annotatedClassName);
        }
        Iterable<String> typeMappingAnnotationNames = this.jpaProject.getTypeMappingAnnotationNames();
        for (String orphan : orphans) {
            JavaResourceAbstractType jrt = this.jpaProject.getJavaResourceType(orphan);
            JavaResourceCompilationUnit jrcu = jrt.getJavaResourceCompilationUnit();
            if (jrt.isAnnotatedWithAnyOf(typeMappingAnnotationNames)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_MAPPED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT", new String[]{jrt.getQualifiedName()}, (IResource)jrt.getFile(), jrt.getNameTextRange(jrcu.buildASTRoot())));
                continue;
            }
            messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENT_TYPE_ANNOTATED_BUT_NOT_INCLUDED_IN_PERSISTENCE_UNIT", new String[]{jrt.getName()}, (IResource)jrt.getFile(), jrt.getNameTextRange(jrcu.buildASTRoot())));
        }
    }
}

