/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SequenceGeneratorAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceSequenceGeneratorAnnotation
extends SourceGeneratorAnnotation
implements SequenceGeneratorAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.SequenceGenerator");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceSequenceGeneratorAnnotation.buildAdapter("name");
    private static final DeclarationAnnotationElementAdapter<Integer> INITIAL_VALUE_ADAPTER = SourceSequenceGeneratorAnnotation.buildIntegerAdapter("initialValue");
    private static final DeclarationAnnotationElementAdapter<Integer> ALLOCATION_SIZE_ADAPTER = SourceSequenceGeneratorAnnotation.buildIntegerAdapter("allocationSize");
    private static final DeclarationAnnotationElementAdapter<String> SEQUENCE_NAME_ADAPTER = SourceSequenceGeneratorAnnotation.buildAdapter("sequenceName");
    private final AnnotationElementAdapter<String> sequenceNameAdapter = this.buildAdapter(SEQUENCE_NAME_ADAPTER);
    private String sequenceName;
    private TextRange sequenceNameTextRange;

    protected SourceSequenceGeneratorAnnotation(JavaResourceNode parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.SequenceGenerator";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.sequenceName = this.buildSequenceName(astRoot);
        this.sequenceNameTextRange = this.buildSequenceNameTextRange(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncSequenceName(this.buildSequenceName(astRoot));
        this.sequenceNameTextRange = this.buildSequenceNameTextRange(astRoot);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.sequenceName == null;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getNameAdapter() {
        return NAME_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter() {
        return INITIAL_VALUE_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter() {
        return ALLOCATION_SIZE_ADAPTER;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    @Override
    public void setSequenceName(String sequenceName) {
        if (this.attributeValueHasChanged(this.sequenceName, sequenceName)) {
            this.sequenceName = sequenceName;
            this.sequenceNameAdapter.setValue((Object)sequenceName);
        }
    }

    public void syncSequenceName(String astSequenceName) {
        String old = this.sequenceName;
        this.sequenceName = astSequenceName;
        this.firePropertyChanged("sequenceName", old, astSequenceName);
    }

    private String buildSequenceName(CompilationUnit astRoot) {
        return (String)this.sequenceNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getSequenceNameTextRange() {
        return this.sequenceNameTextRange;
    }

    private TextRange buildSequenceNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(SEQUENCE_NAME_ADAPTER, astRoot);
    }

    @Override
    public boolean sequenceNameTouches(int pos) {
        return this.textRangeTouches(this.sequenceNameTextRange, pos);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SourceSequenceGeneratorAnnotation.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    protected static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(String elementName) {
        return SourceSequenceGeneratorAnnotation.buildIntegerAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }
}

