/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Collection;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.GraphicalRemoveAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class UpdateAttributeFeature
extends AbstractCustomFeature {
    public UpdateAttributeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void reconnect(JavaPersistentType jpt) {
        IJPAEditorFeatureProvider fp = this.getFeatureProvider();
        Collection<IRelation> rels = JpaArtifactFactory.instance().produceAllRelations(jpt, fp);
        JpaArtifactFactory.instance().refreshEntityModel(fp, jpt);
        for (IRelation rel : rels) {
            AddRelationFeature relF = new AddRelationFeature(fp);
            AnchorContainer acSource = (AnchorContainer)fp.getPictogramElementForBusinessObject(rel.getOwner());
            AnchorContainer acTarget = (AnchorContainer)fp.getPictogramElementForBusinessObject(rel.getInverse());
            if (acSource == null || acTarget == null) continue;
            AddConnectionContext ctx = new AddConnectionContext((Anchor)acSource.getAnchors().iterator().next(), (Anchor)acTarget.getAnchors().iterator().next());
            ctx.setNewObject((Object)rel);
            relF.add((IAddContext)ctx);
        }
    }

    public void execute(ICustomContext context) {
        GraphicalRemoveAttributeFeature remove = new GraphicalRemoveAttributeFeature(this.getFeatureProvider());
        remove.execute(context);
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public static Text addText(IFeatureProvider fp, Rectangle textRectangle, String txt) {
        Diagram diagram = fp.getDiagramTypeProvider().getDiagram();
        Text text = Graphiti.getGaService().createText(diagram, (GraphicsAlgorithmContainer)textRectangle, txt, "Arial", 8, false, true);
        Color color = Graphiti.getGaService().manageColor(diagram, JPAEditorConstants.ENTITY_TEXT_FOREGROUND);
        text.setForeground(color);
        text.setHorizontalAlignment(Orientation.ALIGNMENT_LEFT);
        text.setVerticalAlignment(Orientation.ALIGNMENT_TOP);
        return text;
    }

    public static Rectangle addRectangleForText(ContainerShape cs, int attribIndex, int width) {
        Rectangle rect = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)cs);
        rect.setFilled(Boolean.valueOf(false));
        rect.setLineVisible(Boolean.valueOf(false));
        rect.setHeight(30);
        rect.setWidth(width - 21);
        rect.setX(21);
        rect.setY(15 + attribIndex * 20);
        return rect;
    }

    public static Rectangle addRectangleForIcon(ContainerShape cs, int attribIndex) {
        Rectangle rect = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)cs);
        rect.setFilled(Boolean.valueOf(false));
        rect.setLineVisible(Boolean.valueOf(false));
        rect.setHeight(20);
        rect.setX(0);
        rect.setWidth(20);
        rect.setY(15 + attribIndex * 20);
        return rect;
    }

    public void addSeparatorsToShape(ContainerShape compartmentShape, JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot) {
        this.addSeparatorToCollection(compartmentShape, 0, dot);
        this.addSeparatorToCollection(compartmentShape, 13, dot);
    }

    private Shape addSeparatorToCollection(ContainerShape containerShape, int y, JPAEditorConstants.DIAGRAM_OBJECT_TYPE dot) {
        int width = containerShape.getGraphicsAlgorithm().getWidth();
        Shape shape = Graphiti.getPeService().createShape(containerShape, false);
        Rectangle rectangle = Graphiti.getGaService().createRectangle((GraphicsAlgorithmContainer)shape);
        IColorConstant foreground = JpaArtifactFactory.instance().getForeground(dot);
        IColorConstant background = JpaArtifactFactory.instance().getBackground(dot);
        rectangle.setForeground(this.manageColor(background));
        rectangle.setBackground(this.manageColor(foreground));
        rectangle.setLineVisible(Boolean.valueOf(false));
        Graphiti.getGaService().setSize((GraphicsAlgorithm)rectangle, width, 2);
        Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)rectangle, 0, y, width, 2);
        return shape;
    }
}

