/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IUnidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToManyRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class OneToManyUniDirRelation
extends OneToManyRelation
implements IUnidirectionalRelation {
    public OneToManyUniDirRelation(IJPAEditorFeatureProvider fp, JavaPersistentType owner, JavaPersistentType inverse, String ownerAttributeName, boolean createAttribs, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        if (createAttribs) {
            this.createRelation(fp, ownerCU, inverseCU);
        }
    }

    @Override
    public JavaPersistentAttribute getAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    @Override
    public void setAnnotatedAttribute(JavaPersistentAttribute annotatedAttribute) {
        this.ownerAnnotatedAttribute = annotatedAttribute;
    }

    private void createRelation(IJPAEditorFeatureProvider fp, ICompilationUnit ownerCU, ICompilationUnit inverseCU) {
        boolean isMap = JPADiagramPropertyPage.isMapType(this.owner.getJpaProject().getProject());
        String mapKeyType = this.getMapKeyType(isMap, this.inverse);
        this.ownerAnnotatedAttribute = JPAEditorUtil.addAnnotatedAttribute(fp, this.owner, this.inverse, ownerCU, inverseCU, true, mapKeyType);
        JpaArtifactFactory.instance().addOneToManyUnidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute, isMap);
    }

    @Override
    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.UNI;
    }

    private String getMapKeyType(boolean isMap, JavaPersistentType jpt) {
        return isMap ? JpaArtifactFactory.instance().getIdType(jpt) : null;
    }
}

