/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java;

import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Bag;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.java.JavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.AbstractJaxbNode;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElementsMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlElementsMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.java.ELXmlPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlElement;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlElementWrapper;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlPath;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.validation.ELJaxbValidationMessageBuilder;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlPathAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELJavaXmlElementsMapping
extends GenericJavaXmlElementsMapping
implements ELXmlElementsMapping {
    protected final AbstractJaxbNode.ContextListContainer<ELJavaXmlPath, XmlPathAnnotation> xmlPathContainer = this.buildXmlPathContainer();

    public ELJavaXmlElementsMapping(JaxbPersistentAttribute parent) {
        super(parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlPathContainer.synchronizeWithResourceModel();
    }

    public void update() {
        super.update();
        this.xmlPathContainer.update();
    }

    @Override
    public ListIterable<ELXmlPath> getXmlPaths() {
        return new SuperListIterableWrapper(this.xmlPathContainer.getContextElements());
    }

    @Override
    public int getXmlPathsSize() {
        return this.xmlPathContainer.getContextElementsSize();
    }

    @Override
    public ELXmlPath addXmlPath(int index) {
        XmlPathAnnotation annotation = (XmlPathAnnotation)this.getJavaResourceAttribute().addAnnotation(index, "org.eclipse.persistence.oxm.annotations.XmlPath");
        return (ELXmlPath)this.xmlPathContainer.addContextElement(index, (Object)annotation);
    }

    @Override
    public void removeXmlPath(int index) {
        this.getJavaResourceAttribute().removeAnnotation(index, "org.eclipse.persistence.oxm.annotations.XmlPath");
        this.xmlPathContainer.removeContextElement(index);
    }

    @Override
    public void moveXmlPath(int targetIndex, int sourceIndex) {
        this.getJavaResourceAttribute().moveAnnotation(targetIndex, sourceIndex, "org.eclipse.persistence.oxm.annotations.XmlPath");
        this.xmlPathContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected ELJavaXmlPath buildXmlPath(XmlPathAnnotation xmlPathAnnotation) {
        return new ELJavaXmlPath((JavaContextNode)this, new XmlPathContext(xmlPathAnnotation));
    }

    protected AbstractJaxbNode.ContextListContainer<ELJavaXmlPath, XmlPathAnnotation> buildXmlPathContainer() {
        XmlPathContainer container = new XmlPathContainer();
        container.initialize();
        return container;
    }

    protected ListIterable<XmlPathAnnotation> getXmlPathAnnotations() {
        return new SubListIterableWrapper(this.getJavaResourceAttribute().getAnnotations("org.eclipse.persistence.oxm.annotations.XmlPath"));
    }

    protected XmlElement buildXmlElement(XmlElementAnnotation xmlElementAnnotation) {
        return new ELJavaXmlElement((JavaContextNode)this, new XmlElementContext(xmlElementAnnotation));
    }

    protected XmlElementWrapper buildXmlElementWrapper() {
        return new ELJavaXmlElementWrapper((JaxbAttributeMapping)this, new XmlElementWrapperContext());
    }

    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty((Iterable)result)) {
            return result;
        }
        for (ELJavaXmlPath xmlPath : this.xmlPathContainer.getContextElements()) {
            result = xmlPath.getJavaCompletionProposals(pos, filter, astRoot);
            if (CollectionTools.isEmpty(result)) continue;
            return result;
        }
        return EmptyIterable.instance();
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.getXmlPathsSize() > 0) {
            this.validateXmlPaths(messages, reporter, astRoot);
        }
    }

    protected void validateXmlPaths(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        ListIterator xmlElements = this.getXmlElements().iterator();
        ListIterator xmlPaths = this.xmlPathContainer.getContextElements().iterator();
        while (xmlElements.hasNext() && xmlPaths.hasNext()) {
            xmlElements.next();
            xmlPaths.next();
        }
        if (xmlElements.hasNext()) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_PATH__INSUFFICIENT_XML_PATHS_FOR_XML_ELEMENTS", (JaxbNode)this, this.getXmlPathsTextRange(astRoot)));
        }
        while (xmlPaths.hasNext()) {
            ELJavaXmlPath xmlPath = (ELJavaXmlPath)xmlPaths.next();
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XML_PATH__INSUFFICIENT_XML_ELEMENTS_FOR_XML_PATHS", (JaxbNode)this, xmlPath.getValidationTextRange(astRoot)));
        }
        for (ELJavaXmlPath xmlPath : this.xmlPathContainer.getContextElements()) {
            xmlPath.validate(messages, reporter, astRoot);
        }
    }

    protected void validateDuplicateQName(XmlElement xmlElement, Bag<QName> xmlElementQNames, List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getXmlPathsSize() == 0) {
            super.validateDuplicateQName(xmlElement, xmlElementQNames, messages, astRoot);
        }
    }

    protected TextRange getXmlPathsTextRange(CompilationUnit astRoot) {
        Annotation annotation = this.getJavaResourceAttribute().getAnnotation("org.eclipse.persistence.oxm.annotations.XmlPaths");
        if (annotation == null) {
            annotation = this.getJavaResourceAttribute().getAnnotation(0, "org.eclipse.persistence.oxm.annotations.XmlPath");
        }
        return annotation.getTextRange(astRoot);
    }

    protected class XmlElementContext
    extends GenericJavaXmlElementsMapping.XmlElementContext
    implements ELJavaXmlElement.Context {
        protected XmlElementContext(XmlElementAnnotation annotation) {
            super((GenericJavaXmlElementsMapping)ELJavaXmlElementsMapping.this, annotation);
        }

        public boolean hasXmlPath() {
            return ELJavaXmlElementsMapping.this.getXmlPathsSize() > 0;
        }
    }

    protected class XmlElementWrapperContext
    implements ELJavaXmlElementWrapper.Context {
        protected XmlElementWrapperContext() {
        }

        public XmlElementWrapperAnnotation getAnnotation() {
            return ELJavaXmlElementsMapping.this.getXmlElementWrapperAnnotation();
        }

        public boolean hasXmlPath() {
            return ELJavaXmlElementsMapping.this.getXmlPathsSize() > 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class XmlPathContainer
    extends AbstractJaxbNode.ContextListContainer<ELJavaXmlPath, XmlPathAnnotation> {
        protected XmlPathContainer() {
            super((AbstractJaxbNode)ELJavaXmlElementsMapping.this);
        }

        protected String getContextElementsPropertyName() {
            return "xmlPaths";
        }

        protected ELJavaXmlPath buildContextElement(XmlPathAnnotation resourceElement) {
            return ELJavaXmlElementsMapping.this.buildXmlPath(resourceElement);
        }

        protected ListIterable<XmlPathAnnotation> getResourceElements() {
            return ELJavaXmlElementsMapping.this.getXmlPathAnnotations();
        }

        protected XmlPathAnnotation getResourceElement(ELJavaXmlPath contextElement) {
            return contextElement.getAnnotation();
        }
    }

    protected class XmlPathContext
    implements ELJavaXmlPath.Context {
        protected XmlPathAnnotation annotation;

        protected XmlPathContext(XmlPathAnnotation annotation) {
            this.annotation = annotation;
        }

        public XmlPathAnnotation getAnnotation() {
            return this.annotation;
        }

        public JaxbAttributeMapping getAttributeMapping() {
            return ELJavaXmlElementsMapping.this;
        }
    }
}

