/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.internal.context.xpath.java;

import java.util.List;
import java.util.Vector;
import org.eclipse.jpt.common.core.internal.utility.SimpleTextRange;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JaxbNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlNs;
import org.eclipse.jpt.jaxb.core.context.XmlSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdAttributeUse;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.validation.ELJaxbValidationMessageBuilder;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPath {
    public static String DELIM = "/";
    public static String ATT_PREFIX = "@";
    public static String TEXT = "text()";
    public static String SELF = ".";
    public static String COLON = ":";
    public static char OPEN_BRACKET = (char)91;
    public static char CLOSE_BRACKET = (char)93;
    List<Step> steps = new Vector<Step>();

    public static String attributeXPath(String prefix, String localName) {
        if (prefix == null) {
            return StringTools.concatenate((String[])new String[]{ATT_PREFIX, localName});
        }
        return StringTools.concatenate((String[])new String[]{ATT_PREFIX, prefix, COLON, localName});
    }

    public static String elementXPath(String prefix, String localName) {
        if (prefix == null) {
            return localName;
        }
        return StringTools.concatenate((String[])new String[]{prefix, COLON, localName});
    }

    XPath(String xpathString) {
        this.parse(xpathString);
    }

    protected int getIndex(Step step) {
        return this.steps.indexOf(step);
    }

    protected Step getFirstStep() {
        if (this.steps.size() > 0) {
            return this.steps.get(0);
        }
        return null;
    }

    protected Step getNextStep(Step step) {
        int nextIndex = this.getIndex(step) + 1;
        if (this.steps.size() > nextIndex) {
            return this.steps.get(nextIndex);
        }
        return null;
    }

    protected void parse(String xpath) {
        String[] stringArray = xpath.split(DELIM, -1);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.steps.add(this.createStep(segment));
            ++n2;
        }
    }

    protected Step createStep(String stepValue) {
        if (TEXT.equals(stepValue)) {
            return new TextStep();
        }
        if (SELF.equals(stepValue)) {
            return new SelfStep();
        }
        if (stepValue.startsWith(ATT_PREFIX)) {
            return this.tryCreateAttributeStep(stepValue);
        }
        return this.tryCreateElementStep(stepValue);
    }

    protected Step tryCreateAttributeStep(String stepValue) {
        try {
            String attributeStepValue = stepValue.substring(1);
            Object[] stepParts = this.parseStepParts(attributeStepValue);
            return new AttributeStep(stepParts[0], stepParts[1], (String[])ArrayTools.subArray((Object[])stepParts, (int)2, (int)stepParts.length));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new InvalidStep(stepValue);
        }
    }

    protected Step tryCreateElementStep(String stepValue) {
        try {
            Object[] stepParts = this.parseStepParts(stepValue);
            return new ElementStep(stepParts[0], stepParts[1], (String[])ArrayTools.subArray((Object[])stepParts, (int)2, (int)stepParts.length));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new InvalidStep(stepValue);
        }
    }

    protected String[] parseStepParts(String stepValue) {
        Object[] predicate = new String[]{};
        int predicateStart = stepValue.lastIndexOf(OPEN_BRACKET);
        while (predicateStart >= 0) {
            int predicateEnd = stepValue.lastIndexOf(CLOSE_BRACKET);
            if (predicateEnd <= predicateStart || predicateEnd != stepValue.length() - 1) {
                throw new IllegalArgumentException();
            }
            predicate = (String[])ArrayTools.add((Object[])predicate, (int)0, (Object)stepValue.substring(predicateStart + 1, predicateEnd));
            stepValue = stepValue.substring(0, predicateStart);
            predicateStart = stepValue.lastIndexOf(OPEN_BRACKET);
        }
        String nsPrefix = null;
        int colon = stepValue.indexOf(COLON);
        if (colon > 0) {
            if (stepValue.indexOf(COLON, colon + 1) != -1) {
                throw new IllegalArgumentException();
            }
            nsPrefix = stepValue.substring(0, colon);
            stepValue = stepValue.substring(colon + 1);
        }
        if (StringTools.stringIsEmpty((String)stepValue) || stepValue.indexOf(COLON) >= 0 || stepValue.indexOf(OPEN_BRACKET) >= 0 || stepValue.indexOf(CLOSE_BRACKET) >= 0 || stepValue.indexOf(32) >= 0) {
            throw new IllegalArgumentException();
        }
        Object[] result = (String[])ArrayTools.add((Object[])new String[0], (Object)nsPrefix);
        result = (String[])ArrayTools.add((Object[])result, (Object)stepValue);
        result = (String[])ArrayTools.addAll((Object[])result, (Object[])predicate);
        return result;
    }

    public Iterable<String> getCompletionProposals(Context context, XsdTypeDefinition xsdType, int pos, Filter<String> filter) {
        return this.getFirstStep().getCompletionProposals(context, xsdType, "", pos, filter);
    }

    public void validate(Context context, XsdTypeDefinition xsdType, List<IMessage> messages) {
        this.getFirstStep().validate(context, xsdType, messages);
    }

    protected TextRange buildTextRange(Context context, Step step) {
        TextRange entireTextRange = context.getTextRange();
        int start = 0;
        for (Step each : this.steps) {
            int length = each.getValue().length() + 2;
            if (each == step) {
                return new SimpleTextRange(entireTextRange.getOffset() + start, length, entireTextRange.getLineNumber());
            }
            start += length - 1;
        }
        throw new IllegalArgumentException("Step must be in list of this XPath's steps.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeStep
    extends NamedComponentStep {
        protected AttributeStep(String nsPrefix, String localName, String[] predicates) {
            super(nsPrefix, localName, predicates);
        }

        @Override
        protected String getValue() {
            return String.valueOf(ATT_PREFIX) + super.getValue();
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            String namespace = this.resolveNamespace(context);
            if (namespace == null) {
                return null;
            }
            XsdAttributeUse xsdAttribute = previousType.getAttribute(namespace, this.localName);
            return xsdAttribute == null ? null : xsdAttribute.getAttributeDeclaration().getType();
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            if (this.getNextStep() != null) {
                messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__ATTRIBUTE_SEGMENT_MUST_BE_LAST_SEGMENT", context.getContextObject(), this.getTextRange(context)));
                return;
            }
            super.validate(context, previousType, messages);
        }

        @Override
        protected XsdTypeDefinition validateLocalName(Context context, XsdTypeDefinition previousType, String namespace, List<IMessage> messages) {
            XsdAttributeUse xsdAttribute = previousType.getAttribute(namespace, this.localName);
            if (xsdAttribute == null) {
                messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__UNRESOLVED_ATTRIBUTE", new String[]{namespace, this.localName}, context.getContextObject(), this.getTextRange(context)));
                return null;
            }
            return xsdAttribute.getAttributeDeclaration().getType();
        }
    }

    public static interface Context {
        public JaxbNode getContextObject();

        public JaxbPackage getJaxbPackage();

        public TextRange getTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ElementStep
    extends NamedComponentStep {
        protected ElementStep(String nsPrefix, String localName, String[] predicates) {
            super(nsPrefix, localName, predicates);
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            String namespace = this.resolveNamespace(context);
            if (namespace == null) {
                return null;
            }
            XsdElementDeclaration xsdElement = previousType.getElement(namespace, this.localName);
            return xsdElement == null ? null : xsdElement.getType();
        }

        @Override
        protected XsdTypeDefinition validateLocalName(Context context, XsdTypeDefinition previousType, String namespace, List<IMessage> messages) {
            XsdElementDeclaration xsdElement = previousType.getElement(namespace, this.localName);
            if (xsdElement == null) {
                messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__UNRESOLVED_ELEMENT", new String[]{namespace, this.localName}, context.getContextObject(), this.getTextRange(context)));
                return null;
            }
            return xsdElement.getType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InvalidStep
    extends Step {
        protected String value;

        protected InvalidStep(String value) {
            this.value = value;
        }

        @Override
        protected String getValue() {
            return this.value;
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            return null;
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__INVALID_FORM_ILLEGAL_SEGMENT", new String[]{this.getValue()}, context.getContextObject(), this.getTextRange(context)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class NamedComponentStep
    extends Step {
        protected String nsPrefix;
        protected String localName;
        protected List<String> predicates;

        protected NamedComponentStep(String nsPrefix, String localName, String[] predicates) {
            this.nsPrefix = nsPrefix;
            this.localName = localName;
            this.predicates = new Vector<String>();
            CollectionTools.addAll(this.predicates, (Object[])predicates);
        }

        @Override
        protected String getValue() {
            StringBuffer sb = new StringBuffer();
            if (this.nsPrefix != null) {
                sb.append(this.nsPrefix);
                sb.append(COLON);
            }
            sb.append(this.localName);
            for (String predicate : this.predicates) {
                sb.append(OPEN_BRACKET);
                sb.append(predicate);
                sb.append(CLOSE_BRACKET);
            }
            return sb.toString();
        }

        protected String resolveNamespace(Context context) {
            JaxbPackage pkg = context.getJaxbPackage();
            if (this.nsPrefix == null) {
                return "";
            }
            JaxbPackageInfo pkgInfo = pkg.getPackageInfo();
            return pkgInfo == null ? null : pkgInfo.getNamespaceForPrefix(this.nsPrefix);
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            Step nextStep;
            XsdTypeDefinition nextType;
            String namespace = this.resolveNamespace(context);
            if (namespace == null) {
                messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__INVALID_NS_PREFIX", new String[]{this.nsPrefix}, context.getContextObject(), this.getTextRange(context)));
            }
            XsdTypeDefinition xsdTypeDefinition = nextType = previousType == null ? null : this.validateLocalName(context, previousType, namespace, messages);
            if (nextType != null && (nextStep = this.getNextStep()) != null) {
                nextStep.validate(context, nextType, messages);
            }
        }

        protected abstract XsdTypeDefinition validateLocalName(Context var1, XsdTypeDefinition var2, String var3, List<IMessage> var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SelfStep
    extends Step {
        protected SelfStep() {
        }

        @Override
        protected String getValue() {
            return SELF;
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            return previousType;
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            if (this.getIndex() != 0) {
                messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__SELF_SEGMENT_MUST_BE_FIRST_SEGMENT", context.getContextObject(), this.getTextRange(context)));
                return;
            }
            if (this.getNextStep() != null) {
                this.getNextStep().validate(context, previousType, messages);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Step {
        protected Step() {
        }

        protected int getIndex() {
            return XPath.this.getIndex(this);
        }

        protected Step getNextStep() {
            return XPath.this.getNextStep(this);
        }

        protected abstract String getValue();

        protected abstract XsdTypeDefinition resolveNextType(Context var1, XsdTypeDefinition var2);

        protected Iterable<String> getCompletionProposals(Context context, XsdTypeDefinition previousType, final String prefix, int pos, Filter<String> filter) {
            if (this.getTextRange(context).includes(pos) || this.getNextStep() == null) {
                return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable((Iterable)new TransformationIterable<String, String>((Iterable)new CompositeIterable(new Iterable[]{this.getTextProposals(context, previousType), this.getAttributeProposals(context, previousType), this.getElementProposals(context, previousType)})){

                    protected String transform(String o) {
                        return StringTools.concatenate((String[])new String[]{prefix, o});
                    }
                }, filter));
            }
            Step nextStep = this.getNextStep();
            XsdTypeDefinition nextType = this.resolveNextType(context, previousType);
            if (nextStep != null && nextType != null) {
                return nextStep.getCompletionProposals(context, nextType, String.valueOf(prefix) + this.getValue() + DELIM, pos, filter);
            }
            return new SingleElementIterable((Object)TEXT);
        }

        protected Iterable<String> getTextProposals(Context context, XsdTypeDefinition xsdType) {
            return xsdType.hasTextContent() ? new SingleElementIterable((Object)TEXT) : EmptyIterable.instance();
        }

        protected Iterable<String> getAttributeProposals(Context context, final XsdTypeDefinition xsdType) {
            return new CompositeIterable(new Iterable[]{new CompositeIterable((Iterable)new TransformationIterable<XmlNs, Iterable<String>>(this.getXmlNsInfos(context)){

                protected Iterable<String> transform(final XmlNs xmlns) {
                    return new TransformationIterable<String, String>(xsdType.getAttributeNames(xmlns.getNamespaceURI())){

                        protected String transform(String o) {
                            return XPath.attributeXPath(xmlns.getPrefix(), o);
                        }
                    };
                }
            }), new TransformationIterable<String, String>(xsdType.getAttributeNames("")){

                protected String transform(String o) {
                    return XPath.attributeXPath(null, o);
                }
            }});
        }

        protected Iterable<String> getElementProposals(Context context, final XsdTypeDefinition xsdType) {
            return new CompositeIterable(new Iterable[]{new CompositeIterable((Iterable)new TransformationIterable<XmlNs, Iterable<String>>(this.getXmlNsInfos(context)){

                protected Iterable<String> transform(final XmlNs xmlns) {
                    return new TransformationIterable<String, String>(xsdType.getElementNames(xmlns.getNamespaceURI(), false)){

                        protected String transform(String o) {
                            return XPath.elementXPath(xmlns.getPrefix(), o);
                        }
                    };
                }
            }), xsdType.getElementNames("", false)});
        }

        protected Iterable<XmlNs> getXmlNsInfos(Context context) {
            JaxbPackageInfo pkgInfo = context.getJaxbPackage().getPackageInfo();
            XmlSchema xmlSchema = pkgInfo == null ? null : pkgInfo.getXmlSchema();
            return xmlSchema == null ? EmptyIterable.instance() : xmlSchema.getXmlNsPrefixes();
        }

        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
        }

        protected TextRange getTextRange(Context context) {
            return XPath.this.buildTextRange(context, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TextStep
    extends Step {
        protected TextStep() {
        }

        @Override
        protected String getValue() {
            return TEXT;
        }

        @Override
        protected XsdTypeDefinition resolveNextType(Context context, XsdTypeDefinition previousType) {
            return previousType;
        }

        @Override
        protected void validate(Context context, XsdTypeDefinition previousType, List<IMessage> messages) {
            if (this.getNextStep() != null) {
                messages.add(ELJaxbValidationMessageBuilder.buildMessage(1, "XPATH__TEXT_SEGMENT_MUST_BE_LAST_SEGMENT", context.getContextObject(), this.getTextRange(context)));
            }
        }
    }
}

