/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCollectionTable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.CollectionTable2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaCollectionTableTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0JavaCollectionTableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithElementCollection() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidElementCollection() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
                sb.append("    private Collection<String> projects;").append(CR);
            }
        });
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedName());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable);
        resourceField.addAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)resourceCollectionTable.getName());
        resourceCollectionTable.setName(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedName());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable.getName());
        resourceCollectionTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)resourceCollectionTable.getName());
        resourceField.removeAnnotation("javax.persistence.CollectionTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedName());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation resourceCollectionTable3 = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedName());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable3);
        collectionTable.setSpecifiedName("foo");
        resourceCollectionTable3 = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"foo", (String)collectionTable.getSpecifiedName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"foo", (String)resourceCollectionTable3.getName());
        collectionTable.setSpecifiedName(null);
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedName());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testDefaultName() throws Exception {
        this.createTestEntityWithValidElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"AnnotationTestType_projects", (String)collectionTable.getDefaultName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.CollectionTable"));
        resourceField.addAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"AnnotationTestType_projects", (String)collectionTable.getDefaultName());
        EclipseLink2_0JavaCollectionTableTests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.CollectionTable"));
        this.getJavaEntity().setSpecifiedName("Foo");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"Foo_projects", (String)collectionTable.getDefaultName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedSchema());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable);
        resourceField.addAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable.setSchema("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedSchema());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)resourceCollectionTable.getSchema());
        resourceCollectionTable.setSchema(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedSchema());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable.getSchema());
        resourceCollectionTable.setSchema("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedSchema());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)resourceCollectionTable.getSchema());
        resourceField.removeAnnotation("javax.persistence.CollectionTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedSchema());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testModifySpecifiedSchema() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedSchema());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable);
        collectionTable.setSpecifiedSchema("foo");
        resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"foo", (String)collectionTable.getSpecifiedSchema());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"foo", (String)resourceCollectionTable.getSchema());
        collectionTable.setSpecifiedSchema(null);
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedSchema());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable);
        resourceField.addAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        resourceCollectionTable.setCatalog("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedCatalog());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)resourceCollectionTable.getCatalog());
        resourceCollectionTable.setCatalog(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable.getCatalog());
        resourceCollectionTable.setCatalog("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)collectionTable.getSpecifiedCatalog());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)resourceCollectionTable.getCatalog());
        resourceField.removeAnnotation("javax.persistence.CollectionTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testModifySpecifiedCatalog() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceCollectionTable);
        collectionTable.setSpecifiedCatalog("foo");
        resourceCollectionTable = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"foo", (String)collectionTable.getSpecifiedCatalog());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"foo", (String)resourceCollectionTable.getCatalog());
        collectionTable.setSpecifiedCatalog(null);
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)collectionTable.getSpecifiedCatalog());
        EclipseLink2_0JavaCollectionTableTests.assertNull((Object)resourceField.getAnnotation("javax.persistence.CollectionTable"));
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        JavaJoinColumn joinColumn = collectionTable.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        CollectionTable2_0Annotation joinTableResource = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinColumn joinColumn2 = collectionTable.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinColumn joinColumn3 = collectionTable.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        ListIterator joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        collectionTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        collectionTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        collectionTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        CollectionTable2_0Annotation joinTableResource = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)3, (int)joinTableResource.getJoinColumnsSize());
        collectionTable.removeSpecifiedJoinColumn(0);
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)2, (int)joinTableResource.getJoinColumnsSize());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        collectionTable.removeSpecifiedJoinColumn(0);
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)1, (int)joinTableResource.getJoinColumnsSize());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(0).getName());
        collectionTable.removeSpecifiedJoinColumn(0);
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)0, (int)joinTableResource.getJoinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        collectionTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        collectionTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        collectionTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        CollectionTable2_0Annotation joinTableResource = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)3, (int)joinTableResource.getJoinColumnsSize());
        collectionTable.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        collectionTable.moveSpecifiedJoinColumn(0, 1);
        joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(0).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(1).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation joinTableResource = (CollectionTable2_0Annotation)resourceField.addAnnotation("javax.persistence.CollectionTable");
        joinTableResource.addJoinColumn(0);
        joinTableResource.addJoinColumn(1);
        joinTableResource.addJoinColumn(2);
        joinTableResource.joinColumnAt(0).setName("FOO");
        joinTableResource.joinColumnAt(1).setName("BAR");
        joinTableResource.joinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = collectionTable.getSpecifiedJoinColumns().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)collectionTable.getSpecifiedJoinColumns().iterator().hasNext());
    }

    public void testGetDefaultJoinColumn() {
    }

    public void testSpecifiedJoinColumnsSize() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)0, (int)collectionTable.getSpecifiedJoinColumnsSize());
        collectionTable.addSpecifiedJoinColumn(0);
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)1, (int)collectionTable.getSpecifiedJoinColumnsSize());
        collectionTable.removeSpecifiedJoinColumn(0);
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)0, (int)collectionTable.getSpecifiedJoinColumnsSize());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        ListIterator uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)resourceField.addAnnotation("javax.persistence.CollectionTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testgetUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)0, (int)collectionTable.getUniqueConstraintsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)resourceField.addAnnotation("javax.persistence.CollectionTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)2, (int)collectionTable.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        collectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        collectionTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        collectionTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        ListIterator uniqueConstraints = joinTableAnnotation.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        collectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        collectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        collectionTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        ListIterator uniqueConstraints = joinTableAnnotation.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        collectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        collectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        collectionTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)3, (int)joinTableAnnotation.getUniqueConstraintsSize());
        collectionTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        collectionTable.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        collectionTable.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        collectionTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        collectionTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        collectionTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)resourceField.getAnnotation("javax.persistence.CollectionTable");
        EclipseLink2_0JavaCollectionTableTests.assertEquals((int)3, (int)joinTableAnnotation.getUniqueConstraintsSize());
        collectionTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        collectionTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        uniqueConstraintAnnotations = joinTableAnnotation.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNameAt(0));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithElementCollection();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaElementCollectionMapping2_0 elementCollectionMapping = (JavaElementCollectionMapping2_0)((JavaPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaCollectionTable2_0 collectionTable = elementCollectionMapping.getCollectionTable();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        CollectionTable2_0Annotation joinTableAnnotation = (CollectionTable2_0Annotation)resourceField.addAnnotation("javax.persistence.CollectionTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        joinTableAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAR", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = collectionTable.getUniqueConstraints().iterator();
        EclipseLink2_0JavaCollectionTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

