/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.JavaEclipseLinkBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkStructConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaStructConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithConvertAndStructConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @StructConverter(name=\"foo\"");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndStructConverterClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @StructConverter(converter=\"Foo\"");
            }
        });
    }

    public EclipseLinkJavaStructConverterTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithConvertAndStructConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)basicMapping.getConverterContainer().getStructConverters().iterator().next();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"foo", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithConvertAndStructConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)basicMapping.getConverterContainer().getStructConverters().iterator().next();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"foo", (String)converter.getName());
        converter.setName("bar");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converter.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkStructConverterAnnotation converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
        converter.setName(null);
        EclipseLinkJavaStructConverterTests.assertEquals(null, (String)converter.getName());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals(null, (String)converterAnnotation.getName());
        converter.setName("bar");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converter.getName());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
    }

    public void testGetNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndStructConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)basicMapping.getConverterContainer().getStructConverters().iterator().next();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"foo", (String)converter.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkStructConverterAnnotation converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        converterAnnotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"bar", (String)converter.getName());
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertFalse((boolean)basicMapping.getConverterContainer().getStructConverters().iterator().hasNext());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkStructConverter)basicMapping.getConverterContainer().getStructConverters().iterator().next();
        EclipseLinkJavaStructConverterTests.assertNotNull((Object)converter);
        converterAnnotation.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"FOO", (String)converter.getName());
    }

    public void testGetConverterClass() throws Exception {
        this.createTestEntityWithConvertAndStructConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)basicMapping.getConverterContainer().getStructConverters().iterator().next();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
    }

    public void testSetConverterClass() throws Exception {
        this.createTestEntityWithConvertAndStructConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)basicMapping.getConverterContainer().getStructConverters().iterator().next();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        converter.setConverterClass("Bar");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkStructConverterAnnotation converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getConverter());
        converter.setConverterClass(null);
        EclipseLinkJavaStructConverterTests.assertEquals(null, (String)converter.getConverterClass());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals(null, (String)converterAnnotation.getConverter());
        converter.setConverterClass("Bar");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getConverter());
    }

    public void testGetConverterClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndStructConverterClass();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        JavaEclipseLinkBasicMapping basicMapping = (JavaEclipseLinkBasicMapping)persistentAttribute.getMapping();
        EclipseLinkStructConverter converter = (EclipseLinkStructConverter)basicMapping.getConverterContainer().getStructConverters().iterator().next();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Foo", (String)converter.getConverterClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.Kind.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        EclipseLinkStructConverterAnnotation converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        converterAnnotation.setConverter("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"Bar", (String)converter.getConverterClass());
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertFalse((boolean)basicMapping.getConverterContainer().getStructConverters().iterator().hasNext());
        converterAnnotation = (EclipseLinkStructConverterAnnotation)resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.StructConverter");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkStructConverter)basicMapping.getConverterContainer().getStructConverters().iterator().next();
        EclipseLinkJavaStructConverterTests.assertNotNull((Object)converter);
        converterAnnotation.setConverter("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaStructConverterTests.assertEquals((String)"FooBar", (String)converter.getConverterClass());
    }
}

