/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMultitenantType2_3;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkPersistenceUnitDefaults;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmEclipseLinkEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmEclipseLinkMappedSuperclass;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmEclipseLinkMultitenancy2_3;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmReadOnlyTenantDiscriminatorColumn2_3;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmTenantDiscriminatorColumn2_3;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlMultitenant;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlMultitenantHolder;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.v2_3.MultitenantType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.v2_3.XmlTenantDiscriminatorColumn_2_3;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_3ContextModelTestCase;

public class EclipseLink2_3OrmMultitenancyTests
extends EclipseLink2_3ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public EclipseLink2_3OrmMultitenancyTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestMultitenantMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.Multitenant", "org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@Multitenant").append(CR);
                sb.append("@TenantDiscriminatorColumn(name=\"MS_TENANT_ID\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestMultitenantRootEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "org.eclipse.persistence.annotations.Multitenant", "org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritenace").append(CR);
                sb.append("@Multitenant").append(CR);
                sb.append("@TenantDiscriminatorColumn(name=\"ROOT_ENTITY_TENANT_ID\")").append(CR);
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(EclipseLink2_3OrmMultitenancyTests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedType() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        XmlMultitenantHolder multitenantHolder = (XmlMultitenantHolder)this.getXmlEntityMappings().getEntities().get(0);
        multitenantHolder.setMultitenant(EclipseLinkOrmFactory.eINSTANCE.createXmlMultitenant());
        OrmEclipseLinkMultitenancy2_3 ormMultitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        XmlMultitenant multitenantResource = multitenantHolder.getMultitenant();
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantResource.getType());
        multitenantResource.setType(MultitenantType.SINGLE_TABLE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.SINGLE_TABLE, (Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)MultitenantType.SINGLE_TABLE, (Object)multitenantResource.getType());
        multitenantResource.setType(null);
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantResource.getType());
        multitenantResource.setType(MultitenantType.TABLE_PER_TENANT);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.TABLE_PER_TENANT, (Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)MultitenantType.TABLE_PER_TENANT, (Object)multitenantResource.getType());
        multitenantResource.setType(MultitenantType.VPD);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.VPD, (Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)MultitenantType.VPD, (Object)multitenantResource.getType());
        multitenantHolder.setMultitenant(null);
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getType());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantHolder.getMultitenant());
    }

    public void testModifySpecifiedType() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        XmlMultitenantHolder multitenantHolder = (XmlMultitenantHolder)this.getXmlEntityMappings().getEntities().get(0);
        multitenantHolder.setMultitenant(EclipseLinkOrmFactory.eINSTANCE.createXmlMultitenant());
        OrmEclipseLinkMultitenancy2_3 ormMultitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        XmlMultitenant multitenantResource = multitenantHolder.getMultitenant();
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantResource.getType());
        ormMultitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.SINGLE_TABLE, (Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)MultitenantType.SINGLE_TABLE, (Object)multitenantResource.getType());
        ormMultitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.VPD);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.VPD, (Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)MultitenantType.VPD, (Object)multitenantResource.getType());
        ormMultitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.TABLE_PER_TENANT);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.TABLE_PER_TENANT, (Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)MultitenantType.TABLE_PER_TENANT, (Object)multitenantResource.getType());
        ormMultitenancy.setSpecifiedType(null);
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedType());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantResource.getType());
    }

    public void testUpdateSpecifiedIncludeCriteria() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        XmlMultitenantHolder multitenantHolder = (XmlMultitenantHolder)this.getXmlEntityMappings().getEntities().get(0);
        multitenantHolder.setMultitenant(EclipseLinkOrmFactory.eINSTANCE.createXmlMultitenant());
        OrmEclipseLinkMultitenancy2_3 ormMultitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        XmlMultitenant multitenantResource = multitenantHolder.getMultitenant();
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedIncludeCriteria());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantResource.getIncludeCriteria());
        multitenantResource.setIncludeCriteria(Boolean.TRUE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)Boolean.TRUE, (Object)ormMultitenancy.getSpecifiedIncludeCriteria());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)Boolean.TRUE, (Object)multitenantResource.getIncludeCriteria());
        multitenantResource.setIncludeCriteria(Boolean.FALSE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)Boolean.FALSE, (Object)ormMultitenancy.getSpecifiedIncludeCriteria());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)Boolean.FALSE, (Object)multitenantResource.getIncludeCriteria());
        multitenantResource.setIncludeCriteria(null);
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedIncludeCriteria());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantResource.getIncludeCriteria());
    }

    public void testModifySpecifiedIncludeCriteria() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        XmlMultitenantHolder multitenantHolder = (XmlMultitenantHolder)this.getXmlEntityMappings().getEntities().get(0);
        multitenantHolder.setMultitenant(EclipseLinkOrmFactory.eINSTANCE.createXmlMultitenant());
        OrmEclipseLinkMultitenancy2_3 ormMultitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        XmlMultitenant multitenantResource = multitenantHolder.getMultitenant();
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedIncludeCriteria());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantResource.getIncludeCriteria());
        ormMultitenancy.setSpecifiedIncludeCriteria(Boolean.TRUE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)Boolean.TRUE, (Object)multitenantResource.getIncludeCriteria());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)Boolean.TRUE, (Object)ormMultitenancy.getSpecifiedIncludeCriteria());
        ormMultitenancy.setSpecifiedIncludeCriteria(Boolean.FALSE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)Boolean.FALSE, (Object)multitenantResource.getIncludeCriteria());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)Boolean.FALSE, (Object)ormMultitenancy.getSpecifiedIncludeCriteria());
        ormMultitenancy.setSpecifiedIncludeCriteria(null);
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)multitenantResource.getIncludeCriteria());
        EclipseLink2_3OrmMultitenancyTests.assertNull((Object)ormMultitenancy.getSpecifiedIncludeCriteria());
    }

    public void testAddSpecifiedTenantDiscriminatorColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        XmlMultitenantHolder multitenantHolder = (XmlMultitenantHolder)this.getXmlEntityMappings().getEntities().get(0);
        multitenantHolder.setMultitenant(EclipseLinkOrmFactory.eINSTANCE.createXmlMultitenant());
        OrmEclipseLinkMultitenancy2_3 ormMultitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        XmlMultitenant multitenantResource = multitenantHolder.getMultitenant();
        OrmTenantDiscriminatorColumn2_3 tenantDiscriminatorColumn = ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(0);
        tenantDiscriminatorColumn.setSpecifiedName("FOO");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(0)).getName());
        OrmTenantDiscriminatorColumn2_3 tenantDiscriminatorColumn2 = ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(0);
        tenantDiscriminatorColumn2.setSpecifiedName("BAR");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(0)).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(1)).getName());
        OrmTenantDiscriminatorColumn2_3 tenantDiscriminatorColumn3 = ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(1);
        tenantDiscriminatorColumn3.setSpecifiedName("BAZ");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(0)).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(1)).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(2)).getName());
        ListIterator tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)tenantDiscriminatorColumn2, tenantDiscriminatorColumns.next());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)tenantDiscriminatorColumn3, tenantDiscriminatorColumns.next());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((Object)tenantDiscriminatorColumn, tenantDiscriminatorColumns.next());
        tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
    }

    public void testRemoveSpecifiedTenantDiscriminatorColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        XmlMultitenantHolder multitenantHolder = (XmlMultitenantHolder)this.getXmlEntityMappings().getEntities().get(0);
        multitenantHolder.setMultitenant(EclipseLinkOrmFactory.eINSTANCE.createXmlMultitenant());
        OrmEclipseLinkMultitenancy2_3 ormMultitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        XmlMultitenant multitenantResource = multitenantHolder.getMultitenant();
        ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("FOO");
        ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(1).setSpecifiedName("BAR");
        ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(2).setSpecifiedName("BAZ");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)3, (int)multitenantResource.getTenantDiscriminatorColumns().size());
        ormMultitenancy.removeSpecifiedTenantDiscriminatorColumn(0);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)2, (int)multitenantResource.getTenantDiscriminatorColumns().size());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(0)).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(1)).getName());
        ormMultitenancy.removeSpecifiedTenantDiscriminatorColumn(0);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenantResource.getTenantDiscriminatorColumns().size());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(0)).getName());
        ormMultitenancy.removeSpecifiedTenantDiscriminatorColumn(0);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenantResource.getTenantDiscriminatorColumns().size());
    }

    public void testMoveSpecifiedTenantDiscriminatorColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        XmlMultitenantHolder multitenantHolder = (XmlMultitenantHolder)this.getXmlEntityMappings().getEntities().get(0);
        multitenantHolder.setMultitenant(EclipseLinkOrmFactory.eINSTANCE.createXmlMultitenant());
        OrmEclipseLinkMultitenancy2_3 ormMultitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        XmlMultitenant multitenantResource = multitenantHolder.getMultitenant();
        ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("FOO");
        ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(1).setSpecifiedName("BAR");
        ormMultitenancy.addSpecifiedTenantDiscriminatorColumn(2).setSpecifiedName("BAZ");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)3, (int)multitenantResource.getTenantDiscriminatorColumns().size());
        ormMultitenancy.moveSpecifiedTenantDiscriminatorColumn(2, 0);
        ListIterator tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(0)).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(1)).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(2)).getName());
        ormMultitenancy.moveSpecifiedTenantDiscriminatorColumn(0, 1);
        tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(0)).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(1)).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(2)).getName());
    }

    public void testUpdateTenantDiscriminatorColumns() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        XmlMultitenantHolder multitenantHolder = (XmlMultitenantHolder)this.getXmlEntityMappings().getEntities().get(0);
        multitenantHolder.setMultitenant(EclipseLinkOrmFactory.eINSTANCE.createXmlMultitenant());
        OrmEclipseLinkMultitenancy2_3 ormMultitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        XmlMultitenant multitenantResource = multitenantHolder.getMultitenant();
        multitenantResource.getTenantDiscriminatorColumns().add((Object)EclipseLinkOrmFactory.eINSTANCE.createXmlTenantDiscriminatorColumn());
        multitenantResource.getTenantDiscriminatorColumns().add((Object)EclipseLinkOrmFactory.eINSTANCE.createXmlTenantDiscriminatorColumn());
        multitenantResource.getTenantDiscriminatorColumns().add((Object)EclipseLinkOrmFactory.eINSTANCE.createXmlTenantDiscriminatorColumn());
        ((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(0)).setName("FOO");
        ((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(1)).setName("BAR");
        ((XmlTenantDiscriminatorColumn_2_3)multitenantResource.getTenantDiscriminatorColumns().get(2)).setName("BAZ");
        ListIterator tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        multitenantResource.getTenantDiscriminatorColumns().move(2, 0);
        tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        multitenantResource.getTenantDiscriminatorColumns().move(0, 1);
        tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAR", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        multitenantResource.getTenantDiscriminatorColumns().remove(1);
        tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"FOO", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        multitenantResource.getTenantDiscriminatorColumns().remove(1);
        tenantDiscriminatorColumns = ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"BAZ", (String)((OrmTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        multitenantResource.getTenantDiscriminatorColumns().remove(0);
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)ormMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator().hasNext());
    }

    public void testTenantDiscriminatorColumnsWithMappedSuperclass() throws Exception {
        this.createTestMultitenantMappedSuperclass();
        this.createTestSubType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("mappedSuperclass", "test.AnnotationTestType");
        OrmPersistentType ormPersistentType2 = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        OrmEclipseLinkMultitenancy2_3 multitenancy = ((OrmEclipseLinkEntity)ormPersistentType2.getMapping()).getMultitenancy();
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"MS_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.setSpecifiedMultitenant(false);
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        OrmEclipseLinkMultitenancy2_3 mappedSuperclassMultitenancy = ((OrmEclipseLinkMappedSuperclass)ormPersistentType.getMapping()).getMultitenancy();
        mappedSuperclassMultitenancy.setSpecifiedMultitenant(true);
        mappedSuperclassMultitenancy.addSpecifiedTenantDiscriminatorColumn().setSpecifiedName("MS_TENANT_ID");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"MS_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
    }

    public void testTenantDiscriminatorColumnsWithInheritance() throws Exception {
        this.createTestMultitenantRootEntity();
        this.createTestSubType();
        this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", FULLY_QUALIFIED_SUB_TYPE_NAME);
        OrmEclipseLinkMultitenancy2_3 multitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        EclipseLink2_3OrmMultitenancyTests.assertTrue((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"ROOT_ENTITY_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        ormPersistentType.getMapping().getRootEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        EclipseLink2_3OrmMultitenancyTests.assertTrue((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"ROOT_ENTITY_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        ormPersistentType.getMapping().getRootEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLinkPersistenceUnitDefaults persistenceUnitDefaults = (EclipseLinkPersistenceUnitDefaults)this.getMappingFile().getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
        persistenceUnitDefaults.addTenantDiscriminatorColumn().setSpecifiedName("PU_TENANT_ID");
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        multitenancy.setSpecifiedMultitenant(true);
        EclipseLink2_3OrmMultitenancyTests.assertTrue((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"PU_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.addSpecifiedTenantDiscriminatorColumn().setSpecifiedName("CHILD_TENANT_ID");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"CHILD_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        ormPersistentType.getMapping().getRootEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"CHILD_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
    }

    public void testTenantDiscriminatorColumnsWithPersistenceUnitDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkPersistenceUnitDefaults persistenceUnitDefaults = (EclipseLinkPersistenceUnitDefaults)this.getMappingFile().getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
        persistenceUnitDefaults.addTenantDiscriminatorColumn().setSpecifiedName("PU_TENANT_ID");
        OrmEclipseLinkMultitenancy2_3 multitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"PU_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.addSpecifiedTenantDiscriminatorColumn().setSpecifiedName("ENTITY_TENANT_ID");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getDefaultTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"ENTITY_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.setSpecifiedMultitenant(false);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
    }

    public void testTenantDiscriminatorColumnsWithEntityMappingsDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkEntityMappings entityMappings = (EclipseLinkEntityMappings)this.getMappingFile().getRoot();
        entityMappings.addSpecifiedTenantDiscriminatorColumn().setSpecifiedName("EM_TENANT_ID");
        OrmEclipseLinkMultitenancy2_3 multitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"EM_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.TABLE_PER_TENANT);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        multitenancy.setSpecifiedMultitenant(false);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLinkPersistenceUnitDefaults persistenceUnitDefaults = (EclipseLinkPersistenceUnitDefaults)this.getMappingFile().getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
        persistenceUnitDefaults.addTenantDiscriminatorColumn().setSpecifiedName("PU_TENANT_ID");
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"EM_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
    }

    public void testTenantDiscriminatorColumnsWithJavaMultitenant() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ((EclipseLinkEntity)ormPersistentType.getJavaPersistentType().getMapping()).getMultitenancy().setSpecifiedMultitenant(true);
        OrmEclipseLinkMultitenancy2_3 multitenancy = ((OrmEclipseLinkEntity)ormPersistentType.getMapping()).getMultitenancy();
        EclipseLink2_3OrmMultitenancyTests.assertTrue((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        EclipseLinkEntityMappings entityMappings = (EclipseLinkEntityMappings)this.getMappingFile().getRoot();
        entityMappings.addSpecifiedTenantDiscriminatorColumn().setSpecifiedName("EM_TENANT_ID");
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((String)"EM_TENANT_ID", (String)((OrmReadOnlyTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        OrmPersistenceUnitMetadata persistenceUnitMetadata = (OrmPersistenceUnitMetadata)this.getMappingFile().getRoot().getPersistenceUnitMetadata();
        persistenceUnitMetadata.setXmlMappingMetadataComplete(true);
        EclipseLink2_3OrmMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3OrmMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
    }
}

