/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.Bag;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashBagTests
extends TestCase {
    private HashBag<String> bag;

    public HashBagTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bag = this.buildBag();
    }

    private HashBag<String> buildBag() {
        HashBag b = new HashBag();
        b.add(null);
        b.add((Object)new String("one"));
        b.add((Object)new String("two"));
        b.add((Object)new String("two"));
        b.add((Object)new String("three"));
        b.add((Object)new String("three"));
        b.add((Object)new String("three"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        return b;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    private Collection<String> buildCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(new String("foo"));
        c.add(new String("foo"));
        c.add(new String("bar"));
        c.add(new String("bar"));
        c.add(new String("bar"));
        return c;
    }

    public void testCtorCollection() {
        Collection<String> c = this.buildCollection();
        HashBag b = new HashBag(c);
        for (String s : c) {
            HashBagTests.assertTrue((boolean)b.contains((Object)s));
        }
    }

    public void testCtorIntFloat() {
        boolean exCaught = false;
        try {
            this.bag = new HashBag(-20, 0.66f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.bag = new HashBag(20, -0.66f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
    }

    public void testAdd() {
        HashBagTests.assertTrue((boolean)this.bag.add((Object)"five"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"five"));
    }

    public void testAddCount() {
        this.bag.add((Object)"minus3", -3);
        this.bag.add((Object)"zero", 0);
        this.bag.add((Object)"five", 5);
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"minus3"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"zero"));
        HashBagTests.assertEquals((int)1, (int)this.bag.count((Object)"one"));
        HashBagTests.assertEquals((int)2, (int)this.bag.count((Object)"two"));
        HashBagTests.assertEquals((int)3, (int)this.bag.count((Object)"three"));
        HashBagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        HashBagTests.assertEquals((int)5, (int)this.bag.count((Object)"five"));
        this.bag.add((Object)"three", 2);
        HashBagTests.assertEquals((int)5, (int)this.bag.count((Object)"three"));
    }

    public void testAddAll() {
        Collection<String> c = this.buildCollection();
        HashBagTests.assertTrue((boolean)this.bag.addAll(c));
        for (String s : c) {
            HashBagTests.assertTrue((boolean)this.bag.contains((Object)s));
        }
    }

    public void testClear() {
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertTrue((boolean)this.bag.contains(null));
        HashBagTests.assertEquals((int)11, (int)this.bag.size());
        this.bag.clear();
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertFalse((boolean)this.bag.contains(null));
        HashBagTests.assertEquals((int)0, (int)this.bag.size());
    }

    public void testClone() {
        HashBag bag2 = this.bag.clone();
        HashBagTests.assertTrue((this.bag != bag2 ? 1 : 0) != 0);
        HashBagTests.assertEquals(this.bag, (Object)bag2);
        HashBagTests.assertTrue((this.bag.hashCode() == bag2.hashCode() ? 1 : 0) != 0);
    }

    public void testContains() {
        HashBagTests.assertTrue((boolean)this.bag.contains(null));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)new String("four")));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"five"));
    }

    public void testContainsAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(null);
        c.add(new String("one"));
        c.add(new String("two"));
        c.add(new String("three"));
        c.add(new String("four"));
        HashBagTests.assertTrue((boolean)this.bag.containsAll(c));
    }

    public void testCount() {
        HashBagTests.assertEquals((int)0, (int)this.bag.count((Object)"zero"));
        HashBagTests.assertEquals((int)1, (int)this.bag.count((Object)"one"));
        HashBagTests.assertEquals((int)2, (int)this.bag.count((Object)"two"));
        HashBagTests.assertEquals((int)3, (int)this.bag.count((Object)"three"));
        HashBagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        HashBagTests.assertEquals((int)0, (int)this.bag.count((Object)"five"));
    }

    public void testEquals() {
        HashBag<String> bag2 = this.buildBag();
        HashBagTests.assertEquals(this.bag, bag2);
        bag2.add((Object)"five");
        HashBagTests.assertFalse((boolean)this.bag.equals(bag2));
        ArrayList<String> c = new ArrayList<String>((Collection<String>)this.bag);
        HashBagTests.assertFalse((boolean)this.bag.equals(c));
    }

    public void testHashCode() {
        HashBag<String> bag2 = this.buildBag();
        HashBagTests.assertEquals((int)this.bag.hashCode(), (int)bag2.hashCode());
    }

    public void testIsEmpty() {
        HashBagTests.assertFalse((boolean)this.bag.isEmpty());
        this.bag.clear();
        HashBagTests.assertTrue((boolean)this.bag.isEmpty());
        this.bag.add((Object)"foo");
        HashBagTests.assertFalse((boolean)this.bag.isEmpty());
    }

    public void testEmptyIterator() {
        this.bag.clear();
        Iterator iterator = this.bag.iterator();
        HashBagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            HashBagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
    }

    public void testIterator() {
        int i = 0;
        Iterator iterator = this.bag.iterator();
        HashBagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        HashBagTests.assertEquals((int)11, (int)i);
        HashBagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            HashBagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
        iterator.remove();
        HashBagTests.assertEquals((int)10, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.iterator();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
    }

    public void testUniqueIterator() {
        int i = 0;
        Iterator iterator = this.bag.uniqueIterator();
        HashBagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        HashBagTests.assertEquals((int)5, (int)i);
        HashBagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            HashBagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.uniqueIterator();
        Object next = null;
        while (iterator.hasNext() && !"four".equals(next)) {
            next = iterator.next();
        }
        iterator.remove();
        HashBagTests.assertEquals((int)7, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.uniqueIterator();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
    }

    public void testEntries() {
        int i = 0;
        Iterator iterator = this.bag.entries();
        HashBagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        HashBagTests.assertEquals((int)5, (int)i);
        HashBagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            HashBagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.entries();
        Bag.Entry next = null;
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (!((String)next.getElement()).equals("four")) continue;
            iterator.remove();
            break;
        }
        HashBagTests.assertEquals((int)7, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.entries();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        HashBagTests.assertTrue((boolean)exCaught);
    }

    public void testHashingDistribution() throws Exception {
        HashBag bigBag = new HashBag();
        int i = 0;
        while (i < 10000) {
            bigBag.add((Object)("object" + i));
            ++i;
        }
        Field field = bigBag.getClass().getDeclaredField("table");
        field.setAccessible(true);
        Object[] table = (Object[])field.get(bigBag);
        int bucketCount = table.length;
        int filledBucketCount = 0;
        Object[] objectArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null) {
                ++filledBucketCount;
            }
            ++n2;
        }
        float loadFactor = (float)filledBucketCount / (float)bucketCount;
        if ((double)loadFactor < 0.2 || (double)loadFactor > 0.8) {
            String msg = "poor load factor: " + loadFactor;
            if (Tools.jvmIsSun()) {
                HashBagTests.fail((String)msg);
            } else {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + '.' + this.getName() + " - " + msg);
                TestTools.printSystemProperties();
            }
        }
    }

    public void testRemove() {
        HashBagTests.assertTrue((boolean)this.bag.remove((Object)"one"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"one"));
        HashBagTests.assertTrue((boolean)this.bag.remove((Object)"two"));
        HashBagTests.assertTrue((boolean)this.bag.remove((Object)"two"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"two"));
    }

    public void testRemoveCount() {
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"one", 0));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((boolean)this.bag.remove((Object)"one", 1));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"one"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"two", -3));
        HashBagTests.assertTrue((boolean)this.bag.remove((Object)"two", 1));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertTrue((boolean)this.bag.remove((Object)"two", 1));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"two"));
        HashBagTests.assertTrue((boolean)this.bag.remove((Object)"three", 3));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"three"));
    }

    public void testRemoveAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("three");
        HashBagTests.assertTrue((boolean)this.bag.removeAll(c));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"one"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"three"));
        HashBagTests.assertFalse((boolean)this.bag.removeAll(c));
    }

    public void testRetainAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("three");
        HashBagTests.assertTrue((boolean)this.bag.retainAll(c));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        HashBagTests.assertTrue((boolean)this.bag.contains((Object)"three"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"two"));
        HashBagTests.assertFalse((boolean)this.bag.contains((Object)"four"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"two"));
        HashBagTests.assertFalse((boolean)this.bag.remove((Object)"four"));
        HashBagTests.assertFalse((boolean)this.bag.retainAll(c));
    }

    public void testSize() {
        HashBagTests.assertTrue((this.bag.size() == 11 ? 1 : 0) != 0);
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        HashBagTests.assertEquals((int)16, (int)this.bag.size());
    }

    public void testSerialization() throws Exception {
        Bag bag2 = (Bag)TestTools.serialize(this.bag);
        HashBagTests.assertTrue((String)"same object?", (this.bag != bag2 ? 1 : 0) != 0);
        HashBagTests.assertEquals((int)11, (int)bag2.size());
        HashBagTests.assertEquals(this.bag, (Object)bag2);
        HashBagTests.assertTrue((boolean)bag2.contains(null));
        HashBagTests.assertTrue((boolean)bag2.contains((Object)"one"));
        HashBagTests.assertTrue((boolean)bag2.contains((Object)"two"));
        HashBagTests.assertTrue((boolean)bag2.contains((Object)"three"));
        HashBagTests.assertTrue((boolean)bag2.contains((Object)"four"));
        int nullCount = 0;
        int oneCount = 0;
        int twoCount = 0;
        int threeCount = 0;
        int fourCount = 0;
        for (String s : bag2) {
            if (s == null) {
                ++nullCount;
                continue;
            }
            if (s.equals("one")) {
                ++oneCount;
                continue;
            }
            if (s.equals("two")) {
                ++twoCount;
                continue;
            }
            if (s.equals("three")) {
                ++threeCount;
                continue;
            }
            if (!s.equals("four")) continue;
            ++fourCount;
        }
        HashBagTests.assertEquals((int)1, (int)nullCount);
        HashBagTests.assertEquals((int)1, (int)oneCount);
        HashBagTests.assertEquals((int)2, (int)twoCount);
        HashBagTests.assertEquals((int)3, (int)threeCount);
        HashBagTests.assertEquals((int)4, (int)fourCount);
    }

    public void testToArray() {
        Object[] a = this.bag.toArray();
        HashBagTests.assertEquals((int)11, (int)a.length);
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, null));
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"one"));
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"two"));
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"three"));
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"four"));
    }

    public void testToArrayObjectArray() {
        Object[] a = new String[12];
        a[11] = "not null";
        String[] b = (String[])this.bag.toArray(a);
        HashBagTests.assertEquals((Object)a, (Object)b);
        HashBagTests.assertEquals((int)12, (int)a.length);
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, null));
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"one"));
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"two"));
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"three"));
        HashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"four"));
        HashBagTests.assertTrue((a[11] == null ? 1 : 0) != 0);
    }

    public void testToString() {
        String s = this.bag.toString();
        HashBagTests.assertTrue((boolean)s.startsWith("["));
        HashBagTests.assertTrue((boolean)s.endsWith("]"));
        int commaCount = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ',') {
                ++commaCount;
            }
            ++i;
        }
        HashBagTests.assertEquals((int)10, (int)commaCount);
        HashBagTests.assertTrue((s.indexOf("one") != -1 ? 1 : 0) != 0);
        HashBagTests.assertTrue((s.indexOf("two") != -1 ? 1 : 0) != 0);
        HashBagTests.assertTrue((s.indexOf("three") != -1 ? 1 : 0) != 0);
        HashBagTests.assertTrue((s.indexOf("four") != -1 ? 1 : 0) != 0);
        HashBagTests.assertTrue((s.indexOf("null") != -1 ? 1 : 0) != 0);
    }
}

