/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.GraphIterable;
import org.eclipse.jpt.common.utility.internal.iterators.GraphIterator;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIterableTests
extends TestCase {
    Collection<GraphNode> nodes = new ArrayList<GraphNode>();

    public GraphIterableTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testNeighbors1() {
        for (GraphNode gn : this.buildGraphIterable1()) {
            GraphIterableTests.assertTrue((boolean)this.nodes.contains(gn));
        }
    }

    private Iterable<GraphNode> buildGraphIterable1() {
        return new GraphIterable<GraphNode>(this.buildGraphRoot()){

            public Iterator<GraphNode> neighbors(GraphNode next) {
                return next.neighbors();
            }
        };
    }

    public void testNeighbors2() {
        for (GraphNode gn : this.buildGraphIterable2()) {
            GraphIterableTests.assertTrue((boolean)this.nodes.contains(gn));
        }
    }

    private Iterable<GraphNode> buildGraphIterable2() {
        return new GraphIterable((Object)this.buildGraphRoot(), this.buildMisterRogers());
    }

    public void testNeighbors3() {
        for (GraphNode gn : this.buildGraphIterable3()) {
            GraphIterableTests.assertTrue((boolean)this.nodes.contains(gn));
        }
    }

    private Iterable<GraphNode> buildGraphIterable3() {
        return new GraphIterable<GraphNode>(new GraphNode[]{this.buildGraphRoot()}){

            public Iterator<GraphNode> neighbors(GraphNode next) {
                return next.neighbors();
            }
        };
    }

    public void testNeighbors4() {
        for (GraphNode gn : this.buildGraphIterable4()) {
            GraphIterableTests.assertTrue((boolean)this.nodes.contains(gn));
        }
    }

    private Iterable<GraphNode> buildGraphIterable4() {
        return new GraphIterable((Object[])new GraphNode[]{this.buildGraphRoot()}, this.buildMisterRogers());
    }

    public void testToString() {
        GraphIterableTests.assertNotNull((Object)this.buildGraphIterable1().toString());
    }

    public void testMissingMisterRogers() {
        boolean exCaught = false;
        try {
            for (GraphNode gn : new GraphIterable((Object)this.buildGraphRoot())) {
                GraphIterableTests.assertTrue((boolean)this.nodes.contains(gn));
            }
            GraphIterableTests.fail();
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        GraphIterableTests.assertTrue((boolean)exCaught);
    }

    private GraphIterator.MisterRogers<GraphNode> buildMisterRogers() {
        return new GraphIterator.MisterRogers<GraphNode>(){

            public Iterator<GraphNode> neighbors(GraphNode next) {
                return next.neighbors();
            }
        };
    }

    private GraphNode buildGraphRoot() {
        GraphNode ncNode = new GraphNode("North Carolina");
        GraphNode vaNode = new GraphNode("Virginia");
        GraphNode scNode = new GraphNode("South Carolina");
        GraphNode gaNode = new GraphNode("Georgia");
        GraphNode flNode = new GraphNode("Florida");
        GraphNode alNode = new GraphNode("Alabama");
        GraphNode msNode = new GraphNode("Mississippi");
        GraphNode tnNode = new GraphNode("Tennessee");
        ncNode.setNeighbors(new GraphNode[]{vaNode, scNode, gaNode, tnNode});
        vaNode.setNeighbors(new GraphNode[]{ncNode, tnNode});
        scNode.setNeighbors(new GraphNode[]{ncNode, gaNode});
        gaNode.setNeighbors(new GraphNode[]{ncNode, scNode, flNode, alNode, tnNode});
        flNode.setNeighbors(new GraphNode[]{gaNode});
        alNode.setNeighbors(new GraphNode[]{gaNode, msNode, tnNode});
        msNode.setNeighbors(new GraphNode[]{alNode, tnNode});
        tnNode.setNeighbors(new GraphNode[]{vaNode, ncNode, gaNode, alNode, msNode});
        return ncNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GraphNode {
        private String name;
        private Collection<GraphNode> neighbors = new ArrayList<GraphNode>();

        public GraphNode(String name) {
            GraphIterableTests.this.nodes.add(this);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setNeighbors(GraphNode[] neighbors) {
            this.neighbors = CollectionTools.list((Object[])neighbors);
        }

        public Iterator<GraphNode> neighbors() {
            return this.neighbors.iterator();
        }

        public int neighborsSize() {
            return this.neighbors.size();
        }

        public String toString() {
            return "GraphNode(" + this.name + ")";
        }
    }
}

